/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.http.impl.entity;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.http.Header;
import org.graylog.shaded.elasticsearch7.org.apache.http.HttpEntity;
import org.graylog.shaded.elasticsearch7.org.apache.http.HttpException;
import org.graylog.shaded.elasticsearch7.org.apache.http.HttpMessage;
import org.graylog.shaded.elasticsearch7.org.apache.http.annotation.Contract;
import org.graylog.shaded.elasticsearch7.org.apache.http.annotation.ThreadingBehavior;
import org.graylog.shaded.elasticsearch7.org.apache.http.entity.BasicHttpEntity;
import org.graylog.shaded.elasticsearch7.org.apache.http.entity.ContentLengthStrategy;
import org.graylog.shaded.elasticsearch7.org.apache.http.impl.io.ChunkedInputStream;
import org.graylog.shaded.elasticsearch7.org.apache.http.impl.io.ContentLengthInputStream;
import org.graylog.shaded.elasticsearch7.org.apache.http.impl.io.IdentityInputStream;
import org.graylog.shaded.elasticsearch7.org.apache.http.io.SessionInputBuffer;
import org.graylog.shaded.elasticsearch7.org.apache.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inBuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inBuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inBuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inBuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inBuffer, message);
    }
}

