/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.it;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.LowerCaseFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.WordlistLoader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.it.ItalianLightStemFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.snowball.SnowballFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.ElisionFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.IOUtils;

public final class ItalianAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "italian_stop.txt";
    private static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet(new CharArraySet(Arrays.asList("c", "l", "all", "dall", "dell", "nell", "sull", "coll", "pell", "gl", "agl", "dagl", "degl", "negl", "sugl", "un", "m", "t", "s", "v", "d"), true));

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public ItalianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ItalianAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public ItalianAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new ElisionFilter(source, DEFAULT_ARTICLES);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new ItalianLightStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new ElisionFilter(in, DEFAULT_ARTICLES);
        result = new LowerCaseFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(SnowballFilter.class, ItalianAnalyzer.DEFAULT_STOPWORD_FILE, StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

