/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.TokenFilterFactory;

public class TruncateTokenFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "truncate";
    public static final String PREFIX_LENGTH_KEY = "prefixLength";
    private final byte prefixLength;

    public TruncateTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.prefixLength = Byte.parseByte(this.get(args, PREFIX_LENGTH_KEY, "5"));
        if (this.prefixLength < 1) {
            throw new IllegalArgumentException("prefixLength parameter must be a positive number: " + this.prefixLength);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameter(s): " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new TruncateTokenFilter(input, this.prefixLength);
    }
}

