/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LeafCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SimpleCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopDocsCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopFieldCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopScoreDocCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.GroupDocs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.TopGroups;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.PriorityQueue;

public class BlockGroupingCollector
extends SimpleCollector {
    private int[] pendingSubDocs;
    private float[] pendingSubScores;
    private int subDocUpto;
    private final Sort groupSort;
    private final int topNGroups;
    private final Weight lastDocPerGroup;
    private final boolean needsScores;
    private final FieldComparator<?>[] comparators;
    private final LeafFieldComparator[] leafComparators;
    private final int[] reversed;
    private final int compIDXEnd;
    private int bottomSlot;
    private boolean queueFull;
    private LeafReaderContext currentReaderContext;
    private int topGroupDoc;
    private int totalHitCount;
    private int totalGroupCount;
    private int docBase;
    private int groupEndDocID;
    private DocIdSetIterator lastDocPerGroupBits;
    private Scorable scorer;
    private final GroupQueue groupQueue;
    private boolean groupCompetes;

    private void processGroup() throws IOException {
        ++this.totalGroupCount;
        if (this.groupCompetes) {
            if (!this.queueFull) {
                OneGroup og = new OneGroup();
                og.count = this.subDocUpto;
                og.topGroupDoc = this.docBase + this.topGroupDoc;
                og.docs = this.pendingSubDocs;
                this.pendingSubDocs = new int[10];
                if (this.needsScores) {
                    og.scores = this.pendingSubScores;
                    this.pendingSubScores = new float[10];
                }
                og.readerContext = this.currentReaderContext;
                og.comparatorSlot = this.bottomSlot;
                OneGroup bottomGroup = this.groupQueue.add(og);
                boolean bl = this.queueFull = this.groupQueue.size() == this.topNGroups;
                if (this.queueFull) {
                    this.bottomSlot = bottomGroup.comparatorSlot;
                    for (int i = 0; i < this.comparators.length; ++i) {
                        this.leafComparators[i].setBottom(this.bottomSlot);
                    }
                } else {
                    this.bottomSlot = this.groupQueue.size();
                }
            } else {
                OneGroup og = (OneGroup)this.groupQueue.top();
                assert (og != null);
                og.count = this.subDocUpto;
                og.topGroupDoc = this.docBase + this.topGroupDoc;
                int[] savDocs = og.docs;
                og.docs = this.pendingSubDocs;
                this.pendingSubDocs = savDocs;
                if (this.needsScores) {
                    float[] savScores = og.scores;
                    og.scores = this.pendingSubScores;
                    this.pendingSubScores = savScores;
                }
                og.readerContext = this.currentReaderContext;
                this.bottomSlot = ((OneGroup)this.groupQueue.updateTop()).comparatorSlot;
                for (int i = 0; i < this.comparators.length; ++i) {
                    this.leafComparators[i].setBottom(this.bottomSlot);
                }
            }
        }
        this.subDocUpto = 0;
    }

    public BlockGroupingCollector(Sort groupSort, int topNGroups, boolean needsScores, Weight lastDocPerGroup) {
        if (topNGroups < 1) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + topNGroups + ")");
        }
        this.groupQueue = new GroupQueue(topNGroups);
        this.pendingSubDocs = new int[10];
        if (needsScores) {
            this.pendingSubScores = new float[10];
        }
        this.needsScores = needsScores;
        this.lastDocPerGroup = lastDocPerGroup;
        this.groupSort = groupSort;
        this.topNGroups = topNGroups;
        SortField[] sortFields = groupSort.getSort();
        this.comparators = new FieldComparator[sortFields.length];
        this.leafComparators = new LeafFieldComparator[sortFields.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            this.comparators[i] = sortField.getComparator(topNGroups, i);
            this.reversed[i] = sortField.getReverse() ? -1 : 1;
        }
    }

    public TopGroups<?> getTopGroups(Sort withinGroupSort, int groupOffset, int withinGroupOffset, int maxDocsPerGroup) throws IOException {
        if (this.subDocUpto != 0) {
            this.processGroup();
        }
        if (groupOffset >= this.groupQueue.size()) {
            return null;
        }
        int totalGroupedHitCount = 0;
        ScoreAndDoc fakeScorer = new ScoreAndDoc();
        float maxScore = Float.MIN_VALUE;
        GroupDocs[] groups = new GroupDocs[this.groupQueue.size() - groupOffset];
        for (int downTo = this.groupQueue.size() - groupOffset - 1; downTo >= 0; --downTo) {
            TopDocsCollector collector;
            OneGroup og = (OneGroup)this.groupQueue.pop();
            if (withinGroupSort.equals(Sort.RELEVANCE)) {
                if (!this.needsScores) {
                    throw new IllegalArgumentException("cannot sort by relevance within group: needsScores=false");
                }
                collector = TopScoreDocCollector.create(maxDocsPerGroup, Integer.MAX_VALUE);
            } else {
                collector = TopFieldCollector.create(withinGroupSort, maxDocsPerGroup, Integer.MAX_VALUE);
            }
            float groupMaxScore = this.needsScores ? Float.NEGATIVE_INFINITY : Float.NaN;
            LeafCollector leafCollector = collector.getLeafCollector(og.readerContext);
            leafCollector.setScorer(fakeScorer);
            for (int docIDX = 0; docIDX < og.count; ++docIDX) {
                int doc;
                fakeScorer.doc = doc = og.docs[docIDX];
                if (this.needsScores) {
                    fakeScorer.score = og.scores[docIDX];
                    groupMaxScore = Math.max(groupMaxScore, fakeScorer.score);
                }
                leafCollector.collect(doc);
            }
            totalGroupedHitCount += og.count;
            Object[] groupSortValues = new Comparable[this.comparators.length];
            for (int sortFieldIDX = 0; sortFieldIDX < this.comparators.length; ++sortFieldIDX) {
                groupSortValues[sortFieldIDX] = this.comparators[sortFieldIDX].value(og.comparatorSlot);
            }
            TopDocs topDocs = collector.topDocs(withinGroupOffset, maxDocsPerGroup);
            groups[downTo] = new GroupDocs<Object>(Float.NaN, groupMaxScore, new TotalHits(og.count, TotalHits.Relation.EQUAL_TO), topDocs.scoreDocs, null, groupSortValues);
            maxScore = Math.max(maxScore, groupMaxScore);
        }
        return new TopGroups(new TopGroups(this.groupSort.getSort(), withinGroupSort.getSort(), this.totalHitCount, totalGroupedHitCount, groups, maxScore), this.totalGroupCount);
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        this.scorer = scorer;
        for (LeafFieldComparator comparator : this.leafComparators) {
            comparator.setScorer(scorer);
        }
    }

    @Override
    public void collect(int doc) throws IOException {
        if (doc > this.groupEndDocID) {
            if (this.subDocUpto != 0) {
                this.processGroup();
            }
            this.groupEndDocID = this.lastDocPerGroupBits.advance(doc);
            this.subDocUpto = 0;
            this.groupCompetes = !this.queueFull;
        }
        ++this.totalHitCount;
        if (this.subDocUpto == this.pendingSubDocs.length) {
            this.pendingSubDocs = ArrayUtil.grow(this.pendingSubDocs);
        }
        this.pendingSubDocs[this.subDocUpto] = doc;
        if (this.needsScores) {
            if (this.subDocUpto == this.pendingSubScores.length) {
                this.pendingSubScores = ArrayUtil.grow(this.pendingSubScores);
            }
            this.pendingSubScores[this.subDocUpto] = this.scorer.score();
        }
        ++this.subDocUpto;
        if (this.groupCompetes) {
            if (this.subDocUpto == 1) {
                assert (!this.queueFull);
                for (LeafFieldComparator fc : this.leafComparators) {
                    fc.copy(this.bottomSlot, doc);
                    fc.setBottom(this.bottomSlot);
                }
                this.topGroupDoc = doc;
            } else {
                int compIDX = 0;
                while (true) {
                    int c;
                    if ((c = this.reversed[compIDX] * this.leafComparators[compIDX].compareBottom(doc)) < 0) {
                        return;
                    }
                    if (c > 0) break;
                    if (compIDX == this.compIDXEnd) {
                        return;
                    }
                    ++compIDX;
                }
                for (LeafFieldComparator fc : this.leafComparators) {
                    fc.copy(this.bottomSlot, doc);
                    fc.setBottom(this.bottomSlot);
                }
                this.topGroupDoc = doc;
            }
        } else {
            int compIDX = 0;
            while (true) {
                int c;
                if ((c = this.reversed[compIDX] * this.leafComparators[compIDX].compareBottom(doc)) < 0) {
                    return;
                }
                if (c > 0) break;
                if (compIDX == this.compIDXEnd) {
                    return;
                }
                ++compIDX;
            }
            this.groupCompetes = true;
            for (LeafFieldComparator fc : this.leafComparators) {
                fc.copy(this.bottomSlot, doc);
                fc.setBottom(this.bottomSlot);
            }
            this.topGroupDoc = doc;
        }
    }

    @Override
    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        if (this.subDocUpto != 0) {
            this.processGroup();
        }
        this.subDocUpto = 0;
        this.docBase = readerContext.docBase;
        Scorer s = this.lastDocPerGroup.scorer(readerContext);
        this.lastDocPerGroupBits = s == null ? null : s.iterator();
        this.groupEndDocID = -1;
        this.currentReaderContext = readerContext;
        for (int i = 0; i < this.comparators.length; ++i) {
            this.leafComparators[i] = this.comparators[i].getLeafComparator(readerContext);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    private static class ScoreAndDoc
    extends Scorable {
        float score;
        int doc = -1;

        private ScoreAndDoc() {
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public float score() {
            return this.score;
        }
    }

    private final class GroupQueue
    extends PriorityQueue<OneGroup> {
        public GroupQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(OneGroup group1, OneGroup group2) {
            assert (group1 != group2);
            assert (group1.comparatorSlot != group2.comparatorSlot);
            int numComparators = BlockGroupingCollector.this.comparators.length;
            for (int compIDX = 0; compIDX < numComparators; ++compIDX) {
                int c = BlockGroupingCollector.this.reversed[compIDX] * BlockGroupingCollector.this.comparators[compIDX].compare(group1.comparatorSlot, group2.comparatorSlot);
                if (c == 0) continue;
                return c > 0;
            }
            return group1.topGroupDoc > group2.topGroupDoc;
        }
    }

    private static final class OneGroup {
        LeafReaderContext readerContext;
        int topGroupDoc;
        int[] docs;
        float[] scores;
        int count;
        int comparatorSlot;

        private OneGroup() {
        }
    }
}

