/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.GroupFacetCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.SentinelIntSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.UnicodeUtil;

public abstract class TermGroupFacetCollector
extends GroupFacetCollector {
    final List<GroupedFacetHit> groupedFacetHits;
    final SentinelIntSet segmentGroupedFacetHits;
    SortedDocValues groupFieldTermsIndex;

    public static TermGroupFacetCollector createTermGroupFacetCollector(String groupField, String facetField, boolean facetFieldMultivalued, BytesRef facetPrefix, int initialSize) {
        if (facetFieldMultivalued) {
            return new MV(groupField, facetField, facetPrefix, initialSize);
        }
        return new SV(groupField, facetField, facetPrefix, initialSize);
    }

    TermGroupFacetCollector(String groupField, String facetField, BytesRef facetPrefix, int initialSize) {
        super(groupField, facetField, facetPrefix);
        this.groupedFacetHits = new ArrayList<GroupedFacetHit>(initialSize);
        this.segmentGroupedFacetHits = new SentinelIntSet(initialSize, Integer.MIN_VALUE);
    }

    private static class GroupedFacetHit {
        final BytesRef groupValue;
        final BytesRef facetValue;

        GroupedFacetHit(BytesRef groupValue, BytesRef facetValue) {
            this.groupValue = groupValue;
            this.facetValue = facetValue;
        }
    }

    static class MV
    extends TermGroupFacetCollector {
        private SortedSetDocValues facetFieldDocTermOrds;
        private TermsEnum facetOrdTermsEnum;
        private int facetFieldNumTerms;

        MV(String groupField, String facetField, BytesRef facetPrefix, int initialSize) {
            super(groupField, facetField, facetPrefix, initialSize);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (doc > this.groupFieldTermsIndex.docID()) {
                this.groupFieldTermsIndex.advance(doc);
            }
            int groupOrd = doc == this.groupFieldTermsIndex.docID() ? this.groupFieldTermsIndex.ordValue() : -1;
            if (this.facetFieldNumTerms == 0) {
                int segmentGroupedFacetsIndex = groupOrd * (this.facetFieldNumTerms + 1);
                if (this.facetPrefix != null || this.segmentGroupedFacetHits.exists(segmentGroupedFacetsIndex)) {
                    return;
                }
                ++this.segmentTotalCount;
                int n = this.facetFieldNumTerms;
                this.segmentFacetCounts[n] = this.segmentFacetCounts[n] + 1;
                this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
                BytesRef groupKey = groupOrd == -1 ? null : BytesRef.deepCopyOf(this.groupFieldTermsIndex.lookupOrd(groupOrd));
                this.groupedFacetHits.add(new GroupedFacetHit(groupKey, null));
                return;
            }
            if (doc > this.facetFieldDocTermOrds.docID()) {
                this.facetFieldDocTermOrds.advance(doc);
            }
            boolean empty = true;
            if (doc == this.facetFieldDocTermOrds.docID()) {
                long ord;
                while ((ord = this.facetFieldDocTermOrds.nextOrd()) != -1L) {
                    this.process(groupOrd, (int)ord);
                    empty = false;
                }
            }
            if (empty) {
                this.process(groupOrd, this.facetFieldNumTerms);
            }
        }

        private void process(int groupOrd, int facetOrd) throws IOException {
            if (facetOrd < this.startFacetOrd || facetOrd >= this.endFacetOrd) {
                return;
            }
            int segmentGroupedFacetsIndex = groupOrd * (this.facetFieldNumTerms + 1) + facetOrd;
            if (this.segmentGroupedFacetHits.exists(segmentGroupedFacetsIndex)) {
                return;
            }
            ++this.segmentTotalCount;
            int n = facetOrd;
            this.segmentFacetCounts[n] = this.segmentFacetCounts[n] + 1;
            this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
            BytesRef groupKey = groupOrd == -1 ? null : BytesRef.deepCopyOf(this.groupFieldTermsIndex.lookupOrd(groupOrd));
            BytesRef facetValue = facetOrd == this.facetFieldNumTerms ? null : BytesRef.deepCopyOf(this.facetFieldDocTermOrds.lookupOrd(facetOrd));
            this.groupedFacetHits.add(new GroupedFacetHit(groupKey, facetValue));
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            if (this.segmentFacetCounts != null) {
                this.segmentResults.add(this.createSegmentResult());
            }
            this.groupFieldTermsIndex = DocValues.getSorted(context.reader(), this.groupField);
            this.facetFieldDocTermOrds = DocValues.getSortedSet(context.reader(), this.facetField);
            this.facetFieldNumTerms = (int)this.facetFieldDocTermOrds.getValueCount();
            this.facetOrdTermsEnum = this.facetFieldNumTerms == 0 ? null : this.facetFieldDocTermOrds.termsEnum();
            this.segmentFacetCounts = new int[this.facetFieldNumTerms + 1];
            this.segmentTotalCount = 0;
            this.segmentGroupedFacetHits.clear();
            for (GroupedFacetHit groupedFacetHit : this.groupedFacetHits) {
                int facetOrd;
                int groupOrd;
                int n = groupOrd = groupedFacetHit.groupValue == null ? -1 : this.groupFieldTermsIndex.lookupTerm(groupedFacetHit.groupValue);
                if (groupedFacetHit.groupValue != null && groupOrd < 0) continue;
                if (groupedFacetHit.facetValue != null) {
                    if (this.facetOrdTermsEnum == null || !this.facetOrdTermsEnum.seekExact(groupedFacetHit.facetValue)) continue;
                    facetOrd = (int)this.facetOrdTermsEnum.ord();
                } else {
                    facetOrd = this.facetFieldNumTerms;
                }
                int segmentGroupedFacetsIndex = groupOrd * (this.facetFieldNumTerms + 1) + facetOrd;
                this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
            }
            if (this.facetPrefix != null) {
                TermsEnum.SeekStatus seekStatus = this.facetOrdTermsEnum != null ? this.facetOrdTermsEnum.seekCeil(this.facetPrefix) : TermsEnum.SeekStatus.END;
                if (seekStatus == TermsEnum.SeekStatus.END) {
                    this.startFacetOrd = 0;
                    this.endFacetOrd = 0;
                    return;
                }
                this.startFacetOrd = (int)this.facetOrdTermsEnum.ord();
                BytesRefBuilder facetEndPrefix = new BytesRefBuilder();
                facetEndPrefix.append(this.facetPrefix);
                facetEndPrefix.append(UnicodeUtil.BIG_TERM);
                seekStatus = this.facetOrdTermsEnum.seekCeil(facetEndPrefix.get());
                this.endFacetOrd = seekStatus != TermsEnum.SeekStatus.END ? (int)this.facetOrdTermsEnum.ord() : this.facetFieldNumTerms;
            } else {
                this.startFacetOrd = 0;
                this.endFacetOrd = this.facetFieldNumTerms + 1;
            }
        }

        @Override
        protected SegmentResult createSegmentResult() throws IOException {
            return new SegmentResult(this.segmentFacetCounts, this.segmentTotalCount, this.facetFieldNumTerms, this.facetOrdTermsEnum, this.startFacetOrd, this.endFacetOrd);
        }

        private static class SegmentResult
        extends GroupFacetCollector.SegmentResult {
            final TermsEnum tenum;

            SegmentResult(int[] counts, int total, int missingCountIndex, TermsEnum tenum, int startFacetOrd, int endFacetOrd) throws IOException {
                super(counts, total - counts[missingCountIndex], counts[missingCountIndex], endFacetOrd == missingCountIndex + 1 ? missingCountIndex : endFacetOrd);
                this.tenum = tenum;
                this.mergePos = startFacetOrd;
                if (tenum != null) {
                    tenum.seekExact(this.mergePos);
                    this.mergeTerm = tenum.term();
                }
            }

            @Override
            protected void nextTerm() throws IOException {
                this.mergeTerm = this.tenum.next();
            }
        }
    }

    static class SV
    extends TermGroupFacetCollector {
        private SortedDocValues facetFieldTermsIndex;

        SV(String groupField, String facetField, BytesRef facetPrefix, int initialSize) {
            super(groupField, facetField, facetPrefix, initialSize);
        }

        @Override
        public void collect(int doc) throws IOException {
            int groupOrd;
            int segmentGroupedFacetsIndex;
            int facetOrd;
            if (doc > this.facetFieldTermsIndex.docID()) {
                this.facetFieldTermsIndex.advance(doc);
            }
            if ((facetOrd = doc == this.facetFieldTermsIndex.docID() ? this.facetFieldTermsIndex.ordValue() : -1) < this.startFacetOrd || facetOrd >= this.endFacetOrd) {
                return;
            }
            if (doc > this.groupFieldTermsIndex.docID()) {
                this.groupFieldTermsIndex.advance(doc);
            }
            if (this.segmentGroupedFacetHits.exists(segmentGroupedFacetsIndex = (groupOrd = doc == this.groupFieldTermsIndex.docID() ? this.groupFieldTermsIndex.ordValue() : -1) * (this.facetFieldTermsIndex.getValueCount() + 1) + facetOrd)) {
                return;
            }
            ++this.segmentTotalCount;
            int n = facetOrd + 1;
            this.segmentFacetCounts[n] = this.segmentFacetCounts[n] + 1;
            this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
            BytesRef groupKey = groupOrd == -1 ? null : BytesRef.deepCopyOf(this.groupFieldTermsIndex.lookupOrd(groupOrd));
            BytesRef facetKey = facetOrd == -1 ? null : BytesRef.deepCopyOf(this.facetFieldTermsIndex.lookupOrd(facetOrd));
            this.groupedFacetHits.add(new GroupedFacetHit(groupKey, facetKey));
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            if (this.segmentFacetCounts != null) {
                this.segmentResults.add(this.createSegmentResult());
            }
            this.groupFieldTermsIndex = DocValues.getSorted(context.reader(), this.groupField);
            this.facetFieldTermsIndex = DocValues.getSorted(context.reader(), this.facetField);
            this.segmentFacetCounts = new int[this.facetFieldTermsIndex.getValueCount() + 1];
            this.segmentTotalCount = 0;
            this.segmentGroupedFacetHits.clear();
            for (GroupedFacetHit groupedFacetHit : this.groupedFacetHits) {
                int groupOrd;
                int facetOrd;
                int n = facetOrd = groupedFacetHit.facetValue == null ? -1 : this.facetFieldTermsIndex.lookupTerm(groupedFacetHit.facetValue);
                if (groupedFacetHit.facetValue != null && facetOrd < 0) continue;
                int n2 = groupOrd = groupedFacetHit.groupValue == null ? -1 : this.groupFieldTermsIndex.lookupTerm(groupedFacetHit.groupValue);
                if (groupedFacetHit.groupValue != null && groupOrd < 0) continue;
                int segmentGroupedFacetsIndex = groupOrd * (this.facetFieldTermsIndex.getValueCount() + 1) + facetOrd;
                this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
            }
            if (this.facetPrefix != null) {
                this.startFacetOrd = this.facetFieldTermsIndex.lookupTerm(this.facetPrefix);
                if (this.startFacetOrd < 0) {
                    this.startFacetOrd = -this.startFacetOrd - 1;
                }
                BytesRefBuilder facetEndPrefix = new BytesRefBuilder();
                facetEndPrefix.append(this.facetPrefix);
                facetEndPrefix.append(UnicodeUtil.BIG_TERM);
                this.endFacetOrd = this.facetFieldTermsIndex.lookupTerm(facetEndPrefix.get());
                assert (this.endFacetOrd < 0);
                this.endFacetOrd = -this.endFacetOrd - 1;
            } else {
                this.startFacetOrd = -1;
                this.endFacetOrd = this.facetFieldTermsIndex.getValueCount();
            }
        }

        @Override
        protected SegmentResult createSegmentResult() throws IOException {
            return new SegmentResult(this.segmentFacetCounts, this.segmentTotalCount, this.facetFieldTermsIndex.termsEnum(), this.startFacetOrd, this.endFacetOrd);
        }

        private static class SegmentResult
        extends GroupFacetCollector.SegmentResult {
            final TermsEnum tenum;

            SegmentResult(int[] counts, int total, TermsEnum tenum, int startFacetOrd, int endFacetOrd) throws IOException {
                super(counts, total - counts[0], counts[0], endFacetOrd + 1);
                this.tenum = tenum;
                int n = this.mergePos = startFacetOrd == -1 ? 1 : startFacetOrd + 1;
                if (this.mergePos < this.maxTermPos) {
                    assert (tenum != null);
                    tenum.seekExact(startFacetOrd == -1 ? 0L : (long)startFacetOrd);
                    this.mergeTerm = tenum.term();
                }
            }

            @Override
            protected void nextTerm() throws IOException {
                this.mergeTerm = this.tenum.next();
            }
        }
    }
}

