/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities;

import java.util.ArrayList;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInvertState;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.CollectionStatistics;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermStatistics;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.Similarity;

public class MultiSimilarity
extends Similarity {
    protected final Similarity[] sims;

    public MultiSimilarity(Similarity[] sims) {
        this.sims = sims;
    }

    @Override
    public long computeNorm(FieldInvertState state) {
        return this.sims[0].computeNorm(state);
    }

    @Override
    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Similarity.SimScorer[] subScorers = new Similarity.SimScorer[this.sims.length];
        for (int i = 0; i < subScorers.length; ++i) {
            subScorers[i] = this.sims[i].scorer(boost, collectionStats, termStats);
        }
        return new MultiSimScorer(subScorers);
    }

    static class MultiSimScorer
    extends Similarity.SimScorer {
        private final Similarity.SimScorer[] subScorers;

        MultiSimScorer(Similarity.SimScorer[] subScorers) {
            this.subScorers = subScorers;
        }

        @Override
        public float score(float freq, long norm) {
            float sum = 0.0f;
            for (Similarity.SimScorer subScorer : this.subScorers) {
                sum += subScorer.score(freq, norm);
            }
            return sum;
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            for (Similarity.SimScorer subScorer : this.subScorers) {
                subs.add(subScorer.explain(freq, norm));
            }
            return Explanation.match((Number)Float.valueOf(this.score(freq.getValue().floatValue(), norm)), "sum of:", subs);
        }
    }
}

