/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.util;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.CharsRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.UnicodeUtil;

public class CharsRefBuilder
implements Appendable {
    private static final String NULL_STRING = "null";
    private final CharsRef ref = new CharsRef();

    public char[] chars() {
        return this.ref.chars;
    }

    public int length() {
        return this.ref.length;
    }

    public void setLength(int length) {
        this.ref.length = length;
    }

    public char charAt(int offset) {
        return this.ref.chars[offset];
    }

    public void setCharAt(int offset, char b) {
        this.ref.chars[offset] = b;
    }

    public void clear() {
        this.ref.length = 0;
    }

    @Override
    public CharsRefBuilder append(CharSequence csq) {
        if (csq == null) {
            return this.append(NULL_STRING);
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    public CharsRefBuilder append(CharSequence csq, int start, int end) {
        if (csq == null) {
            return this.append(NULL_STRING);
        }
        this.grow(this.ref.length + end - start);
        for (int i = start; i < end; ++i) {
            this.setCharAt(this.ref.length++, csq.charAt(i));
        }
        return this;
    }

    @Override
    public CharsRefBuilder append(char c) {
        this.grow(this.ref.length + 1);
        this.setCharAt(this.ref.length++, c);
        return this;
    }

    public void copyChars(CharsRef other) {
        this.copyChars(other.chars, other.offset, other.length);
    }

    public void grow(int newLength) {
        this.ref.chars = ArrayUtil.grow(this.ref.chars, newLength);
    }

    public void copyUTF8Bytes(byte[] bytes, int offset, int length) {
        this.grow(length);
        this.ref.length = UnicodeUtil.UTF8toUTF16(bytes, offset, length, this.ref.chars);
    }

    public void copyUTF8Bytes(BytesRef bytes) {
        this.copyUTF8Bytes(bytes.bytes, bytes.offset, bytes.length);
    }

    public void copyChars(char[] otherChars, int otherOffset, int otherLength) {
        this.grow(otherLength);
        System.arraycopy(otherChars, otherOffset, this.ref.chars, 0, otherLength);
        this.ref.length = otherLength;
    }

    public void append(char[] otherChars, int otherOffset, int otherLength) {
        int newLen = this.ref.length + otherLength;
        this.grow(newLen);
        System.arraycopy(otherChars, otherOffset, this.ref.chars, this.ref.length, otherLength);
        this.ref.length = newLen;
    }

    public CharsRef get() {
        assert (this.ref.offset == 0) : "Modifying the offset of the returned ref is illegal";
        return this.ref;
    }

    public CharsRef toCharsRef() {
        return new CharsRef(ArrayUtil.copyOfSubArray(this.ref.chars, 0, this.ref.length), 0, this.ref.length);
    }

    public String toString() {
        return this.get().toString();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

