/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Node;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.NodeSelector;

public final class HasAttributeNodeSelector
implements NodeSelector {
    private final String key;
    private final String value;

    public HasAttributeNodeSelector(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void select(Iterable<Node> nodes) {
        Iterator<Node> itr = nodes.iterator();
        while (itr.hasNext()) {
            List<String> values;
            Map<String, List<String>> allAttributes = itr.next().getAttributes();
            if (allAttributes == null || (values = allAttributes.get(this.key)) != null && values.contains(this.value)) continue;
            itr.remove();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasAttributeNodeSelector that = (HasAttributeNodeSelector)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

