/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ccr;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ccr.FollowConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ccr.PutFollowRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public final class PutAutoFollowPatternRequest
extends FollowConfig
implements Validatable,
ToXContentObject {
    static final ParseField LEADER_PATTERNS_FIELD = new ParseField("leader_index_patterns", new String[0]);
    static final ParseField FOLLOW_PATTERN_FIELD = new ParseField("follow_index_pattern", new String[0]);
    private final String name;
    private final String remoteCluster;
    private final List<String> leaderIndexPatterns;
    private String followIndexNamePattern;

    public PutAutoFollowPatternRequest(String name, String remoteCluster, List<String> leaderIndexPatterns) {
        this.name = Objects.requireNonNull(name);
        this.remoteCluster = Objects.requireNonNull(remoteCluster);
        this.leaderIndexPatterns = Objects.requireNonNull(leaderIndexPatterns);
    }

    public String getName() {
        return this.name;
    }

    public String getRemoteCluster() {
        return this.remoteCluster;
    }

    public List<String> getLeaderIndexPatterns() {
        return this.leaderIndexPatterns;
    }

    public String getFollowIndexNamePattern() {
        return this.followIndexNamePattern;
    }

    public void setFollowIndexNamePattern(String followIndexNamePattern) {
        this.followIndexNamePattern = followIndexNamePattern;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PutFollowRequest.REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
        builder.field(LEADER_PATTERNS_FIELD.getPreferredName(), this.leaderIndexPatterns);
        if (this.followIndexNamePattern != null) {
            builder.field(FOLLOW_PATTERN_FIELD.getPreferredName(), this.followIndexNamePattern);
        }
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutAutoFollowPatternRequest that = (PutAutoFollowPatternRequest)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.remoteCluster, that.remoteCluster) && Objects.equals(this.leaderIndexPatterns, that.leaderIndexPatterns) && Objects.equals(this.followIndexNamePattern, that.followIndexNamePattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.remoteCluster, this.leaderIndexPatterns, this.followIndexNamePattern);
    }
}

