/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.core.PageParams;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.calendars.Calendar;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.config.Job;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetCalendarEventsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ConstructingObjectParser<GetCalendarEventsRequest, Void> PARSER = new ConstructingObjectParser("get_calendar_events_request", a -> new GetCalendarEventsRequest((String)a[0]));
    private final String calendarId;
    private String start;
    private String end;
    private String jobId;
    private PageParams pageParams;

    public GetCalendarEventsRequest(String calendarId) {
        this.calendarId = Objects.requireNonNull(calendarId, "[calendar_id] must not be null.");
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Calendar.ID.getPreferredName(), this.calendarId);
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.jobId != null) {
            builder.field(Job.ID.getPreferredName(), this.jobId);
        }
        if (this.pageParams != null) {
            builder.field(PageParams.PAGE.getPreferredName(), this.pageParams);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.calendarId, this.start, this.end, this.jobId, this.pageParams);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GetCalendarEventsRequest other = (GetCalendarEventsRequest)obj;
        return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.jobId, other.jobId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Calendar.ID);
        PARSER.declareString(GetCalendarEventsRequest::setStart, START);
        PARSER.declareString(GetCalendarEventsRequest::setEnd, END);
        PARSER.declareString(GetCalendarEventsRequest::setJobId, Job.ID);
        PARSER.declareObject(GetCalendarEventsRequest::setPageParams, PageParams.PARSER, PageParams.PAGE);
    }
}

