/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.QueryConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class DataFrameAnalyticsSource
implements ToXContentObject {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField _SOURCE = new ParseField("_source", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("data_frame_analytics_source", true, () -> new Builder());
    private final String[] index;
    private final QueryConfig queryConfig;
    private final FetchSourceContext sourceFiltering;

    public static DataFrameAnalyticsSource fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private DataFrameAnalyticsSource(String[] index, @Nullable QueryConfig queryConfig, @Nullable FetchSourceContext sourceFiltering) {
        this.index = Objects.requireNonNull(index);
        this.queryConfig = queryConfig;
        this.sourceFiltering = sourceFiltering;
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public FetchSourceContext getSourceFiltering() {
        return this.sourceFiltering;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        if (this.queryConfig != null) {
            builder.field(QUERY.getPreferredName(), this.queryConfig.getQuery());
        }
        if (this.sourceFiltering != null) {
            builder.field(_SOURCE.getPreferredName(), this.sourceFiltering);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsSource other = (DataFrameAnalyticsSource)o;
        return Arrays.equals(this.index, other.index) && Objects.equals(this.queryConfig, other.queryConfig) && Objects.equals(this.sourceFiltering, other.sourceFiltering);
    }

    public int hashCode() {
        return Objects.hash(Arrays.asList(this.index), this.queryConfig, this.sourceFiltering);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareStringArray(Builder::setIndex, INDEX);
        PARSER.declareObject(Builder::setQueryConfig, (p, c) -> QueryConfig.fromXContent(p), QUERY);
        PARSER.declareField(Builder::setSourceFiltering, (p, c) -> FetchSourceContext.fromXContent(p), _SOURCE, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
    }

    public static class Builder {
        private String[] index;
        private QueryConfig queryConfig;
        private FetchSourceContext sourceFiltering;

        private Builder() {
        }

        public Builder setIndex(String ... index) {
            this.index = index;
            return this;
        }

        public Builder setIndex(List<String> index) {
            this.index = index.toArray(new String[0]);
            return this;
        }

        public Builder setQueryConfig(QueryConfig queryConfig) {
            this.queryConfig = queryConfig;
            return this;
        }

        public Builder setSourceFiltering(FetchSourceContext sourceFiltering) {
            this.sourceFiltering = sourceFiltering;
            return this;
        }

        public DataFrameAnalyticsSource build() {
            return new DataFrameAnalyticsSource(this.index, this.queryConfig, this.sourceFiltering);
        }
    }
}

