/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class MulticlassConfusionMatrixMetric
implements EvaluationMetric {
    public static final String NAME = "multiclass_confusion_matrix";
    public static final ParseField SIZE = new ParseField("size", new String[0]);
    private static final ConstructingObjectParser<MulticlassConfusionMatrixMetric, Void> PARSER = MulticlassConfusionMatrixMetric.createParser();
    private final Integer size;

    private static ConstructingObjectParser<MulticlassConfusionMatrixMetric, Void> createParser() {
        ConstructingObjectParser<MulticlassConfusionMatrixMetric, Void> parser = new ConstructingObjectParser<MulticlassConfusionMatrixMetric, Void>(NAME, true, args -> new MulticlassConfusionMatrixMetric((Integer)args[0]));
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), SIZE);
        return parser;
    }

    public static MulticlassConfusionMatrixMetric fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public MulticlassConfusionMatrixMetric() {
        this(null);
    }

    public MulticlassConfusionMatrixMetric(@Nullable Integer size) {
        this.size = size;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.size != null) {
            builder.field(SIZE.getPreferredName(), this.size);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MulticlassConfusionMatrixMetric that = (MulticlassConfusionMatrixMetric)o;
        return Objects.equals(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hash(this.size);
    }

    public static class PredictedClass
    implements ToXContentObject {
        private static final ParseField PREDICTED_CLASS = new ParseField("predicted_class", new String[0]);
        private static final ParseField COUNT = new ParseField("count", new String[0]);
        private static final ConstructingObjectParser<PredictedClass, Void> PARSER = new ConstructingObjectParser("multiclass_confusion_matrix_predicted_class", true, a -> new PredictedClass((String)a[0], (Long)a[1]));
        private final String predictedClass;
        private final Long count;

        public PredictedClass(@Nullable String predictedClass, @Nullable Long count) {
            this.predictedClass = predictedClass;
            this.count = count;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.predictedClass != null) {
                builder.field(PREDICTED_CLASS.getPreferredName(), this.predictedClass);
            }
            if (this.count != null) {
                builder.field(COUNT.getPreferredName(), this.count);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredictedClass that = (PredictedClass)o;
            return Objects.equals(this.predictedClass, that.predictedClass) && Objects.equals(this.count, that.count);
        }

        public int hashCode() {
            return Objects.hash(this.predictedClass, this.count);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTED_CLASS);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), COUNT);
        }
    }

    public static class ActualClass
    implements ToXContentObject {
        private static final ParseField ACTUAL_CLASS = new ParseField("actual_class", new String[0]);
        private static final ParseField ACTUAL_CLASS_DOC_COUNT = new ParseField("actual_class_doc_count", new String[0]);
        private static final ParseField PREDICTED_CLASSES = new ParseField("predicted_classes", new String[0]);
        private static final ParseField OTHER_PREDICTED_CLASS_DOC_COUNT = new ParseField("other_predicted_class_doc_count", new String[0]);
        private static final ConstructingObjectParser<ActualClass, Void> PARSER = new ConstructingObjectParser("multiclass_confusion_matrix_actual_class", true, a -> new ActualClass((String)a[0], (Long)a[1], (List)a[2], (Long)a[3]));
        private final String actualClass;
        private final Long actualClassDocCount;
        private final List<PredictedClass> predictedClasses;
        private final Long otherPredictedClassDocCount;

        public ActualClass(@Nullable String actualClass, @Nullable Long actualClassDocCount, @Nullable List<PredictedClass> predictedClasses, @Nullable Long otherPredictedClassDocCount) {
            this.actualClass = actualClass;
            this.actualClassDocCount = actualClassDocCount;
            this.predictedClasses = predictedClasses != null ? Collections.unmodifiableList(predictedClasses) : null;
            this.otherPredictedClassDocCount = otherPredictedClassDocCount;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.actualClass != null) {
                builder.field(ACTUAL_CLASS.getPreferredName(), this.actualClass);
            }
            if (this.actualClassDocCount != null) {
                builder.field(ACTUAL_CLASS_DOC_COUNT.getPreferredName(), this.actualClassDocCount);
            }
            if (this.predictedClasses != null) {
                builder.field(PREDICTED_CLASSES.getPreferredName(), this.predictedClasses);
            }
            if (this.otherPredictedClassDocCount != null) {
                builder.field(OTHER_PREDICTED_CLASS_DOC_COUNT.getPreferredName(), this.otherPredictedClassDocCount);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActualClass that = (ActualClass)o;
            return Objects.equals(this.actualClass, that.actualClass) && Objects.equals(this.actualClassDocCount, that.actualClassDocCount) && Objects.equals(this.predictedClasses, that.predictedClasses) && Objects.equals(this.otherPredictedClassDocCount, that.otherPredictedClassDocCount);
        }

        public int hashCode() {
            return Objects.hash(this.actualClass, this.actualClassDocCount, this.predictedClasses, this.otherPredictedClassDocCount);
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ACTUAL_CLASS);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ACTUAL_CLASS_DOC_COUNT);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), PredictedClass.PARSER, PREDICTED_CLASSES);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), OTHER_PREDICTED_CLASS_DOC_COUNT);
        }
    }

    public static class Result
    implements EvaluationMetric.Result {
        private static final ParseField CONFUSION_MATRIX = new ParseField("confusion_matrix", new String[0]);
        private static final ParseField OTHER_ACTUAL_CLASS_COUNT = new ParseField("other_actual_class_count", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("multiclass_confusion_matrix_result", true, a -> new Result((List)a[0], (Long)a[1]));
        private final List<ActualClass> confusionMatrix;
        private final Long otherActualClassCount;

        public static Result fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Result(@Nullable List<ActualClass> confusionMatrix, @Nullable Long otherActualClassCount) {
            this.confusionMatrix = confusionMatrix != null ? Collections.unmodifiableList(Objects.requireNonNull(confusionMatrix)) : null;
            this.otherActualClassCount = otherActualClassCount;
        }

        @Override
        public String getMetricName() {
            return MulticlassConfusionMatrixMetric.NAME;
        }

        public List<ActualClass> getConfusionMatrix() {
            return this.confusionMatrix;
        }

        public Long getOtherActualClassCount() {
            return this.otherActualClassCount;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.confusionMatrix != null) {
                builder.field(CONFUSION_MATRIX.getPreferredName(), this.confusionMatrix);
            }
            if (this.otherActualClassCount != null) {
                builder.field(OTHER_ACTUAL_CLASS_COUNT.getPreferredName(), this.otherActualClassCount);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.confusionMatrix, that.confusionMatrix) && Objects.equals(this.otherActualClassCount, that.otherActualClassCount);
        }

        public int hashCode() {
            return Objects.hash(this.confusionMatrix, this.otherActualClassCount);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), ActualClass.PARSER, CONFUSION_MATRIX);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), OTHER_ACTUAL_CLASS_COUNT);
        }
    }
}

