/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security.RefreshPolicy;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.CharArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public final class ChangePasswordRequest
implements Validatable,
ToXContentObject {
    private final String username;
    private final char[] password;
    private final RefreshPolicy refreshPolicy;

    public ChangePasswordRequest(@Nullable String username, char[] password, RefreshPolicy refreshPolicy) {
        this.username = username;
        this.password = Objects.requireNonNull(password, "password is required");
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        byte[] charBytes = CharArrays.toUtf8Bytes(this.password);
        try {
            XContentBuilder xContentBuilder = builder.startObject().field("password").utf8Value(charBytes, 0, charBytes.length).endObject();
            return xContentBuilder;
        }
        finally {
            Arrays.fill(charBytes, (byte)0);
        }
    }
}

