/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.regex.Regex;

public final class ClusterNameExpressionResolver {
    private final WildcardExpressionResolver wildcardResolver = new WildcardExpressionResolver();

    public List<String> resolveClusterNames(Set<String> remoteClusters, String clusterExpression) {
        if (remoteClusters.contains(clusterExpression)) {
            return Collections.singletonList(clusterExpression);
        }
        if (Regex.isSimpleMatchPattern(clusterExpression)) {
            return this.wildcardResolver.resolve(remoteClusters, clusterExpression);
        }
        return Collections.emptyList();
    }

    private static class WildcardExpressionResolver {
        private WildcardExpressionResolver() {
        }

        private List<String> resolve(Set<String> remoteClusters, String clusterExpression) {
            if (this.isTrivialWildcard(clusterExpression)) {
                return this.resolveTrivialWildcard(remoteClusters);
            }
            Set<String> matches = WildcardExpressionResolver.matches(remoteClusters, clusterExpression);
            if (matches.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(matches);
        }

        private boolean isTrivialWildcard(String clusterExpression) {
            return Regex.isMatchAllPattern(clusterExpression);
        }

        private List<String> resolveTrivialWildcard(Set<String> remoteClusters) {
            return new ArrayList<String>(remoteClusters);
        }

        private static Set<String> matches(Set<String> remoteClusters, String expression) {
            return WildcardExpressionResolver.otherWildcard(remoteClusters, expression);
        }

        private static Set<String> otherWildcard(Set<String> remoteClusters, String expression) {
            String pattern = expression;
            return remoteClusters.stream().filter(n -> Regex.simpleMatch(pattern, n)).collect(Collectors.toSet());
        }
    }
}

