/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.AbstractDiffable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.Diff;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Metadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesArray;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.MapBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.compress.CompressedXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.set.Sets;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class IndexTemplateMetadata
extends AbstractDiffable<IndexTemplateMetadata> {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(IndexTemplateMetadata.class));
    private final String name;
    private final int order;
    @Nullable
    private final Integer version;
    private final List<String> patterns;
    private final Settings settings;
    private final ImmutableOpenMap<String, CompressedXContent> mappings;
    private final ImmutableOpenMap<String, AliasMetadata> aliases;

    public IndexTemplateMetadata(String name, int order, Integer version, List<String> patterns, Settings settings, ImmutableOpenMap<String, CompressedXContent> mappings, ImmutableOpenMap<String, AliasMetadata> aliases) {
        if (patterns == null || patterns.isEmpty()) {
            throw new IllegalArgumentException("Index patterns must not be null or empty; got " + patterns);
        }
        this.name = name;
        this.order = order;
        this.version = version;
        this.patterns = patterns;
        this.settings = settings;
        this.mappings = mappings;
        if (this.mappings.size() > 1) {
            deprecationLogger.deprecatedAndMaybeLog("index-templates", "Index template {} contains multiple typed mappings; templates in 8x will only support a single mapping", name);
        }
        this.aliases = aliases;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    public int getOrder() {
        return this.order();
    }

    @Nullable
    public Integer getVersion() {
        return this.version();
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Settings settings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, CompressedXContent> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, CompressedXContent> getMappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, AliasMetadata> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, AliasMetadata> getAliases() {
        return this.aliases;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetadata that = (IndexTemplateMetadata)o;
        if (this.order != that.order) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (!this.patterns.equals(that.patterns)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.order;
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + this.patterns.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    public static IndexTemplateMetadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.order(in.readInt());
        if (in.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            builder.patterns(in.readStringList());
        } else {
            builder.patterns(Collections.singletonList(in.readString()));
        }
        builder.settings(Settings.readSettingsFromStream(in));
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            builder.putMapping(in.readString(), CompressedXContent.readCompressedString(in));
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetadata aliasMd = new AliasMetadata(in);
            builder.putAlias(aliasMd);
        }
        if (in.getVersion().before(Version.V_6_5_0)) {
            int customSize = in.readVInt();
            assert (customSize == 0) : "expected no custom metadata";
            if (customSize > 0) {
                throw new IllegalStateException("unexpected custom metadata when none is supported");
            }
        }
        builder.version(in.readOptionalVInt());
        return builder.build();
    }

    public static Diff<IndexTemplateMetadata> readDiffFrom(StreamInput in) throws IOException {
        return IndexTemplateMetadata.readDiffFrom(IndexTemplateMetadata::readFrom, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.order);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            out.writeStringCollection(this.patterns);
        } else {
            out.writeString(this.patterns.get(0));
        }
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            ((CompressedXContent)objectObjectCursor.value).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (ObjectCursor objectCursor : this.aliases.values()) {
            ((AliasMetadata)objectCursor.value).writeTo(out);
        }
        if (out.getVersion().before(Version.V_6_5_0)) {
            out.writeVInt(0);
        }
        out.writeOptionalVInt(this.version);
    }

    public static class Builder {
        private static final Set<String> VALID_FIELDS = Sets.newHashSet("order", "mappings", "settings", "index_patterns", "aliases", "version");
        private String name;
        private int order;
        private Integer version;
        private List<String> indexPatterns;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, CompressedXContent> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetadata> aliases;

        public Builder(String name) {
            this.name = name;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
        }

        public Builder(IndexTemplateMetadata indexTemplateMetadata) {
            this.name = indexTemplateMetadata.name();
            this.order(indexTemplateMetadata.order());
            this.version(indexTemplateMetadata.version());
            this.patterns(indexTemplateMetadata.patterns());
            this.settings(indexTemplateMetadata.settings());
            this.mappings = ImmutableOpenMap.builder(indexTemplateMetadata.mappings());
            this.aliases = ImmutableOpenMap.builder(indexTemplateMetadata.aliases());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder putMapping(String mappingType, CompressedXContent mappingSource) {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            this.mappings.put(mappingType, new CompressedXContent(mappingSource));
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata.build());
            return this;
        }

        public IndexTemplateMetadata build() {
            return new IndexTemplateMetadata(this.name, this.order, this.version, this.indexPatterns, this.settings, this.mappings.build(), this.aliases.build());
        }

        public static void toXContentWithTypes(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetadata.name());
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, true);
            builder.endObject();
        }

        public static void removeType(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder) throws IOException {
            builder.startObject();
            Builder.toInnerXContent(indexTemplateMetadata, builder, new ToXContent.MapParams(Collections.singletonMap("reduce_mappings", "true")), false);
            builder.endObject();
        }

        public static void toXContent(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetadata.name());
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, false);
            builder.endObject();
        }

        static void toInnerXContentWithTypes(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, true);
        }

        /*
         * WARNING - void declaration
         */
        private static void toInnerXContent(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params, boolean includeTypeName) throws IOException {
            Metadata.XContentContext context = params.param("context_mode") != null ? Metadata.XContentContext.valueOf(params.param("context_mode")) : null;
            builder.field("order", indexTemplateMetadata.order());
            if (indexTemplateMetadata.version() != null) {
                builder.field("version", indexTemplateMetadata.version());
            }
            builder.field("index_patterns", indexTemplateMetadata.patterns());
            builder.startObject("settings");
            indexTemplateMetadata.settings().toXContent(builder, params);
            builder.endObject();
            if (context == Metadata.XContentContext.API) {
                builder.startObject("mappings");
                for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetadata.mappings()) {
                    void var7_13;
                    Map<String, Object> map = XContentHelper.convertToMap(new BytesArray(((CompressedXContent)objectObjectCursor.value).uncompressed()), false).v2();
                    if (map.size() == 1 && map.containsKey(objectObjectCursor.key)) {
                        Map map2 = (Map)map.get(objectObjectCursor.key);
                    }
                    builder.field((String)objectObjectCursor.key);
                    builder.map((Map<String, ?>)var7_13);
                }
                builder.endObject();
            } else if (params.paramAsBoolean("reduce_mappings", false)) {
                if (!includeTypeName) {
                    Map<String, Object> documentMapping = null;
                    for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetadata.mappings()) {
                        if (((String)objectObjectCursor.key).equals("_default_")) continue;
                        assert (documentMapping == null);
                        byte[] mappingSource = ((CompressedXContent)objectObjectCursor.value).uncompressed();
                        Map<String, Object> mapping = XContentHelper.convertToMap(new BytesArray(mappingSource), true).v2();
                        documentMapping = Builder.reduceMapping((String)objectObjectCursor.key, mapping);
                    }
                    if (documentMapping != null) {
                        builder.field("mappings", documentMapping);
                    } else {
                        builder.startObject("mappings").endObject();
                    }
                } else {
                    builder.startObject("mappings");
                    for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetadata.mappings()) {
                        byte[] byArray = ((CompressedXContent)objectObjectCursor.value).uncompressed();
                        Map<String, Object> mapping = XContentHelper.convertToMap(new BytesArray(byArray), true).v2();
                        mapping = Builder.reduceMapping((String)objectObjectCursor.key, mapping);
                        builder.field((String)objectObjectCursor.key);
                        builder.map(mapping);
                    }
                    builder.endObject();
                }
            } else {
                builder.startArray("mappings");
                for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetadata.mappings()) {
                    byte[] byArray = ((CompressedXContent)objectObjectCursor.value).uncompressed();
                    builder.map(XContentHelper.convertToMap(new BytesArray(byArray), true).v2());
                }
                builder.endArray();
            }
            builder.startObject("aliases");
            for (ObjectCursor objectCursor : indexTemplateMetadata.aliases().values()) {
                AliasMetadata.Builder.toXContent((AliasMetadata)objectCursor.value, builder, params);
            }
            builder.endObject();
        }

        private static Map<String, Object> reduceMapping(String type, Map<String, Object> mapping) {
            if (mapping.size() == 1 && mapping.containsKey(type)) {
                return (Map)mapping.get(type);
            }
            return mapping;
        }

        public static IndexTemplateMetadata fromXContent(XContentParser parser, String templateName) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder(templateName);
            String currentFieldName = Builder.skipTemplateName(parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        Settings.Builder templateSettingsBuilder = Settings.builder();
                        templateSettingsBuilder.put(Settings.fromXContent(parser));
                        templateSettingsBuilder.normalizePrefix("index.");
                        builder.settings(templateSettingsBuilder.build());
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            String mappingType = currentFieldName;
                            Map<String, Map<String, Object>> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                            builder.putMapping(mappingType, Strings.toString(XContentFactory.jsonBuilder().map(mappingSource)));
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetadata.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("unknown key [{}] for index template", currentFieldName);
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            Map<String, Object> mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = mapping.keySet().iterator().next();
                            String mappingSource = Strings.toString(XContentFactory.jsonBuilder().map(mapping));
                            if (mappingSource == null) continue;
                            builder.putMapping(mappingType, mappingSource);
                        }
                        continue;
                    }
                    if (!"index_patterns".equals(currentFieldName)) continue;
                    ArrayList<String> index_patterns = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        index_patterns.add(parser.text());
                    }
                    builder.patterns(index_patterns);
                    continue;
                }
                if (!token.isValue()) continue;
                if ("order".equals(currentFieldName)) {
                    builder.order(parser.intValue());
                    continue;
                }
                if (!"version".equals(currentFieldName)) continue;
                builder.version(parser.intValue());
            }
            return builder.build();
        }

        private static String skipTemplateName(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (VALID_FIELDS.contains(currentFieldName)) {
                    return currentFieldName;
                }
                parser.nextToken();
            }
            return null;
        }
    }
}

