/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent;

import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.cbor.CborXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.json.JsonXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.smile.SmileXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.yaml.YamlXContent;

public enum XContentType {
    JSON(0){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/json";
        }

        @Override
        public String mediaType() {
            return "application/json; charset=UTF-8";
        }

        @Override
        public String shortName() {
            return "json";
        }

        @Override
        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }
    }
    ,
    SMILE(1){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/smile";
        }

        @Override
        public String shortName() {
            return "smile";
        }

        @Override
        public XContent xContent() {
            return SmileXContent.smileXContent;
        }
    }
    ,
    YAML(2){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/yaml";
        }

        @Override
        public String shortName() {
            return "yaml";
        }

        @Override
        public XContent xContent() {
            return YamlXContent.yamlXContent;
        }
    }
    ,
    CBOR(3){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        @Override
        public String shortName() {
            return "cbor";
        }

        @Override
        public XContent xContent() {
            return CborXContent.cborXContent;
        }
    };

    private int index;

    public static XContentType fromMediaTypeOrFormat(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        for (XContentType type : XContentType.values()) {
            if (!XContentType.isSameMediaTypeOrFormatAs(mediaType, type)) continue;
            return type;
        }
        String lowercaseMediaType = mediaType.toLowerCase(Locale.ROOT);
        if (lowercaseMediaType.startsWith("application/*")) {
            return JSON;
        }
        return null;
    }

    public static XContentType fromMediaType(String mediaType) {
        String lowercaseMediaType = Objects.requireNonNull(mediaType, "mediaType cannot be null").toLowerCase(Locale.ROOT);
        for (XContentType type : XContentType.values()) {
            if (!type.mediaTypeWithoutParameters().equals(lowercaseMediaType)) continue;
            return type;
        }
        if (lowercaseMediaType.toLowerCase(Locale.ROOT).equals("application/x-ndjson")) {
            return JSON;
        }
        return null;
    }

    private static boolean isSameMediaTypeOrFormatAs(String stringType, XContentType type) {
        return type.mediaTypeWithoutParameters().equalsIgnoreCase(stringType) || stringType.toLowerCase(Locale.ROOT).startsWith(type.mediaTypeWithoutParameters().toLowerCase(Locale.ROOT) + ";") || type.shortName().equalsIgnoreCase(stringType);
    }

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public String mediaType() {
        return this.mediaTypeWithoutParameters();
    }

    public abstract String shortName();

    public abstract XContent xContent();

    public abstract String mediaTypeWithoutParameters();
}

