/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.discovery.zen;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class PendingClusterStateStats
implements Writeable,
ToXContentFragment {
    private final int total;
    private final int pending;
    private final int committed;

    public PendingClusterStateStats(int total, int pending, int committed) {
        this.total = total;
        this.pending = pending;
        this.committed = committed;
    }

    public PendingClusterStateStats(StreamInput in) throws IOException {
        this.total = in.readVInt();
        this.pending = in.readVInt();
        this.committed = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.total);
        out.writeVInt(this.pending);
        out.writeVInt(this.committed);
    }

    public int getCommitted() {
        return this.committed;
    }

    public int getPending() {
        return this.pending;
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("cluster_state_queue");
        builder.field("total", this.total);
        builder.field("pending", this.pending);
        builder.field("committed", this.committed);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "PendingClusterStateStats(total=" + this.total + ", pending=" + this.pending + ", committed=" + this.committed + ")";
    }

    static final class Fields {
        static final String QUEUE = "cluster_state_queue";
        static final String TOTAL = "total";
        static final String PENDING = "pending";
        static final String COMMITTED = "committed";

        Fields() {
        }
    }
}

