/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.analysis.AnalysisMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.analysis.CharFilterFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.analysis.TokenizerFactory;

public final class AnalyzerComponents {
    private final TokenizerFactory tokenizerFactory;
    private final CharFilterFactory[] charFilters;
    private final TokenFilterFactory[] tokenFilters;
    private final AnalysisMode analysisMode;

    AnalyzerComponents(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters) {
        this.tokenizerFactory = tokenizerFactory;
        this.charFilters = charFilters;
        this.tokenFilters = tokenFilters;
        AnalysisMode mode = AnalysisMode.ALL;
        for (TokenFilterFactory f : tokenFilters) {
            mode = mode.merge(f.getAnalysisMode());
        }
        this.analysisMode = mode;
    }

    static AnalyzerComponents createComponents(String name, Settings analyzerSettings, Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        String tokenizerName = analyzerSettings.get("tokenizer");
        if (tokenizerName == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + name + "] must be configured with a tokenizer");
        }
        TokenizerFactory tokenizer = tokenizers.get(tokenizerName);
        if (tokenizer == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + name + "] failed to find tokenizer under name [" + tokenizerName + "]");
        }
        List<String> charFilterNames = analyzerSettings.getAsList("char_filter");
        ArrayList<CharFilterFactory> charFiltersList = new ArrayList<CharFilterFactory>(charFilterNames.size());
        for (String charFilterName : charFilterNames) {
            CharFilterFactory charFilter = charFilters.get(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + name + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            charFiltersList.add(charFilter);
        }
        List<String> tokenFilterNames = analyzerSettings.getAsList("filter");
        ArrayList<TokenFilterFactory> tokenFilterList = new ArrayList<TokenFilterFactory>(tokenFilterNames.size());
        for (String tokenFilterName : tokenFilterNames) {
            TokenFilterFactory tokenFilter = tokenFilters.get(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + name + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            tokenFilter = tokenFilter.getChainAwareTokenFilterFactory(tokenizer, charFiltersList, tokenFilterList, tokenFilters::get);
            tokenFilterList.add(tokenFilter);
        }
        return new AnalyzerComponents(tokenizer, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFilterList.toArray(new TokenFilterFactory[tokenFilterList.size()]));
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public TokenFilterFactory[] getTokenFilters() {
        return this.tokenFilters;
    }

    public CharFilterFactory[] getCharFilters() {
        return this.charFilters;
    }

    public AnalysisMode analysisMode() {
        return this.analysisMode;
    }
}

