/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ContentPath;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;

public class RankFeatureMetaFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_feature";
    public static final String CONTENT_TYPE = "_feature";

    private RankFeatureMetaFieldMapper() {
        super(Defaults.FIELD_TYPE, RankFeatureMetaFieldType.INSTANCE);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new AssertionError((Object)"Should never be called");
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    protected String contentType() {
        return "_feature";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    public static final class RankFeatureMetaFieldType
    extends MappedFieldType {
        public static final RankFeatureMetaFieldType INSTANCE = new RankFeatureMetaFieldType();

        private RankFeatureMetaFieldType() {
            super("_feature", false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_feature";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on [_feature]");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("The [_feature] field may not be queried directly");
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder();
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            if (fieldType != null) {
                return new RankFeatureMetaFieldMapper();
            }
            return ((MetadataFieldMapper.Builder)this.parse("_feature", Collections.emptyMap(), context)).build(new Mapper.BuilderContext(indexSettings, new ContentPath(1)));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder> {
        public Builder() {
            super("_feature", Defaults.FIELD_TYPE);
        }

        @Override
        public RankFeatureMetaFieldMapper build(Mapper.BuilderContext context) {
            return new RankFeatureMetaFieldMapper();
        }
    }
}

