/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.CachingTokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.Intervals;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalsSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.graph.GraphTokenStreamFiniteStrings;

public class IntervalBuilder {
    private final String field;
    private final Analyzer analyzer;
    static final IntervalsSource NO_INTERVALS = new IntervalsSource(){

        @Override
        public IntervalIterator intervals(String field, LeafReaderContext ctx) {
            return new IntervalIterator(){

                @Override
                public int start() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public int end() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public int gaps() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int nextInterval() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public float matchCost() {
                    return 0.0f;
                }

                @Override
                public int docID() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public int nextDoc() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public int advance(int target) {
                    return Integer.MAX_VALUE;
                }

                @Override
                public long cost() {
                    return 0L;
                }
            };
        }

        @Override
        public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) {
            return null;
        }

        @Override
        public void visit(String field, QueryVisitor visitor) {
        }

        @Override
        public int minExtent() {
            return 0;
        }

        @Override
        public Collection<IntervalsSource> pullUpDisjunctions() {
            return Collections.emptyList();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        public String toString() {
            return "no_match";
        }
    };

    public IntervalBuilder(String field, Analyzer analyzer) {
        this.field = field;
        this.analyzer = analyzer;
    }

    public IntervalsSource analyzeText(String query, int maxGaps, boolean ordered) throws IOException {
        try (TokenStream ts = this.analyzer.tokenStream(this.field, query);){
            IntervalsSource intervalsSource;
            try (CachingTokenFilter stream = new CachingTokenFilter(ts);){
                intervalsSource = this.analyzeText(stream, maxGaps, ordered);
            }
            return intervalsSource;
        }
    }

    protected IntervalsSource analyzeText(CachingTokenFilter stream, int maxGaps, boolean ordered) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncAtt = stream.addAttribute(PositionIncrementAttribute.class);
        PositionLengthAttribute posLenAtt = stream.addAttribute(PositionLengthAttribute.class);
        if (termAtt == null) {
            return NO_INTERVALS;
        }
        int numTokens = 0;
        boolean hasSynonyms = false;
        boolean isGraph = false;
        stream.reset();
        while (stream.incrementToken()) {
            int positionLength;
            ++numTokens;
            int positionIncrement = posIncAtt.getPositionIncrement();
            if (positionIncrement == 0) {
                hasSynonyms = true;
            }
            if ((positionLength = posLenAtt.getPositionLength()) <= 1) continue;
            isGraph = true;
        }
        if (numTokens == 0) {
            return NO_INTERVALS;
        }
        if (numTokens == 1) {
            return this.analyzeTerm(stream);
        }
        if (isGraph) {
            return IntervalBuilder.combineSources(this.analyzeGraph(stream), maxGaps, ordered);
        }
        if (hasSynonyms) {
            return this.analyzeSynonyms(stream, maxGaps, ordered);
        }
        return IntervalBuilder.combineSources(this.analyzeTerms(stream), maxGaps, ordered);
    }

    protected IntervalsSource analyzeTerm(TokenStream ts) throws IOException {
        TermToBytesRefAttribute bytesAtt = ts.addAttribute(TermToBytesRefAttribute.class);
        ts.reset();
        ts.incrementToken();
        return Intervals.term(BytesRef.deepCopyOf(bytesAtt.getBytesRef()));
    }

    protected static IntervalsSource combineSources(List<IntervalsSource> sources, int maxGaps, boolean ordered) {
        IntervalsSource inner;
        if (sources.size() == 0) {
            return NO_INTERVALS;
        }
        if (sources.size() == 1) {
            return sources.get(0);
        }
        IntervalsSource[] sourcesArray = sources.toArray(new IntervalsSource[0]);
        if (maxGaps == 0 && ordered) {
            return Intervals.phrase(sourcesArray);
        }
        IntervalsSource intervalsSource = inner = ordered ? Intervals.ordered(sourcesArray) : Intervals.unordered(sourcesArray);
        if (maxGaps == -1) {
            return inner;
        }
        return Intervals.maxgaps(maxGaps, inner);
    }

    protected List<IntervalsSource> analyzeTerms(TokenStream ts) throws IOException {
        ArrayList<IntervalsSource> terms = new ArrayList<IntervalsSource>();
        TermToBytesRefAttribute bytesAtt = ts.addAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posAtt = ts.addAttribute(PositionIncrementAttribute.class);
        ts.reset();
        while (ts.incrementToken()) {
            BytesRef term = bytesAtt.getBytesRef();
            int precedingSpaces = posAtt.getPositionIncrement() - 1;
            terms.add(IntervalBuilder.extend(Intervals.term(BytesRef.deepCopyOf(term)), precedingSpaces));
        }
        ts.end();
        return terms;
    }

    public static IntervalsSource extend(IntervalsSource source, int precedingSpaces) {
        if (precedingSpaces == 0) {
            return source;
        }
        return Intervals.extend(source, precedingSpaces, 0);
    }

    protected IntervalsSource analyzeSynonyms(TokenStream ts, int maxGaps, boolean ordered) throws IOException {
        ArrayList<IntervalsSource> terms = new ArrayList<IntervalsSource>();
        ArrayList<IntervalsSource> synonyms = new ArrayList<IntervalsSource>();
        TermToBytesRefAttribute bytesAtt = ts.addAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posAtt = ts.addAttribute(PositionIncrementAttribute.class);
        ts.reset();
        int spaces = 0;
        while (ts.incrementToken()) {
            int posInc = posAtt.getPositionIncrement();
            if (posInc > 0) {
                if (synonyms.size() == 1) {
                    terms.add(IntervalBuilder.extend((IntervalsSource)synonyms.get(0), spaces));
                } else if (synonyms.size() > 1) {
                    terms.add(IntervalBuilder.extend(Intervals.or(synonyms.toArray(new IntervalsSource[0])), spaces));
                }
                synonyms.clear();
                spaces = posInc - 1;
            }
            synonyms.add(Intervals.term(BytesRef.deepCopyOf(bytesAtt.getBytesRef())));
        }
        if (synonyms.size() == 1) {
            terms.add(IntervalBuilder.extend((IntervalsSource)synonyms.get(0), spaces));
        } else {
            terms.add(IntervalBuilder.extend(Intervals.or(synonyms.toArray(new IntervalsSource[0])), spaces));
        }
        return IntervalBuilder.combineSources(terms, maxGaps, ordered);
    }

    protected List<IntervalsSource> analyzeGraph(TokenStream source) throws IOException {
        source.reset();
        GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
        ArrayList<IntervalsSource> clauses = new ArrayList<IntervalsSource>();
        int[] articulationPoints = graph.articulationPoints();
        int lastState = 0;
        int maxClauseCount = BooleanQuery.getMaxClauseCount();
        for (int i = 0; i <= articulationPoints.length; ++i) {
            int start = lastState;
            int end = -1;
            if (i < articulationPoints.length) {
                end = articulationPoints[i];
            }
            lastState = end;
            if (graph.hasSidePath(start)) {
                ArrayList<IntervalsSource> paths = new ArrayList<IntervalsSource>();
                Iterator<TokenStream> it = graph.getFiniteStrings(start, end);
                while (it.hasNext()) {
                    TokenStream ts = it.next();
                    IntervalsSource phrase = IntervalBuilder.combineSources(this.analyzeTerms(ts), 0, true);
                    if (paths.size() >= maxClauseCount) {
                        throw new BooleanQuery.TooManyClauses();
                    }
                    paths.add(phrase);
                }
                if (paths.size() <= 0) continue;
                clauses.add(Intervals.or(paths.toArray(new IntervalsSource[0])));
                continue;
            }
            Iterator<TokenStream> it = graph.getFiniteStrings(start, end);
            TokenStream ts = it.next();
            clauses.addAll(this.analyzeTerms(ts));
            assert (!it.hasNext());
        }
        return clauses;
    }
}

