/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.index.IndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.index.IndexResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActiveShardCount;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.VersionType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestActions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.document.RestDeleteAction;

public class RestIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestDeleteAction.class));
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in document index requests is deprecated, use the typeless endpoints instead (/{index}/_doc/{id}, /{index}/_doc, or /{index}/_create/{id}).";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_doc/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_doc/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/{type}/{id}")));
    }

    @Override
    public String getName() {
        return "document_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndexRequest indexRequest;
        String type = request.param("type");
        if (type != null && !type.equals("_doc")) {
            deprecationLogger.deprecatedAndMaybeLog("index_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            indexRequest = new IndexRequest(request.param("index"), type, request.param("id"));
        } else {
            indexRequest = new IndexRequest(request.param("index"));
            indexRequest.id(request.param("id"));
        }
        indexRequest.routing(request.param("routing"));
        indexRequest.setPipeline(request.param("pipeline"));
        indexRequest.source(request.requiredContent(), request.getXContentType());
        indexRequest.timeout(request.paramAsTime("timeout", IndexRequest.DEFAULT_TIMEOUT));
        indexRequest.setRefreshPolicy(request.param("refresh"));
        indexRequest.version(RestActions.parseVersion(request));
        indexRequest.versionType(VersionType.fromString(request.param("version_type"), indexRequest.versionType()));
        indexRequest.setIfSeqNo(request.paramAsLong("if_seq_no", indexRequest.ifSeqNo()));
        indexRequest.setIfPrimaryTerm(request.paramAsLong("if_primary_term", indexRequest.ifPrimaryTerm()));
        String sOpType = request.param("op_type");
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            indexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        if (sOpType != null) {
            indexRequest.opType(sOpType);
        }
        return channel -> client.index(indexRequest, new RestStatusToXContentListener<IndexResponse>((RestChannel)channel, r -> r.getLocation(indexRequest.routing())));
    }

    public static final class AutoIdHandler
    extends RestIndexAction {
        private final Supplier<DiscoveryNodes> nodesInCluster;

        public AutoIdHandler(Supplier<DiscoveryNodes> nodesInCluster) {
            this.nodesInCluster = nodesInCluster;
        }

        @Override
        public String getName() {
            return "document_create_action_auto_id";
        }

        @Override
        public List<RestHandler.Route> routes() {
            return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_doc"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}")));
        }

        @Override
        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            assert (request.params().get("id") == null) : "non-null id: " + request.params().get("id");
            if (request.params().get("op_type") == null && this.nodesInCluster.get().getMinNodeVersion().onOrAfter(Version.V_7_5_0)) {
                request.params().put("op_type", "create");
            }
            return super.prepareRequest(request, client);
        }
    }

    public static final class CreateHandler
    extends RestIndexAction {
        @Override
        public String getName() {
            return "document_create_action";
        }

        @Override
        public List<RestHandler.Route> routes() {
            return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_create/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_create/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/{id}/_create"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/{type}/{id}/_create")));
        }

        @Override
        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            this.validateOpType(request.params().get("op_type"));
            request.params().put("op_type", "create");
            return super.prepareRequest(request, client);
        }

        void validateOpType(String opType) {
            if (null != opType && !"create".equals(opType.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("opType must be 'create', found: [" + opType + "]");
            }
        }
    }
}

