/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.ingest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ingest.PutPipelineRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestToXContentListener;

public class RestPutPipelineAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_ingest/pipeline/{id}"));
    }

    @Override
    public String getName() {
        return "ingest_put_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        Tuple<XContentType, BytesReference> sourceTuple = restRequest.contentOrSourceParam();
        PutPipelineRequest request = new PutPipelineRequest(restRequest.param("id"), sourceTuple.v2(), sourceTuple.v1());
        request.masterNodeTimeout(restRequest.paramAsTime("master_timeout", request.masterNodeTimeout()));
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        return channel -> client.admin().cluster().putPipeline(request, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

