/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.SignificantTerms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;

public abstract class InternalSignificantTerms<A extends InternalSignificantTerms<A, B>, B extends Bucket<B>>
extends InternalMultiBucketAggregation<A, B>
implements SignificantTerms {
    public static final String SCORE = "score";
    public static final String BG_COUNT = "bg_count";
    protected final int requiredSize;
    protected final long minDocCount;

    protected InternalSignificantTerms(String name, int requiredSize, long minDocCount, Map<String, Object> metadata) {
        super(name, metadata);
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
    }

    protected InternalSignificantTerms(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalSignificantTerms.readSize(in);
        this.minDocCount = in.readVLong();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        InternalSignificantTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public abstract List<B> getBuckets();

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var12_17;
        long globalSubsetSize = 0L;
        long globalSupersetSize = 0L;
        for (InternalAggregation internalAggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)internalAggregation;
            globalSubsetSize += terms.getSubsetSize();
            globalSupersetSize += terms.getSupersetSize();
        }
        HashMap<String, ArrayList<Bucket>> buckets = new HashMap<String, ArrayList<Bucket>>();
        for (InternalAggregation aggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
            for (Bucket bucket : terms.getBuckets()) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(bucket.getKeyAsString());
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(bucket.getKeyAsString(), existingBuckets);
                }
                existingBuckets.add(this.createBucket(bucket.getSubsetDf(), globalSubsetSize, bucket.getSupersetDf(), globalSupersetSize, bucket.aggregations, bucket));
            }
        }
        SignificanceHeuristic significanceHeuristic = this.getSignificanceHeuristic().rewrite(reduceContext);
        int size = !reduceContext.isFinalReduce() ? buckets.size() : Math.min(this.requiredSize, buckets.size());
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        for (Map.Entry entry : buckets.entrySet()) {
            List sameTermBuckets = (List)entry.getValue();
            InternalMultiBucketAggregation.InternalBucket b = this.reduceBucket(sameTermBuckets, reduceContext);
            ((Bucket)b).updateScore(significanceHeuristic);
            if (((Bucket)b).score > 0.0 && ((Bucket)b).subsetDf >= this.minDocCount || !reduceContext.isFinalReduce()) {
                Bucket removed = (Bucket)ordered.insertWithOverflow(b);
                if (removed == null) {
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    continue;
                }
                reduceContext.consumeBucketsAndMaybeBreak(-InternalSignificantTerms.countInnerBucket(removed));
                continue;
            }
            reduceContext.consumeBucketsAndMaybeBreak(-InternalSignificantTerms.countInnerBucket(b));
        }
        Bucket[] list = this.createBucketsArray(ordered.size());
        int n = ordered.size() - 1;
        while (var12_17 >= 0) {
            list[var12_17] = (Bucket)ordered.pop();
            --var12_17;
        }
        return this.create(globalSubsetSize, globalSupersetSize, Arrays.asList(list));
    }

    @Override
    protected B reduceBucket(List<B> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        long subsetDf = 0L;
        long supersetDf = 0L;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (Bucket bucket : buckets) {
            subsetDf += bucket.subsetDf;
            supersetDf += bucket.supersetDf;
            aggregationsList.add(bucket.aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return (B)this.createBucket(subsetDf, ((Bucket)buckets.get((int)0)).subsetSize, supersetDf, ((Bucket)buckets.get((int)0)).supersetSize, aggs, (Bucket)buckets.get(0));
    }

    abstract B createBucket(long var1, long var3, long var5, long var7, InternalAggregations var9, B var10);

    protected abstract A create(long var1, long var3, List<B> var5);

    protected abstract B[] createBucketsArray(int var1);

    protected abstract long getSubsetSize();

    protected abstract long getSupersetSize();

    protected abstract SignificanceHeuristic getSignificanceHeuristic();

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minDocCount, this.requiredSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSignificantTerms that = (InternalSignificantTerms)obj;
        return Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.requiredSize, that.requiredSize);
    }

    public static abstract class Bucket<B extends Bucket<B>>
    extends InternalMultiBucketAggregation.InternalBucket
    implements SignificantTerms.Bucket {
        long subsetDf;
        long subsetSize;
        long supersetDf;
        long supersetSize;
        long bucketOrd;
        double score;
        protected InternalAggregations aggregations;
        final transient DocValueFormat format;

        protected Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations, DocValueFormat format) {
            this.subsetSize = subsetSize;
            this.supersetSize = supersetSize;
            this.subsetDf = subsetDf;
            this.supersetDf = supersetDf;
            this.aggregations = aggregations;
            this.format = format;
        }

        protected Bucket(StreamInput in, long subsetSize, long supersetSize, DocValueFormat format) {
            this.subsetSize = subsetSize;
            this.supersetSize = supersetSize;
            this.format = format;
        }

        @Override
        public long getSubsetDf() {
            return this.subsetDf;
        }

        @Override
        public long getSupersetDf() {
            return this.supersetDf;
        }

        @Override
        public long getSupersetSize() {
            return this.supersetSize;
        }

        @Override
        public long getSubsetSize() {
            return this.subsetSize;
        }

        void updateScore(SignificanceHeuristic significanceHeuristic) {
            this.score = significanceHeuristic.getScore(this.subsetDf, this.subsetSize, this.supersetDf, this.supersetSize);
        }

        @Override
        public long getDocCount() {
            return this.subsetDf;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public double getSignificanceScore() {
            return this.score;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket that = (Bucket)o;
            return this.bucketOrd == that.bucketOrd && Double.compare(that.score, this.score) == 0 && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.format, that.format);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.bucketOrd, this.aggregations, this.score, this.format);
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            builder.field(InternalSignificantTerms.SCORE, this.score);
            builder.field(InternalSignificantTerms.BG_COUNT, this.supersetDf);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, long var2, long var4, DocValueFormat var6) throws IOException;
        }
    }
}

