/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.TextField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.Encoder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.FragmentBuilderHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.lookup.SourceLookup;

public class SourceScoreOrderFragmentsBuilder
extends ScoreOrderFragmentsBuilder {
    private final MappedFieldType fieldType;
    private final QueryShardContext context;

    public SourceScoreOrderFragmentsBuilder(MappedFieldType fieldType, QueryShardContext context, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(preTags, postTags, boundaryScanner);
        this.fieldType = fieldType;
        this.context = context;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SourceLookup sourceLookup = this.context.lookup().source();
        sourceLookup.setSegmentAndDocument((LeafReaderContext)reader.getContext(), docId);
        List<Object> values = sourceLookup.extractRawValues(this.fieldType.name());
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.fieldType.name(), values.get(i).toString(), (IndexableFieldType)TextField.TYPE_NOT_STORED);
        }
        return fields;
    }

    @Override
    protected String makeFragment(StringBuilder buffer, int[] index, Field[] values, FieldFragList.WeightedFragInfo fragInfo, String[] preTags, String[] postTags, Encoder encoder) {
        FieldFragList.WeightedFragInfo weightedFragInfo = FragmentBuilderHelper.fixWeightedFragInfo(this.fieldType, values, fragInfo);
        return super.makeFragment(buffer, index, values, weightedFragInfo, preTags, postTags, encoder);
    }
}

