/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.search.MoreSearch;
import org.graylog.events.search.MoreSearchAdapter;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.ResultMessageFactory;
import org.graylog.storage.elasticsearch7.Scroll;
import org.graylog.storage.elasticsearch7.SortOrderMapper;
import org.graylog.storage.elasticsearch7.TimeRangeQueryFactory;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.ScrollCommand;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreSearchAdapterES7
implements MoreSearchAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MoreSearchAdapterES7.class);
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, true, false);
    private final ElasticsearchClient client;
    private final Boolean allowLeadingWildcard;
    private final SortOrderMapper sortOrderMapper;
    private final Scroll scroll;

    @Inject
    public MoreSearchAdapterES7(ElasticsearchClient client, @Named(value="allow_leading_wildcard_searches") Boolean allowLeadingWildcard, SortOrderMapper sortOrderMapper, Scroll scroll) {
        this.client = client;
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.sortOrderMapper = sortOrderMapper;
        this.scroll = scroll;
    }

    public MoreSearch.Result eventSearch(String queryString, TimeRange timerange, Set<String> affectedIndices, Sorting sorting, int page, int perPage, Set<String> eventStreams, String filterString, Set<String> forbiddenSourceStreams) {
        MatchAllQueryBuilder query = queryString.isEmpty() || queryString.equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(queryString).allowLeadingWildcard(this.allowLeadingWildcard);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter(query).filter(QueryBuilders.termsQuery("streams", eventStreams)).filter(Objects.requireNonNull(TimeRangeQueryFactory.create(timerange)));
        if (!Strings.isNullOrEmpty((String)filterString)) {
            filter.filter(QueryBuilders.queryStringQuery(filterString));
        }
        if (!forbiddenSourceStreams.isEmpty()) {
            filter.filter(QueryBuilders.boolQuery().mustNot(QueryBuilders.termsQuery("source_streams", forbiddenSourceStreams)));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(filter).from((page - 1) * perPage).size(perPage).sort(sorting.getField(), this.sortOrderMapper.fromSorting(sorting)).trackTotalHits(true);
        Set<String> indices = affectedIndices.isEmpty() ? Collections.singleton("") : affectedIndices;
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[0])).source(searchSourceBuilder).indicesOptions(INDICES_OPTIONS);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query:\n{}", (Object)searchSourceBuilder.toString(new ToXContent.MapParams(Collections.singletonMap("pretty", "true"))));
            LOG.debug("Execute search: {}", (Object)searchRequest.toString());
        }
        SearchResponse searchResult = this.client.search(searchRequest, "Unable to perform search query");
        List hits = Streams.stream((Iterable)searchResult.getHits()).map(ResultMessageFactory::fromSearchHit).collect(Collectors.toList());
        long total = searchResult.getHits().getTotalHits().value;
        return MoreSearch.Result.builder().results(hits).resultsCount(total).duration(searchResult.getTook().getMillis()).usedIndexNames(affectedIndices).executedQuery(searchSourceBuilder.toString()).build();
    }

    public void scrollEvents(String queryString, TimeRange timeRange, Set<String> affectedIndices, Set<String> streams, String scrollTime, int batchSize, MoreSearchAdapter.ScrollEventsCallback resultCallback) throws EventProcessorException {
        ScrollCommand scrollCommand = this.buildScrollCommand(queryString, timeRange, affectedIndices, streams, batchSize);
        ScrollResult scrollResult = this.scroll.scroll(scrollCommand);
        AtomicBoolean continueScrolling = new AtomicBoolean(true);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ScrollResult.ScrollChunk scrollChunk = scrollResult.nextChunk();
            while (continueScrolling.get() && scrollChunk != null) {
                List messages = scrollChunk.getMessages();
                LOG.debug("Passing <{}> messages to callback", (Object)messages.size());
                resultCallback.accept(Collections.unmodifiableList(messages), continueScrolling);
                if (!continueScrolling.get()) {
                    break;
                }
                scrollChunk = scrollResult.nextChunk();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                scrollResult.cancel();
            }
            catch (Exception exception) {}
            LOG.debug("Scrolling done - took {} ms", (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private ScrollCommand buildScrollCommand(String queryString, TimeRange timeRange, Set<String> affectedIndices, Set<String> streams, int batchSize) {
        ScrollCommand.Builder commandBuilder = ScrollCommand.builder().query(queryString).range(timeRange).indices(affectedIndices).batchSize(batchSize).sorting(new Sorting("timestamp", Sorting.Direction.ASC));
        if (!streams.isEmpty()) {
            commandBuilder = commandBuilder.streams(streams);
        }
        return commandBuilder.build();
    }
}

