/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.DateRangeBucket;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotBucketSpecHandler;
import org.joda.time.base.AbstractDateTime;

public class ESDateRangeHandler
extends ESPivotBucketSpecHandler<DateRangeBucket, ParsedDateRange> {
    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, DateRangeBucket dateRangeBucket, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext, Query query) {
        DateRangeAggregationBuilder builder = (DateRangeAggregationBuilder)AggregationBuilders.dateRange(name).field(dateRangeBucket.field());
        dateRangeBucket.ranges().forEach(r -> {
            String from = r.from().map(AbstractDateTime::toString).orElse(null);
            String to = r.to().map(AbstractDateTime::toString).orElse(null);
            if (from != null && to != null) {
                builder.addRange(from, to);
            } else if (to != null) {
                builder.addUnboundedTo(to);
            } else if (from != null) {
                builder.addUnboundedFrom(from);
            }
        });
        builder.format("date_time");
        builder.keyed(false);
        this.record(esGeneratedQueryContext, pivot, (PivotSpec)dateRangeBucket, name, ParsedDateRange.class);
        return Optional.of(builder);
    }

    @Override
    public Stream<ESPivotBucketSpecHandler.Bucket> doHandleResult(Pivot pivot, DateRangeBucket dateRangeBucket, SearchResponse searchResult, ParsedDateRange rangeAggregation, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        if (dateRangeBucket.bucketKey().equals((Object)DateRangeBucket.BucketKey.TO)) {
            return rangeAggregation.getBuckets().stream().map(range -> ESPivotBucketSpecHandler.Bucket.create(range.getToAsString(), range));
        }
        return rangeAggregation.getBuckets().stream().map(range -> ESPivotBucketSpecHandler.Bucket.create(range.getFromAsString(), range));
    }
}

