/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.series;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.HasAggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotSeriesSpecHandler;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESCountHandler
extends ESPivotSeriesSpecHandler<Count, ValueCount> {
    private static final Logger LOG = LoggerFactory.getLogger(ESCountHandler.class);

    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, Count count, ESPivot searchTypeHandler, ESGeneratedQueryContext queryContext) {
        String field = count.field();
        if (field == null) {
            return Optional.empty();
        }
        ValueCountAggregationBuilder value = (ValueCountAggregationBuilder)AggregationBuilders.count(name).field(field);
        this.record(queryContext, pivot, (PivotSpec)count, name, ValueCount.class);
        return Optional.of(value);
    }

    @Override
    public Stream<ESPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Count count, SearchResponse searchResult, ValueCount valueCount, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        Number value;
        if (valueCount == null) {
            LOG.error("Unexpected null aggregation result, returning 0 for the count. This is a bug.");
            value = 0;
        } else {
            value = valueCount instanceof MultiBucketsAggregation.Bucket ? Long.valueOf(((MultiBucketsAggregation.Bucket)((Object)valueCount)).getDocCount()) : (valueCount instanceof Aggregations ? Long.valueOf(searchResult.getHits().getTotalHits().value) : Long.valueOf(valueCount.getValue()));
        }
        return Stream.of(ESPivotSeriesSpecHandler.Value.create(count.id(), "count", value));
    }

    @Override
    protected Aggregation extractAggregationFromResult(Pivot pivot, PivotSpec spec, HasAggregations aggregations, ESGeneratedQueryContext queryContext) {
        Tuple2<String, Class<? extends Aggregation>> objects = this.aggTypes(queryContext, pivot).getTypes(spec);
        if (objects == null) {
            if (aggregations instanceof MultiBucketsAggregation.Bucket) {
                return this.createValueCount((MultiBucketsAggregation.Bucket)aggregations);
            }
        } else {
            return aggregations.getAggregations().get((String)objects.v1);
        }
        return null;
    }

    private Aggregation createValueCount(MultiBucketsAggregation.Bucket aggregations) {
        final Long docCount = aggregations.getDocCount();
        return new ValueCount(){

            @Override
            public long getValue() {
                return docCount;
            }

            @Override
            public double value() {
                return docCount.longValue();
            }

            @Override
            public String getValueAsString() {
                return docCount.toString();
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getType() {
                return null;
            }

            @Override
            public Map<String, Object> getMetadata() {
                return null;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
                return null;
            }
        };
    }
}

