/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.configurations.rest;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.plugins.collector.common.CollectorPluginConfiguration;
import org.graylog.plugins.collector.configurations.CollectorConfigurationService;
import org.graylog.plugins.collector.configurations.rest.CollectorConfigurationEtagInvalidation;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.metrics.CacheStatsSet;
import org.graylog2.shared.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigurationEtagService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationEtagService.class);
    private final Cache<String, String> cache;
    private MetricRegistry metricRegistry;
    private EventBus eventBus;
    private ClusterEventBus clusterEventBus;

    @Inject
    public ConfigurationEtagService(CollectorPluginConfiguration pluginConfiguration, MetricRegistry metricRegistry, EventBus eventBus, ClusterEventBus clusterEventBus) {
        this.metricRegistry = metricRegistry;
        this.eventBus = eventBus;
        this.clusterEventBus = clusterEventBus;
        Duration cacheTime = pluginConfiguration.getCacheTime();
        this.cache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(cacheTime.getQuantity(), cacheTime.getUnit()).maximumSize((long)pluginConfiguration.getCacheMaxSize()).build();
    }

    @Subscribe
    public void handleEtagInvalidation(CollectorConfigurationEtagInvalidation event) {
        if (event.etag().equals("")) {
            LOG.trace("Invalidating all collector configuration etags");
            this.cache.invalidateAll();
        } else {
            LOG.trace("Invalidating collector configuration etag {}", (Object)event.etag());
            this.cache.invalidate((Object)event.etag());
        }
    }

    public boolean isPresent(String etag) {
        return this.cache.getIfPresent((Object)etag) != null;
    }

    public void put(String etag) {
        this.cache.put((Object)etag, (Object)etag);
    }

    public void invalidate(String etag) {
        this.clusterEventBus.post((Object)CollectorConfigurationEtagInvalidation.etag(etag));
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
        this.clusterEventBus.post((Object)CollectorConfigurationEtagInvalidation.etag(""));
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this);
        MetricUtils.safelyRegisterAll((MetricRegistry)this.metricRegistry, (MetricSet)new CacheStatsSet(MetricRegistry.name(CollectorConfigurationService.class, (String[])new String[]{"etag-cache"}), this.cache));
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
        this.metricRegistry.removeMatching((name, metric) -> name.startsWith(MetricRegistry.name(CollectorConfigurationService.class, (String[])new String[]{"etag-cache"})));
    }
}

