/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.configurations.rest.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfiguration;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfigurationSnippet;
import org.graylog.plugins.collector.configurations.rest.models.CollectorInput;
import org.graylog.plugins.collector.configurations.rest.models.CollectorOutput;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_CollectorConfiguration
extends CollectorConfiguration {
    private final String id;
    private final String name;
    private final List<String> tags;
    private final List<CollectorInput> inputs;
    private final List<CollectorOutput> outputs;
    private final List<CollectorConfigurationSnippet> snippets;

    private AutoValue_CollectorConfiguration(@Nullable String id, String name, List<String> tags, List<CollectorInput> inputs, List<CollectorOutput> outputs, List<CollectorConfigurationSnippet> snippets) {
        this.id = id;
        this.name = name;
        this.tags = tags;
        this.inputs = inputs;
        this.outputs = outputs;
        this.snippets = snippets;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public List<String> tags() {
        return this.tags;
    }

    @Override
    @JsonProperty
    public List<CollectorInput> inputs() {
        return this.inputs;
    }

    @Override
    @JsonProperty
    public List<CollectorOutput> outputs() {
        return this.outputs;
    }

    @Override
    @JsonProperty
    public List<CollectorConfigurationSnippet> snippets() {
        return this.snippets;
    }

    public String toString() {
        return "CollectorConfiguration{id=" + this.id + ", name=" + this.name + ", tags=" + this.tags + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", snippets=" + this.snippets + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CollectorConfiguration) {
            CollectorConfiguration that = (CollectorConfiguration)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.name.equals(that.name()) && this.tags.equals(that.tags()) && this.inputs.equals(that.inputs()) && this.outputs.equals(that.outputs()) && this.snippets.equals(that.snippets());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.tags.hashCode();
        h$ *= 1000003;
        h$ ^= this.inputs.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputs.hashCode();
        h$ *= 1000003;
        return h$ ^= this.snippets.hashCode();
    }

    @Override
    public CollectorConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CollectorConfiguration.Builder {
        private String id;
        private String name;
        private List<String> tags;
        private List<CollectorInput> inputs;
        private List<CollectorOutput> outputs;
        private List<CollectorConfigurationSnippet> snippets;

        Builder() {
        }

        private Builder(CollectorConfiguration source) {
            this.id = source.id();
            this.name = source.name();
            this.tags = source.tags();
            this.inputs = source.inputs();
            this.outputs = source.outputs();
            this.snippets = source.snippets();
        }

        @Override
        public CollectorConfiguration.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public CollectorConfiguration.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public CollectorConfiguration.Builder tags(List<String> tags) {
            if (tags == null) {
                throw new NullPointerException("Null tags");
            }
            this.tags = tags;
            return this;
        }

        @Override
        public CollectorConfiguration.Builder inputs(List<CollectorInput> inputs) {
            if (inputs == null) {
                throw new NullPointerException("Null inputs");
            }
            this.inputs = inputs;
            return this;
        }

        @Override
        public CollectorConfiguration.Builder outputs(List<CollectorOutput> outputs) {
            if (outputs == null) {
                throw new NullPointerException("Null outputs");
            }
            this.outputs = outputs;
            return this;
        }

        @Override
        public CollectorConfiguration.Builder snippets(List<CollectorConfigurationSnippet> snippets) {
            if (snippets == null) {
                throw new NullPointerException("Null snippets");
            }
            this.snippets = snippets;
            return this;
        }

        @Override
        public CollectorConfiguration build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.tags == null) {
                missing = missing + " tags";
            }
            if (this.inputs == null) {
                missing = missing + " inputs";
            }
            if (this.outputs == null) {
                missing = missing + " outputs";
            }
            if (this.snippets == null) {
                missing = missing + " snippets";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CollectorConfiguration(this.id, this.name, this.tags, this.inputs, this.outputs, this.snippets);
        }
    }
}

