/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.configurations.rest.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.hash.Hashing;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.collector.configurations.CollectorConfigurationService;
import org.graylog.plugins.collector.configurations.rest.ConfigurationEtagService;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfiguration;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfigurationSnippet;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfigurationSummary;
import org.graylog.plugins.collector.configurations.rest.models.CollectorInput;
import org.graylog.plugins.collector.configurations.rest.models.CollectorOutput;
import org.graylog.plugins.collector.configurations.rest.responses.CollectorConfigurationListResponse;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="CollectorConfiguration", description="Manage collector configurations")
@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CollectorConfigurationResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(CollectorConfigurationResource.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final CollectorConfigurationService collectorConfigurationService;
    private final ConfigurationEtagService etagService;

    @Inject
    public CollectorConfigurationResource(CollectorConfigurationService collectorConfigurationService, ConfigurationEtagService etagService) {
        this.collectorConfigurationService = collectorConfigurationService;
        this.etagService = etagService;
    }

    @GET
    @Path(value="/{collectorId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a single collector configuration")
    @ApiResponses(value={@ApiResponse(code=404, message="Collector not found."), @ApiResponse(code=400, message="Invalid ObjectId."), @ApiResponse(code=304, message="Configuration didn't update.")})
    public Response getConfiguration(@Context Request request, @Context HttpHeaders httpHeaders, @ApiParam(name="collectorId", required=true) @PathParam(value="collectorId") String collectorId, @ApiParam(name="tags") @QueryParam(value="tags") String queryTags) throws NotFoundException {
        List<CollectorConfiguration> collectorConfigurationList;
        CollectorConfiguration collectorConfiguration;
        EntityTag etag;
        List<String> tags = this.parseQueryTags(queryTags);
        String ifNoneMatch = httpHeaders.getHeaderString("If-None-Match");
        Boolean etagCached = false;
        Response.ResponseBuilder builder = Response.noContent();
        if (ifNoneMatch != null && this.etagService.isPresent((etag = new EntityTag(ifNoneMatch.replaceAll("\"", ""))).toString())) {
            etagCached = true;
            builder = Response.notModified();
            builder.tag(etag);
        }
        if (tags != null && !etagCached.booleanValue() && (collectorConfiguration = this.collectorConfigurationService.merge(collectorConfigurationList = this.collectorConfigurationService.findByTags(tags))) != null) {
            collectorConfiguration.tags().addAll(tags);
            String etagString = this.configToEtag(collectorConfiguration);
            EntityTag collectorConfigurationEtag = new EntityTag(etagString);
            builder = Response.ok((Object)collectorConfiguration);
            builder.tag(collectorConfigurationEtag);
            this.etagService.put(collectorConfigurationEtag.toString());
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(true);
        cacheControl.setPrivate(true);
        builder.cacheControl(cacheControl);
        return builder.build();
    }

    @GET
    @Path(value="/configurations")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List all collector configurations")
    public CollectorConfigurationListResponse listConfigurations() {
        List<CollectorConfigurationSummary> result = this.collectorConfigurationService.loadAll().stream().map(this::getCollectorConfigurationSummary).collect(Collectors.toList());
        return CollectorConfigurationListResponse.create(result.size(), result);
    }

    @GET
    @Path(value="/configurations/tags")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List all used tags")
    public List<String> getTags() {
        return this.collectorConfigurationService.loadAllTags();
    }

    @GET
    @Path(value="/configurations/{id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Show collector configuration details")
    public CollectorConfiguration getConfigurations(@ApiParam(name="id", required=true) @PathParam(value="id") @NotEmpty String id) {
        return this.collectorConfigurationService.findById(id);
    }

    @PUT
    @Path(value="/configurations/{id}/tags")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:update"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="collector:tags:update")
    public CollectorConfiguration updateTags(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="JSON body", required=true) List<String> tags) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.withTagsFromRequest(id, tags);
        this.collectorConfigurationService.save(collectorConfiguration);
        return collectorConfiguration;
    }

    @PUT
    @Path(value="/configurations/{id}/outputs/{output_id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:update"})
    @ApiOperation(value="Update a configuration output", notes="This is a stateless method which updates a collector output")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    @AuditEvent(type="collector:output:update")
    public Response updateOutput(@ApiParam(name="id", required=true) @PathParam(value="id") @NotEmpty String id, @ApiParam(name="output_id", required=true) @PathParam(value="output_id") @NotEmpty String outputId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorOutput request) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.updateOutputFromRequest(id, outputId, request);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/configurations/{id}/inputs/{input_id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:update"})
    @ApiOperation(value="Update a configuration input", notes="This is a stateless method which updates a collector input")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    @AuditEvent(type="collector:input:update")
    public Response updateInput(@ApiParam(name="id", required=true) @PathParam(value="id") @NotEmpty String id, @ApiParam(name="input_id", required=true) @PathParam(value="input_id") @NotEmpty String inputId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorInput request) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.updateInputFromRequest(id, inputId, request);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/configurations/{id}/snippets/{snippet_id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:update"})
    @ApiOperation(value="Update a configuration snippet", notes="This is a stateless method which updates a collector snippet")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    @AuditEvent(type="collector:snippet:update")
    public Response updateSnippet(@ApiParam(name="id", required=true) @PathParam(value="id") @NotEmpty String id, @ApiParam(name="snippet_id", required=true) @PathParam(value="snippet_id") @NotEmpty String snippetId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorConfigurationSnippet request) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.updateSnippetFromRequest(id, snippetId, request);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/configurations")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new collector configuration")
    @AuditEvent(type="collector:configuration:create")
    public CollectorConfiguration createConfiguration(@ApiParam(name="createDefaults") @QueryParam(value="createDefaults") RestBoolean createDefaults, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorConfiguration request) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = createDefaults != null && createDefaults.getValue() ? this.collectorConfigurationService.fromRequestWithDefaultSnippets(request) : this.collectorConfigurationService.fromRequest(request);
        this.collectorConfigurationService.save(collectorConfiguration);
        return collectorConfiguration;
    }

    @PUT
    @Path(value="/configurations/{id}/name")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:update"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a collector configuration name")
    @AuditEvent(type="collector:configuration:update")
    public CollectorConfiguration updateConfigurationName(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorConfiguration request) {
        this.etagService.invalidateAll();
        CollectorConfiguration persistedConfiguration = this.collectorConfigurationService.findById(id);
        CollectorConfiguration newConfiguration = this.collectorConfigurationService.fromRequest(request);
        CollectorConfiguration updatedConfiguration = persistedConfiguration.toBuilder().name(newConfiguration.name()).build();
        this.collectorConfigurationService.save(updatedConfiguration);
        return updatedConfiguration;
    }

    @POST
    @Path(value="/configurations/{id}/outputs")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @ApiOperation(value="Create a configuration output", notes="This is a stateless method which inserts a collector output")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    @AuditEvent(type="collector:output:create")
    public Response createOutput(@ApiParam(name="id", required=true) @PathParam(value="id") @NotEmpty String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorOutput request) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.withOutputFromRequest(id, request);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/configurations/{id}/inputs")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @ApiOperation(value="Create a configuration input", notes="This is a stateless method which inserts a collector input")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    @AuditEvent(type="collector:input:create")
    public Response createInput(@ApiParam(name="id", required=true) @PathParam(value="id") @NotEmpty String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorInput request) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.withInputFromRequest(id, request);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/configurations/{id}/snippets")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @ApiOperation(value="Create a configuration snippet", notes="This is a stateless method which inserts a collector configuration snippet")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    @AuditEvent(type="collector:snippet:create")
    public Response createSnippet(@ApiParam(name="id", required=true) @PathParam(value="id") @NotEmpty String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorConfigurationSnippet request) {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.withSnippetFromRequest(id, request);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/configurations/{id}/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @ApiOperation(value="Copy a configuration", notes="This is a stateless method which copies a collector configuration to one with another name")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="collector:configuration:clone")
    public Response copyConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="name") String name) throws NotFoundException {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.copyConfiguration(id, name);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/configurations/{id}/outputs/{outputId}/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @ApiOperation(value="Copy a configuration output", notes="This is a stateless method which copies a collector output to one with another name")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration or Output not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="collector:output:clone")
    public Response copyOutput(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="outputId") String outputId, @PathParam(value="name") String name) throws NotFoundException {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.copyOutput(id, outputId, name);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/configurations/{id}/inputs/{inputId}/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @ApiOperation(value="Copy a configuration input", notes="This is a stateless method which copies a collector input to one with another name")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration or Input not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="collector:input:clone")
    public Response copyInput(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="inputId") String inputId, @PathParam(value="name") String name) throws NotFoundException {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.copyInput(id, inputId, name);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/configurations/{id}/snippets/{snippetId}/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:create"})
    @ApiOperation(value="Copy a configuration snippet", notes="This is a stateless method which copies a collector snippet to one with another name")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration or Snippet not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="collector:snippet:clone")
    public Response copySnippet(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="snippetId") String snippetId, @PathParam(value="name") String name) throws NotFoundException {
        this.etagService.invalidateAll();
        CollectorConfiguration collectorConfiguration = this.collectorConfigurationService.copySnippet(id, snippetId, name);
        this.collectorConfigurationService.save(collectorConfiguration);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="/configurations/{id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:delete"})
    @ApiOperation(value="Delete a collector configuration")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="collector:configuration:delete")
    public void deleteConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id) throws NotFoundException {
        this.etagService.invalidateAll();
        this.collectorConfigurationService.delete(id);
    }

    @DELETE
    @Path(value="/configurations/{id}/outputs/{outputId}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:delete"})
    @ApiOperation(value="Delete output from configuration")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration or Output not found."), @ApiResponse(code=400, message="Invalid ObjectId."), @ApiResponse(code=412, message="Still inputs assigned to output")})
    @AuditEvent(type="collector:output:delete")
    public Response deleteOutput(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="outputId") String outputId) throws NotFoundException {
        this.etagService.invalidateAll();
        int deleted = this.collectorConfigurationService.deleteOutput(id, outputId);
        switch (deleted) {
            case 0: {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            case -1: {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/configurations/{id}/inputs/{inputId}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:delete"})
    @ApiOperation(value="Delete input form configuration")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration or Input not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="collector:input:delete")
    public void deleteInput(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="inputId") String inputId) throws NotFoundException {
        this.etagService.invalidateAll();
        this.collectorConfigurationService.deleteInput(id, inputId);
    }

    @DELETE
    @Path(value="/configurations/{id}/snippets/{snippetId}")
    @RequiresAuthentication
    @RequiresPermissions(value={"collectors:delete"})
    @ApiOperation(value="Delete snippet from configuration")
    @ApiResponses(value={@ApiResponse(code=404, message="Configuration or Snippet not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="collector:snippet:delete")
    public void deleteSnippet(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="snippetId") String snippetId) throws NotFoundException {
        this.etagService.invalidateAll();
        this.collectorConfigurationService.deleteSnippet(id, snippetId);
    }

    private CollectorConfigurationSummary getCollectorConfigurationSummary(CollectorConfiguration collectorConfiguration) {
        return CollectorConfigurationSummary.create(collectorConfiguration.id(), collectorConfiguration.name(), collectorConfiguration.tags());
    }

    private List<String> parseQueryTags(String queryTags) {
        List tags = null;
        if (queryTags != null) {
            try {
                tags = (List)this.mapper.readValue(queryTags, (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (IOException e) {
                LOG.error("Can not parse provided collector tags: {}", (Object)queryTags);
                tags = null;
            }
        }
        return tags;
    }

    private String configToEtag(CollectorConfiguration collectorConfiguration) {
        return Hashing.md5().hashInt(collectorConfiguration.hashCode()).toString();
    }

    public static class RestBoolean {
        private static final RestBoolean FALSE = new RestBoolean(false);
        private static final RestBoolean TRUE = new RestBoolean(true);
        private boolean value;

        private RestBoolean(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        public static RestBoolean valueOf(String value) {
            switch (value.toLowerCase()) {
                case "true": 
                case "yes": 
                case "y": {
                    return TRUE;
                }
            }
            return FALSE;
        }
    }
}

