/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.periodical;

import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.graylog.plugins.collector.collectors.CollectorService;
import org.graylog.plugins.collector.system.CollectorSystemConfiguration;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeExpiredCollectorsThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeExpiredCollectorsThread.class);
    private final CollectorService collectorService;
    private final Supplier<CollectorSystemConfiguration> configSupplier;

    @Inject
    public PurgeExpiredCollectorsThread(CollectorService collectorService, Supplier<CollectorSystemConfiguration> configSupplier) {
        this.collectorService = collectorService;
        this.configSupplier = configSupplier;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 3600;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        int purgedCollectors = this.collectorService.destroyExpired(((CollectorSystemConfiguration)this.configSupplier.get()).collectorExpirationThreshold());
        LOG.debug("Purged {} inactive collectors.", (Object)purgedCollectors);
    }
}

