/* Based on BoringSSL's client.c fuzzer */

#ifdef __cplusplus
extern "C" {
#endif

#include <hf_ssl_lib.h>
#include <libhfuzz/libhfuzz.h>

#include <assert.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#include <openssl/ssl.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>

static const uint8_t kRSACertificateDER[] = {0x30, 0x82, 0x06, 0x3d, 0x30, 0x82, 0x04, 0x25, 0xa0,
    0x03, 0x02, 0x01, 0x02, 0x02, 0x14, 0x0f, 0x2d, 0x4d, 0xdd, 0x2f, 0xa5, 0xc0, 0x5f, 0x5a, 0xd3,
    0x6e, 0x9f, 0xbe, 0x29, 0x68, 0xe9, 0x24, 0x72, 0x6c, 0xea, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
    0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x8d, 0x31, 0x0b, 0x30, 0x09,
    0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
    0x04, 0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65,
    0x74, 0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74,
    0x64, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61,
    0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20,
    0x4e, 0x61, 0x6d, 0x65, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1a, 0x6e,
    0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78,
    0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30,
    0x35, 0x30, 0x38, 0x31, 0x32, 0x35, 0x31, 0x34, 0x36, 0x5a, 0x17, 0x0d, 0x32, 0x39, 0x30, 0x35,
    0x30, 0x37, 0x31, 0x32, 0x35, 0x31, 0x34, 0x36, 0x5a, 0x30, 0x81, 0xa5, 0x31, 0x0b, 0x30, 0x09,
    0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
    0x04, 0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x0f,
    0x30, 0x0d, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x06, 0x53, 0x69, 0x64, 0x6e, 0x65, 0x79, 0x31,
    0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
    0x65, 0x74, 0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c,
    0x74, 0x64, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67,
    0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74,
    0x20, 0x4e, 0x61, 0x6d, 0x65, 0x31, 0x2a, 0x30, 0x28, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x21,
    0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65,
    0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x72, 0x73, 0x61, 0x63, 0x6c, 0x69, 0x65, 0x6e,
    0x74, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
    0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0f, 0x00, 0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02,
    0x01, 0x00, 0xe5, 0x7a, 0x6e, 0x39, 0x10, 0xe1, 0x7e, 0x28, 0x16, 0x18, 0x7c, 0xaf, 0x7f, 0x97,
    0x10, 0xf8, 0xcb, 0x89, 0xcd, 0x2d, 0xf0, 0xbc, 0xcc, 0xcd, 0x41, 0x5e, 0xb2, 0x5d, 0x6b, 0xca,
    0x1b, 0xff, 0x52, 0xcd, 0x34, 0x39, 0xfe, 0x18, 0xe4, 0x78, 0x8c, 0x73, 0xb1, 0x03, 0xa8, 0xa3,
    0xf4, 0xc1, 0x25, 0x3e, 0xda, 0x84, 0x8c, 0x92, 0x62, 0xc4, 0x13, 0x1a, 0xbb, 0x0b, 0xe4, 0x18,
    0x12, 0xb5, 0xe2, 0xb8, 0xbc, 0x45, 0x9e, 0x1d, 0xbd, 0xba, 0xe5, 0x40, 0x5d, 0xdd, 0x59, 0x90,
    0x2f, 0xeb, 0x97, 0xb1, 0x61, 0xca, 0x9a, 0x49, 0x8a, 0x50, 0xf9, 0x9f, 0x1a, 0x78, 0xcf, 0x56,
    0xe6, 0x03, 0x53, 0xfd, 0x99, 0x0f, 0xd2, 0x3a, 0x09, 0x8b, 0x89, 0x96, 0x3a, 0x93, 0x2c, 0x88,
    0x45, 0xfd, 0xb5, 0xbe, 0x80, 0x7e, 0x33, 0x31, 0xec, 0x40, 0xef, 0x22, 0x20, 0x64, 0xa9, 0x33,
    0x4b, 0xdb, 0x29, 0xa0, 0xb5, 0x49, 0xa4, 0x1a, 0x62, 0x2d, 0xc4, 0x17, 0x66, 0x4b, 0x2d, 0x7b,
    0xff, 0xad, 0x92, 0x80, 0x30, 0x50, 0x61, 0x2e, 0x58, 0x22, 0xe5, 0xc8, 0xaa, 0xdf, 0x81, 0x53,
    0xd1, 0xbf, 0x01, 0xba, 0xc9, 0x8b, 0xd0, 0x26, 0x79, 0x23, 0x95, 0xa4, 0xe2, 0x6d, 0x06, 0xb2,
    0xb6, 0x74, 0x0b, 0xce, 0x4c, 0x99, 0x0b, 0xea, 0x49, 0x0c, 0xd4, 0x95, 0xce, 0xae, 0x57, 0x8b,
    0x8e, 0x7a, 0xc0, 0x33, 0x7f, 0x7c, 0x23, 0xc3, 0x50, 0x30, 0xc0, 0x71, 0x60, 0x02, 0xa1, 0x49,
    0x8a, 0xdf, 0x33, 0xff, 0xc8, 0xbb, 0xd0, 0xc2, 0x65, 0x15, 0x83, 0x0e, 0xa5, 0x04, 0xd6, 0xbd,
    0x97, 0x30, 0xf9, 0xa0, 0x1d, 0x81, 0x8c, 0x37, 0xd1, 0x21, 0x6b, 0xd0, 0xc1, 0x90, 0x74, 0x48,
    0x14, 0x0b, 0xcc, 0x8a, 0xc1, 0x74, 0x5e, 0xae, 0x9e, 0x7e, 0x98, 0xd6, 0x47, 0x42, 0xc4, 0x36,
    0x77, 0xd2, 0xb8, 0x60, 0xf3, 0x97, 0xa2, 0xe0, 0x9b, 0xc4, 0xac, 0x9b, 0x69, 0x40, 0x3c, 0x31,
    0xd8, 0x26, 0x19, 0x7f, 0xd3, 0x62, 0x42, 0xf7, 0xf8, 0x8a, 0x49, 0x3d, 0xb0, 0xf2, 0xab, 0x18,
    0x39, 0x9d, 0x09, 0x20, 0xbc, 0x78, 0xdd, 0xee, 0x00, 0x28, 0x91, 0xda, 0xd9, 0x40, 0x15, 0x95,
    0x27, 0xaf, 0x31, 0xbb, 0x77, 0x2f, 0xd8, 0x5e, 0xbc, 0xa4, 0xbc, 0x55, 0x8d, 0xaa, 0x23, 0x29,
    0xf2, 0x60, 0x31, 0xb4, 0xfe, 0xaa, 0x1b, 0x0f, 0x96, 0x4f, 0x9f, 0xa2, 0x57, 0x4e, 0x77, 0x10,
    0x5e, 0x39, 0xea, 0x4b, 0x8e, 0x3c, 0x47, 0x2c, 0xf9, 0x8a, 0xba, 0x8c, 0x43, 0xc4, 0x4d, 0x7d,
    0x61, 0xe2, 0x5a, 0x85, 0x4c, 0x8a, 0x7a, 0xd6, 0x12, 0x54, 0xd6, 0xe9, 0xe0, 0xa0, 0x38, 0x6b,
    0x4d, 0x20, 0x3b, 0xa9, 0x52, 0x87, 0x46, 0x96, 0xfd, 0xec, 0xc3, 0x53, 0xb3, 0xe3, 0x49, 0x47,
    0x78, 0x73, 0xc7, 0xcd, 0xe8, 0xc0, 0x8a, 0xef, 0x03, 0x6b, 0x48, 0x56, 0xaa, 0x49, 0x86, 0x05,
    0x10, 0x04, 0xc6, 0x6e, 0x9d, 0x36, 0xd6, 0x80, 0xb9, 0xf5, 0x2b, 0x0c, 0xf5, 0x14, 0x96, 0xb7,
    0x58, 0xee, 0x8b, 0x7a, 0x95, 0xde, 0x38, 0x4c, 0x74, 0x35, 0xd3, 0x27, 0x45, 0x55, 0xe9, 0x68,
    0xb0, 0x2c, 0xea, 0x0e, 0xee, 0x06, 0x1a, 0x9d, 0x07, 0x92, 0x29, 0x78, 0xe1, 0x57, 0x1b, 0xd9,
    0x4d, 0x50, 0x55, 0x5c, 0x6b, 0xb2, 0x8d, 0x6c, 0x1d, 0xc6, 0xea, 0x76, 0x35, 0x3c, 0x37, 0x45,
    0xcb, 0x6c, 0x32, 0x69, 0x02, 0xbf, 0x9b, 0x58, 0x3e, 0xf2, 0x59, 0x34, 0x98, 0x8a, 0x3c, 0x59,
    0x69, 0x49, 0x44, 0x9f, 0x69, 0x37, 0xd5, 0x17, 0x90, 0xc5, 0xa3, 0x0b, 0x78, 0x4b, 0x8c, 0xb6,
    0x80, 0x80, 0x0f, 0xb5, 0x06, 0x92, 0x76, 0x35, 0x5a, 0xea, 0x16, 0x26, 0x0f, 0x4b, 0x09, 0xc3,
    0xd3, 0x3b, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x7b, 0x30, 0x79, 0x30, 0x09, 0x06, 0x03, 0x55,
    0x1d, 0x13, 0x04, 0x02, 0x30, 0x00, 0x30, 0x2c, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xf8,
    0x42, 0x01, 0x0d, 0x04, 0x1f, 0x16, 0x1d, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x53, 0x4c, 0x20, 0x47,
    0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
    0x63, 0x61, 0x74, 0x65, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x07,
    0x0a, 0xa6, 0x68, 0x4b, 0x90, 0x87, 0xf4, 0x03, 0xc5, 0x70, 0xca, 0xd2, 0xa8, 0xbe, 0x39, 0xcb,
    0xc0, 0xe4, 0x15, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14,
    0xb4, 0x59, 0x44, 0x9c, 0xe3, 0x18, 0xd1, 0x69, 0x15, 0x4a, 0x38, 0x8b, 0x82, 0x0d, 0x19, 0x83,
    0x1f, 0xe0, 0x02, 0x37, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01,
    0x0b, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0xbf, 0x7d, 0xac, 0xea, 0x15, 0x9d, 0x87, 0x98,
    0xbe, 0xa9, 0xff, 0xa0, 0x26, 0xad, 0x46, 0x60, 0xe7, 0x7d, 0xc2, 0xda, 0x3b, 0xc3, 0x5e, 0xce,
    0xdc, 0x6f, 0xc2, 0x49, 0x32, 0x15, 0x0c, 0x8c, 0xda, 0x20, 0x22, 0x69, 0xec, 0x7f, 0xdf, 0x3d,
    0x06, 0xcf, 0x1f, 0x4d, 0x28, 0x32, 0xf7, 0x3f, 0xa1, 0x85, 0xeb, 0xba, 0x34, 0x47, 0xa5, 0x98,
    0xdf, 0x1d, 0xf7, 0xbe, 0xfd, 0x26, 0x3f, 0x08, 0x3a, 0x7c, 0x33, 0x31, 0x19, 0x36, 0x02, 0xff,
    0xc7, 0x6f, 0xea, 0x79, 0x44, 0xef, 0x4b, 0x47, 0x3d, 0x06, 0xfe, 0x5a, 0x02, 0x1d, 0x5e, 0xcc,
    0xb7, 0x5f, 0x72, 0x7a, 0xe6, 0x81, 0x82, 0x16, 0xeb, 0x78, 0xb4, 0x9e, 0x33, 0x3a, 0xf7, 0x83,
    0xb0, 0x8f, 0x9c, 0xae, 0xb6, 0xd3, 0x35, 0x34, 0xac, 0x54, 0x3e, 0x41, 0xe8, 0x0a, 0x0c, 0xba,
    0x35, 0x72, 0x79, 0x48, 0x3b, 0x8f, 0x4b, 0x8d, 0xcc, 0xea, 0x61, 0xdb, 0x95, 0xe4, 0x94, 0xb3,
    0xb9, 0x48, 0x98, 0xbc, 0xe5, 0x58, 0xc8, 0xb7, 0x4b, 0x69, 0x7c, 0x17, 0x23, 0x37, 0xec, 0xb3,
    0xef, 0xea, 0x12, 0x3b, 0x08, 0x1c, 0xf1, 0x30, 0xe4, 0x3f, 0x33, 0x3f, 0xd6, 0x9d, 0x61, 0xa1,
    0x3a, 0x04, 0xb6, 0x36, 0x2f, 0xc5, 0xc3, 0x18, 0xfd, 0x08, 0x20, 0x04, 0x6f, 0xd6, 0x52, 0xc9,
    0x2f, 0x82, 0x2b, 0x96, 0xdf, 0xb8, 0x29, 0x4d, 0xf2, 0x00, 0x0e, 0x9f, 0xe5, 0x2f, 0xdc, 0x7f,
    0x41, 0x60, 0xf1, 0x6b, 0xec, 0xfb, 0x9c, 0xb3, 0x3c, 0x81, 0xfa, 0xa8, 0x27, 0xe0, 0x34, 0x01,
    0xa4, 0xee, 0x5a, 0xda, 0x6c, 0xf1, 0xc1, 0xd2, 0x91, 0xd8, 0x96, 0x54, 0x64, 0xf6, 0x2c, 0x40,
    0x72, 0x3e, 0x9a, 0x15, 0xe0, 0xb5, 0xc9, 0xfa, 0xa4, 0xfc, 0x0d, 0x1c, 0x21, 0xd5, 0xdb, 0x7e,
    0x30, 0xb4, 0x26, 0xa1, 0x54, 0xc2, 0x63, 0x41, 0x87, 0x37, 0xa5, 0x6a, 0x9d, 0x89, 0xce, 0x21,
    0x85, 0x46, 0xdd, 0x24, 0x8a, 0x14, 0x13, 0x7e, 0x76, 0x2b, 0x12, 0xd7, 0xc5, 0xfc, 0x78, 0x56,
    0xb9, 0x8a, 0xf9, 0x13, 0xa7, 0xa8, 0xcb, 0xa2, 0x56, 0x1a, 0xc5, 0xa5, 0xbc, 0xc5, 0xb6, 0xac,
    0xa9, 0x95, 0x2c, 0x81, 0x57, 0x13, 0x03, 0xe9, 0x05, 0x68, 0x2b, 0xe6, 0x4a, 0xa4, 0x31, 0xb8,
    0xd8, 0x09, 0xb2, 0x4d, 0x40, 0x98, 0x7e, 0xd7, 0xa1, 0x15, 0x05, 0x8b, 0x8d, 0xcd, 0x75, 0xbd,
    0x1d, 0xf5, 0x15, 0xf5, 0xce, 0xd7, 0x11, 0x48, 0x4e, 0x57, 0x0a, 0x54, 0x0f, 0x71, 0x85, 0x94,
    0xe7, 0x90, 0x6e, 0xfa, 0x21, 0xa6, 0x58, 0xd8, 0x95, 0x8f, 0x29, 0xca, 0x35, 0xc2, 0xa3, 0xf0,
    0x6a, 0x32, 0x9b, 0xe7, 0x74, 0x6e, 0x1f, 0xa5, 0xad, 0xb8, 0xb0, 0xac, 0x83, 0xcc, 0x18, 0x03,
    0xbc, 0xfe, 0xef, 0xb5, 0xfc, 0x53, 0x81, 0x4a, 0x6e, 0x61, 0xd5, 0x17, 0x28, 0xca, 0xb5, 0xbe,
    0x19, 0xef, 0xd3, 0x27, 0x70, 0xcd, 0x96, 0x6c, 0xb5, 0xa1, 0x58, 0x4e, 0xc0, 0x6b, 0xa3, 0xbf,
    0x7b, 0x23, 0xb6, 0x1b, 0x8c, 0xe0, 0x61, 0x7d, 0x2e, 0x8a, 0x15, 0xa0, 0xac, 0xf0, 0x60, 0x19,
    0x88, 0x75, 0x03, 0xdd, 0x11, 0xd4, 0x67, 0x2a, 0x91, 0x10, 0x53, 0xd7, 0xcd, 0x91, 0x29, 0x2b,
    0x5a, 0xf4, 0x74, 0x06, 0x47, 0x8e, 0xfd, 0x71, 0x8b, 0xca, 0x86, 0xa0, 0x26, 0xbe, 0xbb, 0x50,
    0xc3, 0x95, 0x99, 0x42, 0xcf, 0xa6, 0x2b, 0xf4, 0x12, 0x41, 0xe6, 0xf2, 0xbf, 0x25, 0xe2, 0xed,
    0x9e, 0x78, 0x9c, 0x3a, 0x21, 0x01, 0x06, 0x29, 0x96, 0x2d, 0xcd, 0xd7, 0x55, 0x62, 0x16, 0xb5,
    0xa4, 0x5f, 0x14, 0x19, 0xc1, 0x9c, 0x38, 0xbf, 0x41, 0x51, 0xec, 0x98, 0x2c, 0x6a, 0xc0, 0x41,
    0x0f, 0xe6, 0xc5, 0xf0, 0x32, 0xa9, 0xbe, 0xd7};

static const uint8_t kRSAPrivateKeyDER[] = {0x30, 0x82, 0x09, 0x29, 0x02, 0x01, 0x00, 0x02, 0x82,
    0x02, 0x01, 0x00, 0xe5, 0x7a, 0x6e, 0x39, 0x10, 0xe1, 0x7e, 0x28, 0x16, 0x18, 0x7c, 0xaf, 0x7f,
    0x97, 0x10, 0xf8, 0xcb, 0x89, 0xcd, 0x2d, 0xf0, 0xbc, 0xcc, 0xcd, 0x41, 0x5e, 0xb2, 0x5d, 0x6b,
    0xca, 0x1b, 0xff, 0x52, 0xcd, 0x34, 0x39, 0xfe, 0x18, 0xe4, 0x78, 0x8c, 0x73, 0xb1, 0x03, 0xa8,
    0xa3, 0xf4, 0xc1, 0x25, 0x3e, 0xda, 0x84, 0x8c, 0x92, 0x62, 0xc4, 0x13, 0x1a, 0xbb, 0x0b, 0xe4,
    0x18, 0x12, 0xb5, 0xe2, 0xb8, 0xbc, 0x45, 0x9e, 0x1d, 0xbd, 0xba, 0xe5, 0x40, 0x5d, 0xdd, 0x59,
    0x90, 0x2f, 0xeb, 0x97, 0xb1, 0x61, 0xca, 0x9a, 0x49, 0x8a, 0x50, 0xf9, 0x9f, 0x1a, 0x78, 0xcf,
    0x56, 0xe6, 0x03, 0x53, 0xfd, 0x99, 0x0f, 0xd2, 0x3a, 0x09, 0x8b, 0x89, 0x96, 0x3a, 0x93, 0x2c,
    0x88, 0x45, 0xfd, 0xb5, 0xbe, 0x80, 0x7e, 0x33, 0x31, 0xec, 0x40, 0xef, 0x22, 0x20, 0x64, 0xa9,
    0x33, 0x4b, 0xdb, 0x29, 0xa0, 0xb5, 0x49, 0xa4, 0x1a, 0x62, 0x2d, 0xc4, 0x17, 0x66, 0x4b, 0x2d,
    0x7b, 0xff, 0xad, 0x92, 0x80, 0x30, 0x50, 0x61, 0x2e, 0x58, 0x22, 0xe5, 0xc8, 0xaa, 0xdf, 0x81,
    0x53, 0xd1, 0xbf, 0x01, 0xba, 0xc9, 0x8b, 0xd0, 0x26, 0x79, 0x23, 0x95, 0xa4, 0xe2, 0x6d, 0x06,
    0xb2, 0xb6, 0x74, 0x0b, 0xce, 0x4c, 0x99, 0x0b, 0xea, 0x49, 0x0c, 0xd4, 0x95, 0xce, 0xae, 0x57,
    0x8b, 0x8e, 0x7a, 0xc0, 0x33, 0x7f, 0x7c, 0x23, 0xc3, 0x50, 0x30, 0xc0, 0x71, 0x60, 0x02, 0xa1,
    0x49, 0x8a, 0xdf, 0x33, 0xff, 0xc8, 0xbb, 0xd0, 0xc2, 0x65, 0x15, 0x83, 0x0e, 0xa5, 0x04, 0xd6,
    0xbd, 0x97, 0x30, 0xf9, 0xa0, 0x1d, 0x81, 0x8c, 0x37, 0xd1, 0x21, 0x6b, 0xd0, 0xc1, 0x90, 0x74,
    0x48, 0x14, 0x0b, 0xcc, 0x8a, 0xc1, 0x74, 0x5e, 0xae, 0x9e, 0x7e, 0x98, 0xd6, 0x47, 0x42, 0xc4,
    0x36, 0x77, 0xd2, 0xb8, 0x60, 0xf3, 0x97, 0xa2, 0xe0, 0x9b, 0xc4, 0xac, 0x9b, 0x69, 0x40, 0x3c,
    0x31, 0xd8, 0x26, 0x19, 0x7f, 0xd3, 0x62, 0x42, 0xf7, 0xf8, 0x8a, 0x49, 0x3d, 0xb0, 0xf2, 0xab,
    0x18, 0x39, 0x9d, 0x09, 0x20, 0xbc, 0x78, 0xdd, 0xee, 0x00, 0x28, 0x91, 0xda, 0xd9, 0x40, 0x15,
    0x95, 0x27, 0xaf, 0x31, 0xbb, 0x77, 0x2f, 0xd8, 0x5e, 0xbc, 0xa4, 0xbc, 0x55, 0x8d, 0xaa, 0x23,
    0x29, 0xf2, 0x60, 0x31, 0xb4, 0xfe, 0xaa, 0x1b, 0x0f, 0x96, 0x4f, 0x9f, 0xa2, 0x57, 0x4e, 0x77,
    0x10, 0x5e, 0x39, 0xea, 0x4b, 0x8e, 0x3c, 0x47, 0x2c, 0xf9, 0x8a, 0xba, 0x8c, 0x43, 0xc4, 0x4d,
    0x7d, 0x61, 0xe2, 0x5a, 0x85, 0x4c, 0x8a, 0x7a, 0xd6, 0x12, 0x54, 0xd6, 0xe9, 0xe0, 0xa0, 0x38,
    0x6b, 0x4d, 0x20, 0x3b, 0xa9, 0x52, 0x87, 0x46, 0x96, 0xfd, 0xec, 0xc3, 0x53, 0xb3, 0xe3, 0x49,
    0x47, 0x78, 0x73, 0xc7, 0xcd, 0xe8, 0xc0, 0x8a, 0xef, 0x03, 0x6b, 0x48, 0x56, 0xaa, 0x49, 0x86,
    0x05, 0x10, 0x04, 0xc6, 0x6e, 0x9d, 0x36, 0xd6, 0x80, 0xb9, 0xf5, 0x2b, 0x0c, 0xf5, 0x14, 0x96,
    0xb7, 0x58, 0xee, 0x8b, 0x7a, 0x95, 0xde, 0x38, 0x4c, 0x74, 0x35, 0xd3, 0x27, 0x45, 0x55, 0xe9,
    0x68, 0xb0, 0x2c, 0xea, 0x0e, 0xee, 0x06, 0x1a, 0x9d, 0x07, 0x92, 0x29, 0x78, 0xe1, 0x57, 0x1b,
    0xd9, 0x4d, 0x50, 0x55, 0x5c, 0x6b, 0xb2, 0x8d, 0x6c, 0x1d, 0xc6, 0xea, 0x76, 0x35, 0x3c, 0x37,
    0x45, 0xcb, 0x6c, 0x32, 0x69, 0x02, 0xbf, 0x9b, 0x58, 0x3e, 0xf2, 0x59, 0x34, 0x98, 0x8a, 0x3c,
    0x59, 0x69, 0x49, 0x44, 0x9f, 0x69, 0x37, 0xd5, 0x17, 0x90, 0xc5, 0xa3, 0x0b, 0x78, 0x4b, 0x8c,
    0xb6, 0x80, 0x80, 0x0f, 0xb5, 0x06, 0x92, 0x76, 0x35, 0x5a, 0xea, 0x16, 0x26, 0x0f, 0x4b, 0x09,
    0xc3, 0xd3, 0x3b, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02, 0x82, 0x02, 0x01, 0x00, 0x9e, 0x4f, 0x64,
    0x13, 0x02, 0x4e, 0x4d, 0xd6, 0x21, 0xc8, 0x2a, 0xdc, 0x77, 0xcd, 0x23, 0xec, 0x3f, 0x9e, 0x85,
    0x6a, 0x18, 0x16, 0x67, 0xc3, 0x82, 0x41, 0x6e, 0x13, 0x7c, 0xf5, 0x25, 0x73, 0x73, 0x10, 0x15,
    0xe3, 0x9c, 0x24, 0x58, 0x19, 0xc1, 0xeb, 0x5e, 0x47, 0x03, 0xe4, 0x78, 0x49, 0x77, 0x04, 0x71,
    0x83, 0xd7, 0xe6, 0x75, 0x34, 0x87, 0x69, 0x7d, 0x78, 0xaa, 0x96, 0xe0, 0xf1, 0x91, 0xc3, 0x98,
    0x3e, 0xfe, 0xe1, 0xcd, 0xae, 0x4d, 0xd1, 0xa5, 0xef, 0xba, 0x85, 0xfa, 0x49, 0x31, 0x91, 0x31,
    0xc1, 0xaf, 0xc6, 0xe4, 0x21, 0x10, 0xd4, 0x6e, 0x52, 0xc1, 0xd7, 0x55, 0x3f, 0x1e, 0x86, 0x69,
    0x3d, 0xbc, 0xee, 0x44, 0xff, 0x7a, 0x9f, 0xa5, 0x31, 0x3b, 0x1b, 0x98, 0x0d, 0x7b, 0x80, 0x3c,
    0xec, 0xd3, 0x2c, 0xb1, 0xab, 0xea, 0x4d, 0x44, 0xc3, 0xac, 0xe6, 0xb2, 0x82, 0x33, 0xa9, 0xa6,
    0xe7, 0x72, 0xca, 0xb0, 0xc8, 0x99, 0xea, 0xfa, 0xab, 0x0a, 0x69, 0xec, 0xed, 0x35, 0x90, 0x31,
    0xc4, 0x82, 0x06, 0x92, 0xcf, 0x20, 0x6e, 0xdb, 0x52, 0xed, 0xc9, 0x81, 0x7d, 0xa0, 0x17, 0xd8,
    0x4b, 0x18, 0x02, 0x32, 0xb8, 0x15, 0xd8, 0x76, 0x4c, 0x78, 0xbe, 0x79, 0x98, 0x7d, 0x3c, 0x89,
    0x23, 0x5c, 0x50, 0xf8, 0xac, 0x5d, 0x4c, 0x2c, 0x15, 0xa2, 0x57, 0xa8, 0xa7, 0x8e, 0x48, 0xf8,
    0xbe, 0x0f, 0x7e, 0x02, 0xa8, 0x5f, 0x5a, 0xd7, 0xbd, 0x78, 0xbf, 0x5f, 0x8a, 0xb4, 0x38, 0xd5,
    0xa6, 0x9c, 0x52, 0x3f, 0xa2, 0x23, 0x93, 0xca, 0xcc, 0x17, 0xc9, 0x1b, 0xb0, 0xb1, 0xc5, 0x80,
    0x15, 0x8b, 0x42, 0x46, 0x88, 0x23, 0xf5, 0x14, 0x54, 0x2f, 0xa4, 0x3a, 0x10, 0x19, 0xbf, 0xef,
    0xcd, 0xf4, 0x33, 0xcb, 0x2b, 0xd3, 0x0c, 0xa0, 0x84, 0xb3, 0x10, 0x50, 0x80, 0x43, 0xd7, 0x7b,
    0xb9, 0x75, 0x89, 0x62, 0x45, 0x77, 0xeb, 0xe2, 0x95, 0x34, 0x52, 0xbf, 0xe3, 0x9a, 0x0d, 0x4b,
    0x22, 0x97, 0xa0, 0xe3, 0x0f, 0x32, 0x3c, 0x16, 0x22, 0xa4, 0x1d, 0xfb, 0x77, 0x25, 0x11, 0xcb,
    0x45, 0x64, 0xda, 0x1d, 0xa1, 0x72, 0xbb, 0x0d, 0x31, 0xdd, 0xe9, 0x4b, 0xe4, 0x11, 0x7b, 0x35,
    0x8b, 0xde, 0x88, 0xc1, 0x35, 0xe6, 0x3a, 0xa6, 0xe6, 0x99, 0x8f, 0xa5, 0x1c, 0x66, 0xab, 0x62,
    0x3b, 0xd9, 0x53, 0xf2, 0x38, 0x26, 0xa2, 0xc6, 0xdf, 0xf2, 0x9e, 0xa1, 0xf2, 0xf7, 0xe0, 0xc9,
    0x1c, 0xd4, 0x82, 0x1f, 0x7c, 0x90, 0xc6, 0xb3, 0xbb, 0x58, 0x31, 0x5f, 0x5b, 0x42, 0xc5, 0xc6,
    0x6c, 0x66, 0xdb, 0xc5, 0x43, 0xab, 0x4c, 0x1f, 0x11, 0x83, 0xfe, 0x75, 0x42, 0xf0, 0x4c, 0xb9,
    0xd6, 0xc1, 0x19, 0xf4, 0x8a, 0x06, 0xc2, 0x0d, 0x22, 0x81, 0xb6, 0xad, 0x29, 0xf3, 0xcb, 0xe4,
    0xe8, 0x5b, 0x6f, 0x04, 0x19, 0x8a, 0x73, 0x10, 0xa0, 0x6f, 0xba, 0x29, 0x5d, 0x24, 0x33, 0x66,
    0xd9, 0xd2, 0x0f, 0x88, 0xdf, 0x59, 0x30, 0xc4, 0x85, 0x9b, 0x9d, 0x00, 0x97, 0xc3, 0xa7, 0x72,
    0xbb, 0xc3, 0x92, 0x18, 0x0d, 0xac, 0x3d, 0xab, 0x17, 0xe7, 0x9c, 0xd0, 0x2e, 0x7d, 0xae, 0x1c,
    0x81, 0xef, 0xc4, 0xcc, 0x33, 0x25, 0xf9, 0x5b, 0x8b, 0x03, 0xc9, 0xd3, 0x14, 0x9c, 0x78, 0x9b,
    0xd1, 0x0b, 0x02, 0xe5, 0x24, 0xba, 0x99, 0xff, 0xbf, 0x18, 0x03, 0xd7, 0xec, 0x71, 0x74, 0x34,
    0xd6, 0xe7, 0xcb, 0x37, 0xa7, 0x42, 0x20, 0x89, 0xf5, 0x5f, 0x7f, 0x5a, 0xef, 0xec, 0xb7, 0xbc,
    0x92, 0xeb, 0x47, 0x4c, 0x1f, 0x68, 0x87, 0xcb, 0x2e, 0x72, 0xe6, 0x96, 0xef, 0x98, 0xa9, 0x89,
    0x26, 0x48, 0xff, 0x8a, 0xbe, 0xf4, 0x0b, 0xd0, 0x23, 0x84, 0x79, 0x73, 0x41, 0x02, 0x82, 0x01,
    0x01, 0x00, 0xfe, 0x94, 0x2b, 0x4f, 0xfb, 0x93, 0x58, 0xc1, 0xcf, 0xde, 0xd4, 0x81, 0x42, 0x17,
    0x12, 0x02, 0x3c, 0x40, 0xdd, 0xd7, 0xae, 0x68, 0xa8, 0x8e, 0x6c, 0x51, 0xab, 0x06, 0xe4, 0xf7,
    0x30, 0x48, 0x77, 0x87, 0x8a, 0xd5, 0x8b, 0xaf, 0x0f, 0x46, 0x8f, 0x70, 0x49, 0x80, 0x0c, 0x94,
    0xf8, 0xc6, 0x11, 0x7f, 0x65, 0x01, 0xdd, 0xea, 0xa0, 0x34, 0x4e, 0x25, 0x7a, 0xc6, 0xe7, 0xf4,
    0x9c, 0x9e, 0xf4, 0x6c, 0xf7, 0x49, 0xd5, 0xde, 0xfa, 0xb0, 0xa6, 0x8c, 0xf8, 0x35, 0xdb, 0x58,
    0x40, 0xc6, 0x77, 0xeb, 0x1c, 0xbf, 0x54, 0x6f, 0xb8, 0x1d, 0x97, 0xbc, 0x07, 0x61, 0x18, 0xb1,
    0xf2, 0xe2, 0xfe, 0x3b, 0x01, 0x70, 0x97, 0x4f, 0x51, 0xc6, 0x49, 0xe8, 0xe5, 0x20, 0x07, 0x3e,
    0x52, 0x37, 0x13, 0x8d, 0x6b, 0xda, 0x03, 0xcf, 0xec, 0x5d, 0xcf, 0x9b, 0xf8, 0xe7, 0x86, 0x15,
    0xa8, 0x26, 0xf2, 0x7a, 0x4f, 0xeb, 0xfe, 0xa2, 0xac, 0xd1, 0x60, 0xd6, 0x7b, 0x5c, 0xa8, 0xaa,
    0xf6, 0x71, 0x1e, 0xe2, 0xaf, 0x87, 0x11, 0xe2, 0xf2, 0x25, 0xaa, 0xf0, 0x67, 0x3c, 0x33, 0xfa,
    0xbc, 0x3a, 0x25, 0x09, 0x01, 0xd3, 0xba, 0xb7, 0x66, 0x3b, 0xae, 0x3a, 0x2f, 0x0b, 0xb7, 0xa6,
    0xd0, 0x43, 0xb1, 0x4f, 0x9e, 0xbe, 0x37, 0xc4, 0x95, 0x7f, 0x7e, 0x44, 0x7d, 0xff, 0xda, 0xff,
    0xc4, 0x96, 0xc6, 0x27, 0x6e, 0x69, 0xc8, 0x43, 0xae, 0x9d, 0x8a, 0x8c, 0x7d, 0x0d, 0xb1, 0xd1,
    0xba, 0xf1, 0x31, 0x6d, 0x5b, 0xeb, 0x01, 0x0e, 0x48, 0xb1, 0xee, 0xf6, 0x54, 0xaf, 0x0f, 0x29,
    0x86, 0xa6, 0x15, 0x31, 0xbe, 0xe1, 0x7a, 0x92, 0x1b, 0x08, 0x6d, 0x3f, 0x7b, 0xb0, 0x8c, 0x9c,
    0xdd, 0x1e, 0x4e, 0xa7, 0x16, 0x52, 0x49, 0x2f, 0x60, 0xac, 0x66, 0x23, 0x60, 0x27, 0xe2, 0x8e,
    0xda, 0x73, 0x02, 0x82, 0x01, 0x01, 0x00, 0xe6, 0xc2, 0x63, 0x93, 0xe7, 0xb2, 0xf4, 0xc9, 0xdd,
    0x85, 0x8d, 0x83, 0xcd, 0x3c, 0xca, 0x96, 0xae, 0xd5, 0x57, 0x3f, 0xc7, 0x34, 0xa2, 0x44, 0x43,
    0x97, 0xe1, 0x6b, 0x12, 0x05, 0x96, 0xa1, 0x52, 0x9b, 0x4c, 0x5e, 0x43, 0xa3, 0xdf, 0x72, 0x19,
    0x72, 0x82, 0xfe, 0x5e, 0xaf, 0xa2, 0x3b, 0x1b, 0x64, 0x52, 0xd3, 0x1c, 0x55, 0x2c, 0x98, 0x6e,
    0x74, 0xda, 0x19, 0x90, 0x32, 0x60, 0x20, 0xb4, 0x9e, 0x90, 0xa1, 0xe8, 0xbd, 0x08, 0x89, 0xed,
    0x67, 0x1a, 0x46, 0x02, 0xc1, 0xc2, 0x9e, 0xb7, 0xe8, 0xfc, 0xd6, 0x5b, 0x50, 0xa1, 0xb6, 0xc9,
    0xe0, 0x21, 0xec, 0x0d, 0x10, 0x83, 0xe0, 0x4b, 0xff, 0xf3, 0xfb, 0x37, 0x08, 0x1f, 0x2a, 0x0d,
    0xfd, 0x80, 0xf6, 0x0f, 0xe1, 0xcd, 0x2c, 0xc1, 0x31, 0xca, 0x58, 0x95, 0x31, 0x59, 0xb1, 0xf2,
    0xcf, 0xb1, 0x89, 0x24, 0xa5, 0x5a, 0x11, 0xce, 0x11, 0x86, 0xbb, 0x7f, 0x18, 0xf3, 0x5f, 0x97,
    0x7a, 0x98, 0x21, 0xcb, 0x03, 0xaa, 0x6b, 0x8e, 0xa1, 0x39, 0x48, 0x13, 0x90, 0x04, 0x1b, 0xad,
    0xf3, 0xc0, 0xf9, 0x11, 0x35, 0x71, 0x4e, 0x1d, 0xd5, 0xfd, 0x62, 0xa0, 0x79, 0x3e, 0x72, 0x6e,
    0x3e, 0x83, 0x72, 0xc9, 0xd7, 0x1e, 0xd5, 0x5e, 0xe8, 0x3f, 0x16, 0x2b, 0x99, 0xcc, 0x8e, 0x2e,
    0xed, 0x71, 0x78, 0xbb, 0x6b, 0xab, 0xbf, 0xb3, 0x24, 0xd1, 0x04, 0xe0, 0x22, 0x11, 0xab, 0x55,
    0xd1, 0x9b, 0x97, 0xba, 0x01, 0x36, 0x5e, 0xd2, 0x24, 0x39, 0xb6, 0x9c, 0xad, 0x7b, 0xef, 0x0c,
    0xdc, 0xf7, 0x10, 0xd2, 0xca, 0x95, 0xf9, 0xa3, 0x4d, 0x45, 0x2c, 0x28, 0xdc, 0xcc, 0x1b, 0x44,
    0x63, 0x1f, 0xca, 0x01, 0xf3, 0x93, 0xe6, 0x7a, 0x8a, 0xca, 0x96, 0x2f, 0x1e, 0x8d, 0x8e, 0xc1,
    0x2f, 0x6f, 0xed, 0x9b, 0x98, 0x0a, 0x19, 0x02, 0x82, 0x01, 0x01, 0x00, 0x93, 0x55, 0xdb, 0x6f,
    0x51, 0xd1, 0x28, 0x18, 0x1b, 0x1f, 0x02, 0x6b, 0xc0, 0x7d, 0x2b, 0x9e, 0x01, 0x93, 0x25, 0x11,
    0x13, 0x4e, 0x5c, 0xe6, 0xf8, 0x87, 0x97, 0x6c, 0xc9, 0x0c, 0xca, 0x73, 0xd6, 0x41, 0xaa, 0xb7,
    0x06, 0x3d, 0x8d, 0xa0, 0xaf, 0x99, 0x33, 0xe0, 0x98, 0xe7, 0x8a, 0xc6, 0xcf, 0x0f, 0xa4, 0xbc,
    0x9c, 0xdb, 0x92, 0x56, 0x53, 0x37, 0xdb, 0xc3, 0xcc, 0x30, 0xc4, 0x88, 0x36, 0x3b, 0xee, 0x2e,
    0x5c, 0x49, 0xcd, 0x5a, 0x79, 0x39, 0xb2, 0xd9, 0x30, 0x95, 0xf5, 0xff, 0x27, 0x1d, 0xfa, 0x28,
    0x3d, 0x4c, 0xdf, 0x08, 0xb9, 0x6d, 0x47, 0xf4, 0x08, 0xdf, 0xcc, 0x0b, 0x55, 0x49, 0x7e, 0xfe,
    0xd3, 0x83, 0x43, 0x77, 0x78, 0x05, 0x02, 0xbe, 0x33, 0x92, 0xfc, 0xf0, 0x05, 0x2f, 0xde, 0xd0,
    0x71, 0x4e, 0x5f, 0xa4, 0xb7, 0x67, 0xb4, 0x79, 0x02, 0x1f, 0xfc, 0x8e, 0x75, 0xdd, 0x15, 0xee,
    0x26, 0x13, 0xad, 0xe3, 0x0b, 0xa1, 0x76, 0x09, 0xdd, 0x4f, 0xfc, 0x8a, 0xe1, 0x6e, 0x1e, 0x5a,
    0x14, 0x9e, 0xfc, 0xb7, 0x92, 0x23, 0xca, 0x0b, 0x8c, 0xa5, 0xbb, 0x54, 0x07, 0x65, 0x1c, 0x1a,
    0x96, 0xc0, 0x57, 0xb9, 0x88, 0x8f, 0x01, 0xf5, 0x4d, 0x17, 0x8d, 0x06, 0xf0, 0x52, 0x7d, 0x33,
    0xe7, 0x80, 0xad, 0x68, 0xf9, 0x01, 0xd8, 0xce, 0x3f, 0xc7, 0xb0, 0xd5, 0xf5, 0xde, 0x92, 0x47,
    0x44, 0x70, 0xef, 0x59, 0x1b, 0xfb, 0x4c, 0xd0, 0xa5, 0x2e, 0x15, 0x7c, 0x4b, 0xb7, 0xd7, 0xef,
    0xbd, 0x4f, 0xb0, 0x00, 0xd2, 0xa4, 0xdb, 0xc3, 0xe9, 0x09, 0x86, 0x75, 0x0e, 0x65, 0x18, 0xec,
    0xd4, 0x0c, 0x44, 0xfa, 0xee, 0x87, 0x44, 0x25, 0x9c, 0x6b, 0x98, 0x89, 0x56, 0xc9, 0xda, 0xe0,
    0x4a, 0x9c, 0xd1, 0xdd, 0x54, 0xcb, 0x7a, 0x75, 0xfa, 0xe7, 0xe4, 0x43, 0x02, 0x82, 0x01, 0x00,
    0x6d, 0x2a, 0xb1, 0x29, 0x1b, 0x87, 0xd1, 0xbe, 0x5e, 0x09, 0xfc, 0x74, 0xc9, 0xf7, 0x64, 0x6f,
    0xfc, 0xad, 0xf8, 0xe4, 0xb7, 0x3c, 0xf3, 0x37, 0x10, 0x33, 0x1d, 0xf5, 0x25, 0x45, 0x77, 0x89,
    0x42, 0x27, 0x2d, 0xed, 0xba, 0x5a, 0x20, 0x2f, 0x3e, 0x52, 0xaa, 0x1d, 0xe4, 0x75, 0x7a, 0x6e,
    0x33, 0xfb, 0x36, 0x23, 0xa1, 0x57, 0xba, 0x0d, 0x32, 0xd4, 0x1d, 0x09, 0xd2, 0xe9, 0xc2, 0x08,
    0x36, 0xea, 0x7c, 0xc9, 0xdb, 0xec, 0xf1, 0xc9, 0x2e, 0x82, 0x84, 0x2f, 0x72, 0xc6, 0x6f, 0x67,
    0xde, 0xe1, 0x5e, 0x1b, 0x9a, 0x7f, 0x7e, 0xc1, 0x96, 0xa7, 0x6d, 0xe4, 0xda, 0x19, 0x62, 0x0a,
    0x0e, 0x6a, 0x3b, 0xe6, 0x30, 0x96, 0xab, 0x07, 0x9e, 0x2e, 0xbb, 0x7f, 0xac, 0xeb, 0xc9, 0xc0,
    0xce, 0x74, 0xdb, 0xa1, 0x24, 0x93, 0x80, 0x37, 0x6b, 0x03, 0x4e, 0x9d, 0xee, 0xb4, 0x3a, 0xf4,
    0x09, 0x64, 0xc9, 0x34, 0x92, 0x60, 0x1f, 0x62, 0xad, 0xaa, 0xd5, 0xa5, 0xc7, 0x01, 0x28, 0xf2,
    0x51, 0x3b, 0x7c, 0x79, 0xd8, 0xa7, 0x5d, 0x0a, 0x2b, 0x35, 0x11, 0xa9, 0xc2, 0xb6, 0x61, 0xaf,
    0xee, 0xf5, 0x79, 0x35, 0xdb, 0x6d, 0x00, 0x59, 0xea, 0x45, 0xb0, 0xb1, 0xf1, 0x42, 0xcf, 0xd7,
    0x69, 0x5a, 0xbd, 0xdd, 0xa3, 0x2a, 0xd3, 0x56, 0xc0, 0x64, 0x9c, 0x35, 0xdd, 0x94, 0x86, 0x5f,
    0xde, 0x44, 0x20, 0x8e, 0x09, 0xea, 0x94, 0x29, 0x56, 0x24, 0x1f, 0x53, 0x9c, 0x2f, 0x4e, 0xa5,
    0x75, 0x0c, 0xa6, 0x30, 0xf9, 0xd6, 0x28, 0xb7, 0x62, 0x82, 0x76, 0x6f, 0x83, 0x09, 0x4c, 0x02,
    0x19, 0x7b, 0x48, 0xaa, 0x27, 0x7a, 0xad, 0x24, 0x89, 0x29, 0xcb, 0xb4, 0x29, 0x50, 0x2e, 0x3b,
    0xee, 0xe5, 0x12, 0x0a, 0x12, 0xa8, 0x85, 0x97, 0x6f, 0x55, 0x1d, 0xc2, 0x6e, 0xc5, 0x72, 0xa1,
    0x02, 0x82, 0x01, 0x00, 0x53, 0x9d, 0x62, 0x18, 0x68, 0x6b, 0x65, 0xad, 0x27, 0x70, 0x43, 0x17,
    0x85, 0x8f, 0x13, 0xdc, 0x56, 0x14, 0xa7, 0xcf, 0xab, 0x3a, 0x1c, 0x47, 0x8a, 0x20, 0x97, 0x20,
    0x24, 0x63, 0x74, 0x84, 0xa8, 0x9c, 0x62, 0x75, 0xf8, 0x79, 0x68, 0x51, 0x88, 0x4d, 0x2e, 0x89,
    0x5c, 0x16, 0xa7, 0x17, 0xf0, 0x50, 0x38, 0xf6, 0x3f, 0x84, 0x14, 0x21, 0x3e, 0x6b, 0xa9, 0xe2,
    0x32, 0x66, 0x27, 0xbe, 0x41, 0xad, 0x41, 0x74, 0x1b, 0x47, 0x9b, 0x42, 0xfc, 0xf5, 0xb7, 0xcf,
    0xf0, 0xcd, 0xb1, 0xf1, 0x58, 0xe3, 0xc7, 0x83, 0x20, 0x8e, 0x07, 0x64, 0x2f, 0x57, 0x7e, 0xda,
    0x6c, 0x5d, 0x2a, 0x85, 0x12, 0x9e, 0xda, 0xfd, 0x98, 0xef, 0xdd, 0x22, 0xf0, 0xc5, 0xa0, 0x45,
    0xc9, 0x48, 0x97, 0xd5, 0xa0, 0x7b, 0x27, 0xb8, 0xa0, 0x56, 0x98, 0x4b, 0xd5, 0xbe, 0xef, 0x09,
    0xfe, 0x6d, 0xd2, 0x37, 0xef, 0xe1, 0x23, 0xe4, 0x97, 0xfa, 0xb5, 0xd2, 0xb4, 0x88, 0x4f, 0xc5,
    0xa1, 0x5b, 0x26, 0x49, 0x29, 0xba, 0xf9, 0x81, 0x4e, 0x75, 0x9c, 0x3b, 0x27, 0x46, 0xc2, 0xff,
    0x0a, 0x14, 0x4f, 0x59, 0xc5, 0xee, 0x51, 0xcb, 0xa7, 0x99, 0xbf, 0x51, 0x9f, 0x38, 0x9d, 0x3f,
    0xe1, 0xca, 0xd0, 0xbd, 0x6d, 0xe3, 0x4e, 0x3e, 0x84, 0xdf, 0xa9, 0x75, 0x5f, 0x1f, 0xee, 0x90,
    0x49, 0x5b, 0x91, 0x63, 0xe0, 0xa2, 0x64, 0xe4, 0xb7, 0xe6, 0x8d, 0xb4, 0xcc, 0x90, 0xbb, 0x38,
    0x5d, 0xb9, 0x93, 0xd6, 0xc6, 0x4d, 0xcf, 0x49, 0x6a, 0xeb, 0x74, 0x9a, 0xc4, 0xda, 0xc1, 0x1a,
    0x90, 0xc1, 0xc8, 0x1a, 0x45, 0x94, 0x66, 0x9d, 0x80, 0x8b, 0xe5, 0xfc, 0x38, 0x43, 0x4b, 0x26,
    0x38, 0x9d, 0x32, 0x6d, 0x9d, 0xcb, 0x0d, 0x9b, 0x5a, 0xb1, 0x4d, 0x27, 0xfa, 0x97, 0x86, 0x26,
    0xbb, 0xb4, 0x1c, 0x92};

static const uint8_t kRSACACertDER[] = {0x30, 0x82, 0x05, 0xfd, 0x30, 0x82, 0x03, 0xe5, 0xa0, 0x03,
    0x02, 0x01, 0x02, 0x02, 0x14, 0x0f, 0x2d, 0x4d, 0xdd, 0x2f, 0xa5, 0xc0, 0x5f, 0x5a, 0xd3, 0x6e,
    0x9f, 0xbe, 0x29, 0x68, 0xe9, 0x24, 0x72, 0x6c, 0xe9, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
    0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x8d, 0x31, 0x0b, 0x30, 0x09, 0x06,
    0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
    0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30,
    0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74,
    0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64,
    0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e,
    0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e,
    0x61, 0x6d, 0x65, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1a, 0x6e, 0x6f,
    0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69,
    0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30, 0x35,
    0x30, 0x38, 0x31, 0x32, 0x34, 0x30, 0x32, 0x30, 0x5a, 0x17, 0x0d, 0x32, 0x39, 0x30, 0x35, 0x30,
    0x37, 0x31, 0x32, 0x34, 0x30, 0x32, 0x30, 0x5a, 0x30, 0x81, 0x8d, 0x31, 0x0b, 0x30, 0x09, 0x06,
    0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
    0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30,
    0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74,
    0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64,
    0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e,
    0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e,
    0x61, 0x6d, 0x65, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1a, 0x6e, 0x6f,
    0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69,
    0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x61, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09,
    0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0f, 0x00,
    0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02, 0x01, 0x00, 0xd4, 0xa4, 0x24, 0xe8, 0xac, 0xef, 0xab,
    0xb4, 0xfd, 0x30, 0x45, 0xb3, 0x2f, 0x5f, 0x28, 0xa7, 0xa7, 0x55, 0x8a, 0x73, 0x6c, 0x29, 0x70,
    0x99, 0xb8, 0x13, 0x65, 0x68, 0xd2, 0x96, 0x71, 0x04, 0xc6, 0x52, 0x8e, 0xc9, 0x3e, 0xa0, 0xcb,
    0x11, 0x9c, 0xbe, 0x04, 0x66, 0x41, 0x2b, 0x85, 0x4d, 0xac, 0x2f, 0x87, 0xef, 0x7b, 0x47, 0x0b,
    0x79, 0xe3, 0x37, 0xd0, 0x9e, 0xb4, 0xfa, 0x8f, 0x94, 0x95, 0x4d, 0x41, 0x45, 0x5c, 0x75, 0x1b,
    0x1c, 0xc5, 0x1d, 0xa8, 0x3b, 0x0e, 0x87, 0x9c, 0x06, 0xc5, 0xe6, 0x19, 0x0e, 0x00, 0x88, 0xb4,
    0xfa, 0xf0, 0x3c, 0x57, 0x03, 0xd9, 0xbf, 0xee, 0x64, 0x8a, 0x22, 0x66, 0xeb, 0x4c, 0x91, 0xb3,
    0x09, 0xac, 0x13, 0x50, 0xd6, 0x41, 0x5b, 0x4f, 0x7e, 0x06, 0x9a, 0xa6, 0x9b, 0x1f, 0x07, 0x95,
    0xd0, 0xe9, 0x9e, 0x43, 0xb4, 0xe1, 0x60, 0xf0, 0x37, 0x53, 0xce, 0x73, 0xea, 0x6e, 0xad, 0x4f,
    0x73, 0xe0, 0x8b, 0x24, 0xf4, 0x6b, 0xec, 0xfc, 0x09, 0xbc, 0xed, 0x88, 0x8b, 0x92, 0xa5, 0xfe,
    0x1d, 0x51, 0x3c, 0x51, 0xe0, 0x0f, 0xb1, 0xe9, 0x9d, 0xf5, 0x24, 0x86, 0xb3, 0xd3, 0x98, 0x53,
    0x81, 0x44, 0x6e, 0x02, 0x33, 0xe1, 0x04, 0xa3, 0x8d, 0xc9, 0x50, 0xa1, 0xff, 0x8b, 0x93, 0x37,
    0xfc, 0x9c, 0xff, 0xd9, 0x8d, 0x07, 0x30, 0xdb, 0xeb, 0x6f, 0x77, 0xfb, 0x5f, 0x1b, 0xea, 0x5f,
    0x30, 0xf6, 0x30, 0xa9, 0x7b, 0xb7, 0x08, 0xed, 0x60, 0x3f, 0xb7, 0x98, 0x42, 0xcd, 0x28, 0xf8,
    0x5b, 0x68, 0x13, 0xf9, 0x31, 0x9a, 0x6c, 0x31, 0x58, 0x59, 0x1a, 0xcd, 0x2f, 0xa0, 0x5b, 0x0b,
    0xdc, 0xdb, 0xf6, 0xc0, 0x51, 0x77, 0xce, 0x65, 0xa7, 0x81, 0x29, 0x68, 0xa4, 0xf7, 0x6a, 0x23,
    0xb5, 0xf2, 0x82, 0xae, 0x6a, 0x80, 0xaf, 0x46, 0xa3, 0xfa, 0xc1, 0xee, 0x69, 0x22, 0x2a, 0x00,
    0xa4, 0x22, 0x93, 0x70, 0x70, 0x5d, 0x0b, 0xc6, 0x7d, 0x04, 0x4d, 0x68, 0x95, 0xd6, 0xaf, 0x8f,
    0x08, 0x16, 0x97, 0x64, 0x57, 0x3f, 0xb0, 0x6d, 0x1a, 0xd6, 0xc3, 0xf8, 0xbe, 0x73, 0xe4, 0x8d,
    0x39, 0x25, 0xff, 0x68, 0x2d, 0xb8, 0x0c, 0xf5, 0xd1, 0xa0, 0xe2, 0xd2, 0x41, 0x1d, 0xda, 0xbe,
    0xe9, 0x8a, 0x30, 0x9b, 0x0e, 0xed, 0xc7, 0x8c, 0xee, 0x97, 0xda, 0x5f, 0xe4, 0x18, 0x28, 0x07,
    0x53, 0xce, 0x1a, 0xff, 0x86, 0x1c, 0xc6, 0xe0, 0x0b, 0xab, 0x51, 0x95, 0xef, 0xe2, 0xdb, 0x23,
    0x0a, 0x01, 0xb5, 0x51, 0x3e, 0x5a, 0xc1, 0x32, 0xe6, 0xf2, 0xb1, 0x59, 0xe1, 0xbb, 0xaa, 0x77,
    0x4e, 0xae, 0xfa, 0x4d, 0x3c, 0x18, 0x1a, 0xdf, 0xe7, 0xde, 0x3e, 0x66, 0xc6, 0xcf, 0xbd, 0x9b,
    0xa8, 0x5a, 0x8c, 0xa1, 0x80, 0x7c, 0x3d, 0x89, 0x45, 0x40, 0x54, 0x25, 0xfa, 0x93, 0xff, 0xde,
    0x49, 0x56, 0x54, 0x45, 0x13, 0xce, 0x55, 0xb2, 0xbb, 0x19, 0x47, 0x7f, 0x5e, 0x5e, 0xd3, 0xd9,
    0xdc, 0x01, 0x5c, 0x12, 0x58, 0xdc, 0x47, 0x67, 0x6c, 0xc8, 0xbb, 0x9e, 0xa1, 0x75, 0xd1, 0x17,
    0x07, 0x07, 0x9b, 0xc4, 0x4a, 0xdd, 0x4c, 0x52, 0x48, 0x64, 0x1b, 0x64, 0x1b, 0x1a, 0x37, 0xe6,
    0x51, 0xeb, 0x0c, 0xf5, 0x49, 0x78, 0x71, 0x6a, 0x11, 0x68, 0xbf, 0x59, 0x09, 0xeb, 0x4b, 0x3a,
    0xfa, 0xbe, 0x75, 0x96, 0x07, 0x7a, 0xa6, 0xd0, 0x45, 0xb6, 0x49, 0xe7, 0x7a, 0xcc, 0xdf, 0xc7,
    0x20, 0xe8, 0xa5, 0xb6, 0xf4, 0x4f, 0x7a, 0x3b, 0xa0, 0x94, 0x9b, 0x00, 0xa8, 0x88, 0xe1, 0x4a,
    0x2d, 0x91, 0xfa, 0x5a, 0x00, 0xf2, 0x49, 0xf0, 0xba, 0x08, 0xed, 0x7a, 0xcc, 0x87, 0x01, 0xf0,
    0x84, 0xee, 0x49, 0x45, 0x7f, 0x7f, 0x71, 0x9a, 0x71, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x53,
    0x30, 0x51, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb4, 0x59, 0x44,
    0x9c, 0xe3, 0x18, 0xd1, 0x69, 0x15, 0x4a, 0x38, 0x8b, 0x82, 0x0d, 0x19, 0x83, 0x1f, 0xe0, 0x02,
    0x37, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xb4, 0x59,
    0x44, 0x9c, 0xe3, 0x18, 0xd1, 0x69, 0x15, 0x4a, 0x38, 0x8b, 0x82, 0x0d, 0x19, 0x83, 0x1f, 0xe0,
    0x02, 0x37, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03,
    0x01, 0x01, 0xff, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
    0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0x09, 0xbc, 0xf2, 0x4f, 0x06, 0x98, 0xf7, 0x8a, 0xfb,
    0x49, 0xc7, 0x78, 0x7c, 0xd7, 0x00, 0x00, 0x51, 0x75, 0x91, 0xdb, 0xd0, 0xd2, 0x9c, 0x61, 0xeb,
    0xe5, 0x15, 0x80, 0x50, 0xc8, 0xed, 0x50, 0x5c, 0x0e, 0x3b, 0x77, 0x51, 0x48, 0x44, 0xc4, 0xce,
    0x81, 0x9a, 0x60, 0x1c, 0xf1, 0xc2, 0x25, 0xfc, 0xcd, 0x7d, 0xf8, 0x2f, 0xf9, 0xcf, 0x21, 0x28,
    0x36, 0xa3, 0xc5, 0x15, 0x99, 0x75, 0x5b, 0x13, 0x65, 0xb8, 0x28, 0x1d, 0xde, 0x18, 0xaf, 0x1b,
    0xd8, 0x6f, 0xd8, 0x83, 0xbf, 0xbb, 0xa9, 0x13, 0x44, 0xfe, 0x4a, 0x19, 0xac, 0x18, 0x00, 0x94,
    0x3f, 0xdc, 0xe4, 0x34, 0x73, 0x44, 0xbf, 0x9f, 0x1b, 0x01, 0x70, 0xd5, 0x92, 0x2b, 0xce, 0x1c,
    0x63, 0xc5, 0xfb, 0x6b, 0x0e, 0xe0, 0x8d, 0x48, 0x59, 0x5c, 0xcd, 0xac, 0x62, 0x9a, 0xd0, 0xf0,
    0xa8, 0xe7, 0x35, 0x02, 0x95, 0xc9, 0x3f, 0x65, 0xab, 0x76, 0x38, 0xab, 0x18, 0x32, 0x64, 0xa7,
    0x14, 0x53, 0xc8, 0xaf, 0x49, 0x61, 0xaa, 0x94, 0x05, 0xd1, 0xaa, 0xd6, 0xea, 0x34, 0xda, 0xc8,
    0x73, 0xdb, 0xad, 0x48, 0xd8, 0xcc, 0x5a, 0x44, 0xda, 0xa6, 0x0b, 0xbb, 0xc4, 0x7b, 0xce, 0x0f,
    0x5f, 0xa6, 0x46, 0xe5, 0x90, 0xfb, 0xf0, 0xa5, 0x04, 0x0c, 0x32, 0xa8, 0x54, 0xdc, 0x62, 0x97,
    0x57, 0x4a, 0xdf, 0xb3, 0x03, 0x42, 0x64, 0xe8, 0x43, 0xc2, 0xdb, 0x38, 0x73, 0x6f, 0x67, 0x7d,
    0x6d, 0x56, 0x2f, 0x51, 0x41, 0x8f, 0x84, 0x82, 0x7e, 0x25, 0x04, 0xe2, 0x37, 0x68, 0xf8, 0x35,
    0x6a, 0x71, 0x3c, 0xde, 0xf7, 0x18, 0xb4, 0x4f, 0xbd, 0xfc, 0x73, 0x81, 0x96, 0x72, 0x03, 0x47,
    0x7c, 0x04, 0x6d, 0x76, 0x56, 0x7f, 0x27, 0x2a, 0x46, 0x20, 0x75, 0x7f, 0x0c, 0xb1, 0xd6, 0xcc,
    0x9d, 0x99, 0xcc, 0x7d, 0x23, 0x43, 0xed, 0xe2, 0xf4, 0x08, 0x4d, 0xe7, 0xf3, 0xdb, 0x0e, 0x69,
    0xfd, 0x4b, 0xb4, 0xce, 0x5e, 0x83, 0xd7, 0x0c, 0xd5, 0x43, 0x9b, 0x18, 0x9d, 0x67, 0x5b, 0x13,
    0xce, 0x50, 0x11, 0x1d, 0xa6, 0x31, 0x24, 0x6b, 0xae, 0x23, 0x41, 0xae, 0x90, 0xbb, 0x80, 0x2a,
    0x92, 0x78, 0xe8, 0x45, 0xc0, 0xde, 0xb5, 0xe7, 0x10, 0xb0, 0xac, 0x99, 0x7d, 0x3e, 0x2a, 0x38,
    0x4d, 0xb9, 0x96, 0x5d, 0x38, 0x49, 0xf1, 0x3f, 0xb8, 0x74, 0xc2, 0x3f, 0x53, 0x93, 0x7a, 0x1d,
    0x60, 0x1f, 0xb0, 0x19, 0xd1, 0xee, 0x06, 0x16, 0x68, 0x1c, 0x26, 0xa2, 0xad, 0xfd, 0xfd, 0x99,
    0x01, 0xab, 0xe1, 0xfa, 0xac, 0x9f, 0x79, 0xe7, 0xfb, 0xe4, 0xd9, 0xe4, 0xb6, 0x9f, 0xa5, 0xc2,
    0x80, 0x9e, 0x04, 0x32, 0x2f, 0x52, 0xbc, 0x39, 0xff, 0x38, 0xa8, 0x14, 0x81, 0x98, 0xef, 0x99,
    0x86, 0x3f, 0x13, 0x8d, 0x2e, 0xb8, 0xc5, 0xcc, 0x2b, 0xd9, 0xb5, 0x20, 0x21, 0x32, 0x82, 0xf4,
    0x5a, 0x37, 0xb2, 0x08, 0xaa, 0xec, 0x3f, 0x47, 0x06, 0x84, 0x55, 0x8d, 0xf3, 0xb4, 0xf3, 0xea,
    0x41, 0x56, 0x58, 0xc9, 0x1a, 0x88, 0x11, 0x93, 0x4c, 0xc5, 0x59, 0x14, 0x0e, 0x54, 0x6e, 0x5f,
    0x2b, 0x62, 0x2f, 0x5d, 0xbd, 0xfe, 0x07, 0x37, 0x2c, 0xc4, 0x6d, 0x30, 0x58, 0xb9, 0x02, 0xe7,
    0x81, 0xf8, 0x96, 0x8e, 0xbd, 0x9a, 0x03, 0x4b, 0xc1, 0x0d, 0x66, 0x28, 0xdd, 0x2f, 0xb7, 0x58,
    0xeb, 0xb8, 0x49, 0xa3, 0x91, 0xf3, 0x60, 0xe6, 0x36, 0x15, 0xb1, 0xfb, 0xb6, 0xf3, 0x54, 0x3f,
    0x7b, 0x1d, 0x10, 0xa4, 0x5a, 0x41, 0xba, 0x47, 0x92, 0xc5, 0xeb, 0x6a, 0x3b, 0xc6, 0xeb, 0xbc,
    0x05, 0x97, 0xc0, 0x77, 0xc8, 0x89, 0x4f, 0xf0, 0xee, 0xfa, 0xaf, 0xbe, 0x90, 0x05, 0xc4, 0x3e,
    0x48, 0x82, 0x09, 0x17, 0xf1, 0x3d, 0x8b};

static const uint8_t kECCACertDER[] = {0x30, 0x82, 0x02, 0xfd, 0x30, 0x82, 0x02, 0x5e, 0xa0, 0x03,
    0x02, 0x01, 0x02, 0x02, 0x14, 0x47, 0x96, 0xf7, 0x19, 0x12, 0x8f, 0x46, 0x3b, 0xd1, 0x98, 0xe6,
    0xd6, 0xc4, 0x5a, 0x79, 0x3f, 0xe9, 0xde, 0x4e, 0x4b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48,
    0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x81, 0x8f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04,
    0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x0a,
    0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03,
    0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20, 0x57, 0x69,
    0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64, 0x31, 0x21, 0x30,
    0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
    0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e, 0x61, 0x6d, 0x65,
    0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x6e, 0x6f, 0x6e, 0x65, 0x78,
    0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65,
    0x6e, 0x74, 0x2e, 0x65, 0x63, 0x63, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30, 0x35, 0x30,
    0x38, 0x31, 0x32, 0x34, 0x37, 0x31, 0x31, 0x5a, 0x17, 0x0d, 0x33, 0x39, 0x30, 0x35, 0x30, 0x33,
    0x31, 0x32, 0x34, 0x37, 0x31, 0x31, 0x5a, 0x30, 0x81, 0x8f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03,
    0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08,
    0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x21, 0x30, 0x1f,
    0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20,
    0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64, 0x31,
    0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
    0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e, 0x61,
    0x6d, 0x65, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x6e, 0x6f, 0x6e,
    0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73,
    0x74, 0x65, 0x6e, 0x74, 0x2e, 0x65, 0x63, 0x63, 0x61, 0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81,
    0x86, 0x00, 0x04, 0x01, 0xf3, 0x42, 0x76, 0xea, 0xca, 0x37, 0x6b, 0x80, 0xb4, 0x26, 0x42, 0x9f,
    0x26, 0x0b, 0xfe, 0x8b, 0x94, 0x4a, 0x56, 0x48, 0x56, 0x78, 0xda, 0x65, 0x07, 0xa6, 0x92, 0x63,
    0xdc, 0x33, 0x9f, 0x2f, 0x67, 0xaa, 0xc7, 0xf2, 0x77, 0xba, 0x4a, 0x65, 0xe7, 0x6b, 0x5b, 0x79,
    0x8a, 0x92, 0xe2, 0xd1, 0x99, 0x8f, 0x6d, 0x08, 0x50, 0x9f, 0x2f, 0xe9, 0x39, 0xff, 0xee, 0xa1,
    0xf7, 0x3b, 0x4f, 0xb1, 0x96, 0x01, 0xbc, 0xda, 0xa9, 0x21, 0x1b, 0x15, 0xb1, 0x24, 0x59, 0x38,
    0x3a, 0xee, 0x46, 0x31, 0x51, 0xae, 0xd8, 0x63, 0x0f, 0x5a, 0xae, 0xa5, 0xfa, 0x12, 0x2e, 0xbb,
    0x71, 0x71, 0xe5, 0x85, 0xa3, 0x4b, 0x90, 0x47, 0xbb, 0xa9, 0xa5, 0x55, 0x10, 0xeb, 0xe7, 0xf5,
    0x34, 0xe7, 0x3a, 0xd7, 0xb2, 0xaa, 0xad, 0x86, 0x8d, 0x29, 0xb9, 0xe9, 0x3b, 0xc4, 0x6b, 0x2c,
    0x23, 0x3f, 0x08, 0x37, 0xac, 0xeb, 0x6b, 0xa3, 0x53, 0x30, 0x51, 0x30, 0x1d, 0x06, 0x03, 0x55,
    0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xcc, 0x8b, 0x62, 0xc3, 0x62, 0x94, 0x1e, 0x17, 0x51, 0x32,
    0xd5, 0x95, 0x2f, 0xaf, 0x20, 0x68, 0x9d, 0x67, 0xc2, 0xb0, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d,
    0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xcc, 0x8b, 0x62, 0xc3, 0x62, 0x94, 0x1e, 0x17, 0x51,
    0x32, 0xd5, 0x95, 0x2f, 0xaf, 0x20, 0x68, 0x9d, 0x67, 0xc2, 0xb0, 0x30, 0x0f, 0x06, 0x03, 0x55,
    0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0a, 0x06, 0x08,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x81, 0x8c, 0x00, 0x30, 0x81, 0x88, 0x02,
    0x42, 0x01, 0x91, 0xfa, 0xdc, 0xb9, 0x61, 0x21, 0x29, 0x01, 0xd0, 0xd0, 0x07, 0xa6, 0xed, 0x77,
    0xa6, 0x81, 0x27, 0x13, 0x4d, 0x74, 0x96, 0xbd, 0x0a, 0x97, 0xeb, 0xd0, 0x02, 0x77, 0x90, 0x80,
    0xdf, 0xc1, 0xd3, 0xd3, 0x3c, 0xe5, 0x30, 0x6d, 0xba, 0x5a, 0xcf, 0x22, 0x70, 0x13, 0xad, 0x44,
    0x46, 0xbb, 0x6c, 0xdf, 0x27, 0x8a, 0x00, 0xf9, 0xc6, 0xa4, 0x87, 0x71, 0xeb, 0x19, 0x93, 0x13,
    0x6d, 0xcb, 0x2d, 0x02, 0x42, 0x01, 0x22, 0x3a, 0x74, 0xe9, 0xee, 0x1b, 0x09, 0xe0, 0xc7, 0xd5,
    0x78, 0xf2, 0x0c, 0x45, 0x30, 0x23, 0x48, 0xcc, 0x6a, 0x5f, 0x63, 0x32, 0xb7, 0x34, 0xf2, 0xfb,
    0xf4, 0x68, 0x16, 0xbd, 0x2e, 0xea, 0x88, 0x11, 0x3b, 0xd0, 0x4e, 0xc3, 0x6a, 0x1a, 0xa4, 0x6d,
    0xb7, 0x63, 0x2f, 0x7b, 0x65, 0x24, 0xde, 0xbd, 0x1a, 0x00, 0xaf, 0x46, 0xa2, 0x7c, 0xbc, 0x08,
    0x38, 0xcd, 0x12, 0x8a, 0x63, 0x4d, 0x3b};

static const uint8_t kDSACertDER[] = {0x30, 0x82, 0x03, 0xdf, 0x30, 0x82, 0x03, 0x9c, 0xa0, 0x03,
    0x02, 0x01, 0x02, 0x02, 0x14, 0x60, 0xe4, 0x10, 0x21, 0xe4, 0xc9, 0xaa, 0xf4, 0x6f, 0x72, 0x62,
    0xd1, 0x9f, 0x6e, 0x11, 0xc9, 0xee, 0x65, 0xd4, 0x62, 0x30, 0x0b, 0x06, 0x09, 0x60, 0x86, 0x48,
    0x01, 0x65, 0x03, 0x04, 0x03, 0x02, 0x30, 0x81, 0x9f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55,
    0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c,
    0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x0f, 0x30, 0x0d, 0x06,
    0x03, 0x55, 0x04, 0x07, 0x0c, 0x06, 0x53, 0x69, 0x64, 0x6e, 0x65, 0x79, 0x31, 0x21, 0x30, 0x1f,
    0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20,
    0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74, 0x64, 0x31,
    0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
    0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20, 0x4e, 0x61,
    0x6d, 0x65, 0x31, 0x24, 0x30, 0x22, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1b, 0x6e, 0x6f, 0x6e,
    0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73,
    0x74, 0x65, 0x6e, 0x74, 0x2e, 0x64, 0x73, 0x61, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x39, 0x30, 0x35,
    0x30, 0x38, 0x31, 0x32, 0x34, 0x38, 0x33, 0x36, 0x5a, 0x17, 0x0d, 0x33, 0x39, 0x30, 0x35, 0x30,
    0x33, 0x31, 0x32, 0x34, 0x38, 0x33, 0x36, 0x5a, 0x30, 0x81, 0x9f, 0x31, 0x0b, 0x30, 0x09, 0x06,
    0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x41, 0x55, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
    0x08, 0x0c, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x2d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x31, 0x0f, 0x30,
    0x0d, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x06, 0x53, 0x69, 0x64, 0x6e, 0x65, 0x79, 0x31, 0x21,
    0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x18, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65,
    0x74, 0x20, 0x57, 0x69, 0x64, 0x67, 0x69, 0x74, 0x73, 0x20, 0x50, 0x74, 0x79, 0x20, 0x4c, 0x74,
    0x64, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x18, 0x4f, 0x72, 0x67, 0x61,
    0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x20,
    0x4e, 0x61, 0x6d, 0x65, 0x31, 0x24, 0x30, 0x22, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1b, 0x6e,
    0x6f, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x6e, 0x65, 0x78,
    0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x64, 0x73, 0x61, 0x30, 0x82, 0x01, 0xb7, 0x30, 0x82,
    0x01, 0x2c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x38, 0x04, 0x01, 0x30, 0x82, 0x01, 0x1f, 0x02,
    0x81, 0x81, 0x00, 0xb2, 0xf2, 0xb3, 0x0d, 0x25, 0x1c, 0x01, 0x78, 0x24, 0xaf, 0x21, 0x37, 0xe1,
    0x07, 0x1a, 0xd6, 0x3f, 0xc5, 0x5c, 0x94, 0x4e, 0xf9, 0x82, 0x11, 0x4a, 0x42, 0xf8, 0xbc, 0x86,
    0x21, 0xd7, 0xe1, 0xef, 0x21, 0x50, 0xad, 0x79, 0x26, 0xab, 0x38, 0xb6, 0xd9, 0x46, 0x0f, 0xef,
    0xa3, 0x74, 0x3f, 0x3b, 0x10, 0x55, 0x67, 0x81, 0xfc, 0xe5, 0x48, 0x94, 0x33, 0xdd, 0x2c, 0x0a,
    0x7e, 0x0b, 0x23, 0x07, 0x89, 0x96, 0x09, 0x8c, 0xcd, 0x22, 0xfc, 0xdc, 0x09, 0x6f, 0x62, 0xec,
    0x0f, 0x5a, 0x0e, 0x02, 0x1c, 0x74, 0x02, 0x04, 0xb9, 0x52, 0x0a, 0xae, 0x95, 0x85, 0xea, 0x2b,
    0xee, 0x99, 0xbd, 0x7c, 0xf4, 0x27, 0xb7, 0xaf, 0x86, 0x3e, 0x0c, 0x69, 0x55, 0x51, 0x8f, 0x05,
    0xcf, 0x4e, 0xde, 0xfd, 0xb0, 0x98, 0xbb, 0xdd, 0x55, 0xa4, 0x53, 0xc5, 0x98, 0x31, 0xde, 0x8d,
    0xa9, 0xcf, 0x4b, 0x02, 0x15, 0x00, 0x9a, 0x11, 0xba, 0xd8, 0x08, 0x2b, 0x64, 0x4f, 0x5b, 0xaf,
    0x2f, 0xb8, 0x8b, 0x43, 0x9e, 0x8f, 0xc1, 0x04, 0xa2, 0x4d, 0x02, 0x81, 0x81, 0x00, 0xa8, 0x8f,
    0xe1, 0xb3, 0xe3, 0xd5, 0x61, 0xa8, 0x57, 0xe0, 0x0c, 0x55, 0x95, 0xaf, 0x80, 0xf8, 0xe3, 0xf8,
    0x73, 0xfe, 0x30, 0x3d, 0xf0, 0x10, 0x10, 0xa9, 0x11, 0x94, 0xc8, 0x98, 0x44, 0x25, 0x79, 0xa5,
    0x1a, 0xe9, 0x57, 0xe3, 0x0d, 0x57, 0x3a, 0x49, 0xc1, 0x4c, 0x7f, 0x01, 0x21, 0x6c, 0x15, 0xd5,
    0xdb, 0x73, 0x41, 0xbc, 0x4b, 0xf2, 0x8e, 0xe0, 0x30, 0x55, 0xda, 0x86, 0xac, 0x23, 0x78, 0x7a,
    0x7a, 0xef, 0xb4, 0x84, 0xbf, 0x9f, 0x02, 0x77, 0xe6, 0x44, 0x54, 0xca, 0xac, 0x2a, 0x6b, 0xfd,
    0x58, 0xfa, 0xbe, 0xc2, 0xeb, 0x02, 0xf0, 0xce, 0x32, 0x2e, 0x1c, 0x5f, 0xca, 0xdd, 0xe9, 0xf6,
    0x67, 0xf7, 0x4f, 0xa4, 0xe5, 0x2b, 0x27, 0xec, 0xaa, 0x47, 0xfd, 0xfb, 0x63, 0x9c, 0x3f, 0xba,
    0xdc, 0xda, 0xd2, 0x18, 0xd6, 0x8d, 0x65, 0xf5, 0x8d, 0xc5, 0x97, 0x78, 0xcc, 0x6f, 0x03, 0x81,
    0x84, 0x00, 0x02, 0x81, 0x80, 0x70, 0x3d, 0xfa, 0x84, 0x2a, 0x3c, 0xad, 0x9c, 0xfa, 0x86, 0x39,
    0xaf, 0xa9, 0xdb, 0x4f, 0x94, 0x27, 0x12, 0xa7, 0x60, 0x5b, 0xa8, 0xe9, 0x30, 0x19, 0x5d, 0xf8,
    0x0d, 0x20, 0x90, 0x61, 0x9f, 0xd7, 0xf8, 0xa9, 0xbe, 0x5f, 0x2d, 0x31, 0x38, 0x5a, 0xb4, 0xaa,
    0x25, 0x6b, 0xb2, 0x37, 0x25, 0xdb, 0xc2, 0x50, 0xca, 0xaf, 0x44, 0xcb, 0x2e, 0x5f, 0x69, 0xc8,
    0x56, 0x16, 0x0e, 0x90, 0x20, 0x94, 0xc8, 0x43, 0x86, 0x5b, 0x52, 0x6c, 0xd4, 0x74, 0xd0, 0x76,
    0xec, 0xe4, 0x81, 0xcc, 0x21, 0x30, 0xf9, 0x75, 0x54, 0xd9, 0xf3, 0xd0, 0x83, 0x46, 0x63, 0x96,
    0xf9, 0x60, 0x1a, 0xa7, 0xeb, 0xe2, 0xe4, 0x7a, 0x89, 0x9d, 0xfa, 0x26, 0xc6, 0x22, 0xab, 0xee,
    0x29, 0x43, 0x4d, 0x32, 0x5c, 0x01, 0x09, 0x18, 0xf6, 0xe4, 0x9f, 0xfd, 0xeb, 0xb7, 0x16, 0x08,
    0xdd, 0x29, 0xbb, 0xce, 0x10, 0xa3, 0x53, 0x30, 0x51, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e,
    0x04, 0x16, 0x04, 0x14, 0x04, 0x11, 0x5e, 0x1f, 0xd4, 0x92, 0x92, 0xea, 0xe3, 0x1c, 0xc2, 0x03,
    0x6f, 0xc1, 0x80, 0x73, 0x2b, 0xa5, 0xa0, 0x3e, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0x04, 0x11, 0x5e, 0x1f, 0xd4, 0x92, 0x92, 0xea, 0xe3, 0x1c, 0xc2,
    0x03, 0x6f, 0xc1, 0x80, 0x73, 0x2b, 0xa5, 0xa0, 0x3e, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13,
    0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0b, 0x06, 0x09, 0x60, 0x86,
    0x48, 0x01, 0x65, 0x03, 0x04, 0x03, 0x02, 0x03, 0x30, 0x00, 0x30, 0x2d, 0x02, 0x14, 0x73, 0x18,
    0xf9, 0x68, 0x26, 0xdb, 0x0d, 0xd5, 0x49, 0x52, 0x14, 0x50, 0xb4, 0xcf, 0x3a, 0x1f, 0x0d, 0x49,
    0x8f, 0xe7, 0x02, 0x15, 0x00, 0x92, 0x6e, 0xb6, 0xce, 0x87, 0x1e, 0x7b, 0x68, 0xfc, 0x2e, 0xd3,
    0xa9, 0x3d, 0xe1, 0x55, 0x39, 0xc0, 0x66, 0xe0, 0x20};

static SSL_CTX* ctx = NULL;

unsigned int psk_callback(SSL* ssl, const char* hint, char* identuty, unsigned int max_identity_len,
    unsigned char* psk, unsigned int max_psk_len) {
    memset(psk, 'A', max_psk_len);
    return max_psk_len;
}

int LLVMFuzzerInitialize(int* argc, char*** argv) {
    HFInit();
    HFResetRand();

    ctx = SSL_CTX_new(SSLv23_method());
    const uint8_t* bufp = kRSAPrivateKeyDER;
    RSA* privkey = d2i_RSAPrivateKey(NULL, &bufp, sizeof(kRSAPrivateKeyDER));
    assert(privkey != NULL);
    EVP_PKEY* pkey = EVP_PKEY_new();
    EVP_PKEY_assign_RSA(pkey, privkey);
    int ret = SSL_CTX_use_PrivateKey(ctx, pkey);
    assert(ret == 1);
    EVP_PKEY_free(pkey);

    bufp = kRSACertificateDER;
    X509* cert = d2i_X509(NULL, &bufp, sizeof(kRSACertificateDER));
    assert(cert != NULL);
    ret = SSL_CTX_use_certificate(ctx, cert);
    assert(ret == 1);
    X509_free(cert);
#if defined(HF_SSL_IS_BORINGSSL)
    ret = SSL_CTX_set_cipher_list(ctx, "ALL");
#else
    ret = SSL_CTX_set_cipher_list(ctx, "ALL:COMPLEMENTOFALL");
#endif  // defined(HF_SSL_IS_BORINGSSL)
    assert(ret == 1);

    X509_STORE* store = X509_STORE_new();
    assert(store != NULL);

    bufp = kRSACACertDER;
    cert = d2i_X509(NULL, &bufp, sizeof(kRSACACertDER));
    assert(cert != NULL);
    ret = SSL_CTX_add_client_CA(ctx, cert);
    assert(ret == 1);
    ret = X509_STORE_add_cert(store, cert);
    assert(ret == 1);
    X509_free(cert);

    bufp = kECCACertDER;
    cert = d2i_X509(NULL, &bufp, sizeof(kECCACertDER));
    assert(cert != NULL);
    ret = SSL_CTX_add_client_CA(ctx, cert);
    assert(ret == 1);
    ret = X509_STORE_add_cert(store, cert);
    assert(ret == 1);
    X509_free(cert);

    bufp = kDSACertDER;
    cert = d2i_X509(NULL, &bufp, sizeof(kDSACertDER));
    assert(cert != NULL);
    ret = SSL_CTX_add_client_CA(ctx, cert);
    assert(ret == 1);
    ret = X509_STORE_add_cert(store, cert);
    assert(ret == 1);
    X509_free(cert);

    SSL_CTX_set_cert_store(ctx, store);
    SSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, NULL);
    SSL_CTX_set_verify_depth(ctx, 10);

#if defined(HF_SSL_IS_BORINGSSL)
    SSL_CTX_set_psk_client_callback(ctx, psk_callback);
    ret = SSL_CTX_use_psk_identity_hint(ctx, "ABCDEFUZZ");
    assert(ret == 1);

    SSL_CTX_set_early_data_enabled(ctx, 1);
#endif /* defined(HF_SSL_IS_BORINGSSL) */

    SSL_CTX_set_ecdh_auto(ctx, 1);
    SSL_CTX_set_min_proto_version(ctx, SSL3_VERSION);
    SSL_CTX_set_max_proto_version(ctx, TLS1_3_VERSION);
    SSL_CTX_set_session_cache_mode(ctx, SSL_SESS_CACHE_BOTH);
    SSL_CTX_set_timeout(ctx, 3);

#if defined(HF_SSL_IS_OPENSSL_GE_1_1)
    SSL_CTX_enable_ct(ctx, SSL_CT_VALIDATION_PERMISSIVE);
    SSL_CTX_set_max_early_data(ctx, 1024);
#endif /* defined(HF_SSL_IS_OPENSSL_GE_1_1) */
#if defined(HF_SSL_IS_OPENSSL_GE_1_1) || defined(HF_SSL_IS_LIBRESSL)
    SSL_CTX_set_dh_auto(ctx, 1);
#endif /* #if defined(HF_SSL_IS_OPENSSL_GE_1_1) || defined(HF_SSL_IS_LIBRESSL) */

    long opts = SSL_CTX_get_options(ctx);
    opts |= SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION;
    opts |= SSL_OP_LEGACY_SERVER_CONNECT;
    opts |= SSL_OP_ALL;
    SSL_CTX_set_options(ctx, opts);

    return 1;
}

__attribute__((weak)) void RAND_reset_for_fuzzing(void) {
}

int LLVMFuzzerTestOneInput(const uint8_t* buf, size_t len) {
    RAND_reset_for_fuzzing();

    SSL* client = SSL_new(ctx);
    SSL_set_tlsext_host_name(client, "localhost");

#if defined(HF_SSL_IS_BORINGSSL)
    SSL_set_renegotiate_mode(client, ssl_renegotiate_freely);
#endif /* defined(HF_SSL_IS_BORINGSSL) */

#if defined(HF_SSL_FROM_STDIN)
    BIO* in = BIO_new(BIO_s_fd());
    BIO_set_fd(in, 0, BIO_NOCLOSE);
#else  /* defined(HF_SSL_FROM_STDIN) */
    BIO* in = BIO_new(BIO_s_mem());
    BIO_write(in, buf, len);
#endif /* defined(HF_SSL_FROM_STDIN) */

    BIO* out = BIO_new(BIO_s_fd());
    BIO_set_fd(out, 1, BIO_NOCLOSE);

    SSL_set_bio(client, in, out);
    SSL_set_connect_state(client);

#if defined(HF_SSL_IS_OPENSSL_GE_1_1)
    for (;;) {
        size_t sz;
        uint8_t edata_rbuf[128];
        if (SSL_read_early_data(client, edata_rbuf, sizeof(edata_rbuf), &sz) !=
            SSL_READ_EARLY_DATA_SUCCESS) {
            break;
        }
    }
#endif  // defined(HF_SSL_IS_OPENSSL_GE_1_1)

    /* Try it two times to test SSL_clear() */
    for (unsigned i = 0; i < 2; i++) {
        if (SSL_connect(client) == 1) {
            uint8_t tmp[1024 * 1024];
#if defined(HF_SSL_IS_OPENSSL_GE_1_1)
            size_t readbytes = 0;
            SSL_read_early_data(client, tmp, sizeof(tmp), &readbytes);
#endif  //  defined(HF_SSL_IS_OPENSSL_GE_1_1)
            X509* peer;
            if ((peer = SSL_get_peer_certificate(client)) != NULL) {
                long res = SSL_get_verify_result(client);
                if (res != X509_V_OK) {
                    if (getenv("HFUZZ_SSL_ABORT_ON_VERIFY")) {
                        fprintf(stderr, "verify: %ld\n", res);
                        abort();
                    }
                }
                X509_free(peer);
            }
            // Keep reading application data until error or EOF.
            for (;;) {
                ssize_t r = SSL_read(client, tmp, sizeof(tmp));
                if (r <= 0) {
                    break;
                }
                if (SSL_write(client, tmp, r) <= 0) {
                    break;
                }
                SSL_set_mtu(client, 8);
            }
        } else {
            ERR_print_errors_fp(stderr);
            break;
        }

        if (SSL_shutdown(client) != 1) {
            break;
        }
        if (SSL_clear(client) != 1) {
            break;
        }
    }
    SSL_free(client);

    return 0;
}

#ifdef __cplusplus
}
#endif
