# Contributing

When contributing to this repository, please simply open a new [PULL REQUEST](https://github.com/jkriege2/JKQtPlotter/pulls). 
If you want to simply report a bug for which you don't have a solution, please simply open a new [ISSUE](https://github.com/jkriege2/JKQtPlotter/issues).

Please note we have a code of conduct, please follow it in all your interactions with the project.

# Pull Request Process
Please ensure that your PR follows these guidelines:
- Please describe your changes with enough detail to easily understand them. As a plotting library is a profoundly visual thing, please add screenshots to illustrate your changes.
- Reference [ISSUE](https://github.com/jkriege2/JKQtPlotter/issues)s connnected to your PR
- ensure your code changes do compile at least for the most recent supported Qt version (currently Qt 5.15.x, in future also Qt 6). Please look at the results of the CI-builds and code-analysis and fix errors that are noted there.
- ensure that you fix all conflicts, before the PR can be merged
- ideally, please ensure that no new compiler warnings are generated
- ensure that you are happy to comply with the [librariy's license](https://github.com/jkriege2/JKQtPlotter/blob/master/LICENSE)

# Our Standards
Examples of behavior that contributes to creating a positive environment include:
- Using welcoming and inclusive language
- Being respectful of differing viewpoints and experiences
- Gracefully accepting constructive criticism
- Focusing on what is best for the community
- Showing empathy towards other community members

Examples of unacceptable behavior by participants include:
- The use of sexualized language or imagery and unwelcome sexual attention or advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information, such as a physical or electronic address, without explicit permission
- Other conduct which could reasonably be considered inappropriate in a professional setting

# Our Responsibilities
Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

# Scope
This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

# Enforcement
Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at jan@jkrieger.de. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

