/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.objectweb.asm.commons.Remapper;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.Rule;
import org.pantsbuild.jarjar.Wildcard;

class PackageRemapper
extends Remapper {
    private static final String RESOURCE_SUFFIX = "RESOURCE";
    private static final Pattern ARRAY_FOR_NAME_PATTERN = Pattern.compile("\\[L[\\p{javaJavaIdentifierPart}\\.]+?;");
    private final List<Wildcard> wildcards;
    private final Map<String, String> typeCache = new HashMap<String, String>();
    private final Map<String, String> pathCache = new HashMap<String, String>();
    private final Map<Object, String> valueCache = new HashMap<Object, String>();
    private final boolean verbose;

    public PackageRemapper(List<Rule> ruleList, boolean verbose) {
        this.verbose = verbose;
        this.wildcards = PatternElement.createWildcards(ruleList);
    }

    static boolean isArrayForName(String value) {
        return ARRAY_FOR_NAME_PATTERN.matcher(value).matches();
    }

    public String map(String key) {
        String s = this.typeCache.get(key);
        if (s == null) {
            s = this.replaceHelper(key);
            if (key.equals(s)) {
                s = null;
            }
            this.typeCache.put(key, s);
        }
        return s;
    }

    public String mapPath(String path) {
        String s = this.pathCache.get(path);
        if (s == null) {
            String end;
            s = path;
            int slash = s.lastIndexOf(47);
            if (slash < 0) {
                end = s;
                s = RESOURCE_SUFFIX;
            } else {
                end = s.substring(slash + 1);
                s = s.substring(0, slash + 1) + RESOURCE_SUFFIX;
            }
            boolean absolute = s.startsWith("/");
            if (absolute) {
                s = s.substring(1);
            }
            s = this.replaceHelper(s);
            if (absolute) {
                s = "/" + s;
            }
            if (s.indexOf(RESOURCE_SUFFIX) < 0) {
                return path;
            }
            s = s.substring(0, s.length() - RESOURCE_SUFFIX.length()) + end;
            this.pathCache.put(path, s);
        }
        return s;
    }

    public Object mapValue(Object value) {
        if (value instanceof String) {
            String s = this.valueCache.get(value);
            if (s == null) {
                s = (String)value;
                if (PackageRemapper.isArrayForName(s)) {
                    String desc1 = s.replace('.', '/');
                    String desc2 = this.mapDesc(desc1);
                    if (!desc2.equals(desc1)) {
                        return desc2.replace('/', '.');
                    }
                } else if ((s = this.mapPath(s)).equals(value)) {
                    boolean hasSlash;
                    boolean hasDot = s.indexOf(46) >= 0;
                    boolean bl = hasSlash = s.indexOf(47) >= 0;
                    if (!hasDot || !hasSlash) {
                        s = hasDot ? this.replaceHelper(s.replace('.', '/')).replace('/', '.') : this.replaceHelper(s);
                    }
                }
                this.valueCache.put(value, s);
            }
            if (this.verbose && !s.equals(value)) {
                System.err.println("Changed \"" + value + "\" -> \"" + s + "\"");
            }
            return s;
        }
        return super.mapValue(value);
    }

    private String replaceHelper(String value) {
        for (Wildcard wildcard : this.wildcards) {
            String test = wildcard.replace(value);
            if (test == null) continue;
            return test;
        }
        return value;
    }
}

