/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.git;

import com.typesafe.sbt.git.ConsoleGitRunner;
import com.typesafe.sbt.git.GitRunner;
import com.typesafe.sbt.git.GitRunner$class;
import java.io.File;
import sbt.ConsoleLogger$;
import sbt.IO$;
import sbt.Logger;
import sbt.Process$;
import sbt.ProcessLogger;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;

public final class ConsoleGitRunner$
implements GitRunner {
    public static final ConsoleGitRunner$ MODULE$;
    private Seq<String> cmd;
    private final Seq<Tuple2<String, String>> colorSupport;
    private volatile boolean bitmap$0;

    static {
        new ConsoleGitRunner$();
    }

    private Seq cmd$lzycompute() {
        ConsoleGitRunner$ consoleGitRunner$ = this;
        synchronized (consoleGitRunner$) {
            if (!this.bitmap$0) {
                this.cmd = this.isWindowsShell() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cmd", "/c", "git"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"git"}));
                this.bitmap$0 = true;
            }
            return this.cmd;
        }
    }

    @Override
    public void commitAndPush(String msg, Option<String> tag, File repo, Logger log) {
        GitRunner$class.commitAndPush(this, msg, tag, repo, log);
    }

    @Override
    public String push(File cwd, Logger log) {
        return GitRunner$class.push(this, cwd, log);
    }

    @Override
    public String pull(File cwd, Logger log) {
        return GitRunner$class.pull(this, cwd, log);
    }

    @Override
    public void updated(String remote, Option<String> branch, File cwd, Logger log) {
        GitRunner$class.updated(this, remote, branch, cwd, log);
    }

    @Override
    public Option<String> commitAndPush$default$2() {
        return GitRunner$class.commitAndPush$default$2(this);
    }

    public boolean isWindowsShell() {
        String ostype = System.getenv("OSTYPE");
        boolean isCygwin = ostype != null && ostype.toLowerCase().contains("cygwin");
        boolean isWindows = System.getProperty("os.name", "").toLowerCase().contains("windows");
        return isWindows && !isCygwin;
    }

    private Seq<String> cmd() {
        return this.bitmap$0 ? this.cmd : this.cmd$lzycompute();
    }

    public Seq<Tuple2<String, String>> colorSupport() {
        return this.colorSupport;
    }

    @Override
    public String apply(Seq<String> args, File cwd, Logger log) {
        ConsoleGitRunner.GitLogger gitLogger = new ConsoleGitRunner.GitLogger(log);
        IO$.MODULE$.createDirectory(cwd);
        Seq full = (Seq)this.cmd().$plus$plus(args, Seq$.MODULE$.canBuildFrom());
        log.debug((Function0)new Serializable(cwd, full){
            public static final long serialVersionUID = 0L;
            private final File cwd$1;
            private final Seq full$1;

            public final String apply() {
                return new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.cwd$1), "$ ")).append((Object)this.full$1.mkString(" ")).toString();
            }
            {
                this.cwd$1 = cwd$1;
                this.full$1 = full$1;
            }
        });
        int code = Process$.MODULE$.apply(full, cwd, this.colorSupport()).$bang((ProcessLogger)gitLogger);
        String result = gitLogger.flush(code);
        if (code != 0) {
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Nonzero exit code (").append((Object)BoxesRunTime.boxToInteger((int)code)).append((Object)") running git.").toString());
        }
        return result;
    }

    public Logger apply$default$3(Seq<String> args) {
        return ConsoleLogger$.MODULE$.apply(ConsoleLogger$.MODULE$.apply$default$1(), ConsoleLogger$.MODULE$.apply$default$2(), ConsoleLogger$.MODULE$.apply$default$3(), ConsoleLogger$.MODULE$.apply$default$4());
    }

    public String toString() {
        return "git";
    }

    private ConsoleGitRunner$() {
        MODULE$ = this;
        GitRunner$class.$init$(this);
        this.colorSupport = ConsoleLogger$.MODULE$.formatEnabled() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"GIT_PAGER_IN_USE"), (Object)"1")})) : (Seq)Seq$.MODULE$.empty();
    }
}

