/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.AbstractFetchCommand;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_UpdateRemoteRepositoryFromLocalRefs")
class Push
extends TextBuiltin {
    @Option(name="--timeout", metaVar="metaVar_seconds", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Argument(index=0, metaVar="metaVar_uriish")
    private String remote = "origin";
    @Argument(index=1, metaVar="metaVar_refspec")
    private final List<RefSpec> refSpecs = new ArrayList<RefSpec>();
    @Option(name="--all")
    private boolean all;
    @Option(name="--tags")
    private boolean tags;
    @Option(name="--verbose", aliases={"-v"})
    private boolean verbose = false;
    @Option(name="--thin")
    private boolean thin = false;
    @Option(name="--force", aliases={"-f"})
    private boolean force;
    @Option(name="--receive-pack", metaVar="metaVar_path")
    private String receivePack;
    @Option(name="--dry-run")
    private boolean dryRun;
    private boolean shownURI;

    Push() {
    }

    @Option(name="--no-thin")
    void nothin(boolean ignored) {
        this.thin = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws Exception {
        Git git = new Git(this.db);
        PushCommand push = git.push();
        push.setDryRun(this.dryRun);
        push.setForce(this.force);
        push.setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)this.errw));
        push.setReceivePack(this.receivePack);
        push.setRefSpecs(this.refSpecs);
        if (this.all) {
            push.setPushAll();
        }
        if (this.tags) {
            push.setPushTags();
        }
        push.setRemote(this.remote);
        push.setThin(this.thin);
        push.setTimeout(this.timeout);
        Iterable results = push.call();
        for (PushResult result : results) {
            ObjectReader reader = this.db.newObjectReader();
            try {
                this.printPushResult(reader, result.getURI(), result);
            }
            finally {
                reader.release();
            }
        }
    }

    private void printPushResult(ObjectReader reader, URIish uri, PushResult result) throws IOException {
        this.shownURI = false;
        boolean everythingUpToDate = true;
        for (RemoteRefUpdate rru : result.getRemoteUpdates()) {
            if (rru.getStatus() == RemoteRefUpdate.Status.UP_TO_DATE) {
                if (!this.verbose) continue;
                this.printRefUpdateResult(reader, uri, result, rru);
                continue;
            }
            everythingUpToDate = false;
        }
        for (RemoteRefUpdate rru : result.getRemoteUpdates()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.OK) continue;
            this.printRefUpdateResult(reader, uri, result, rru);
        }
        for (RemoteRefUpdate rru : result.getRemoteUpdates()) {
            if (rru.getStatus() == RemoteRefUpdate.Status.OK || rru.getStatus() == RemoteRefUpdate.Status.UP_TO_DATE) continue;
            this.printRefUpdateResult(reader, uri, result, rru);
        }
        AbstractFetchCommand.showRemoteMessages(this.errw, result.getMessages());
        if (everythingUpToDate) {
            this.outw.println(CLIText.get().everythingUpToDate);
        }
    }

    private void printRefUpdateResult(ObjectReader reader, URIish uri, PushResult result, RemoteRefUpdate rru) throws IOException {
        if (!this.shownURI) {
            this.shownURI = true;
            this.outw.println(MessageFormat.format(CLIText.get().pushTo, uri));
        }
        String remoteName = rru.getRemoteName();
        String srcRef = rru.isDelete() ? null : rru.getSrcRef();
        switch (rru.getStatus()) {
            case OK: {
                if (rru.isDelete()) {
                    this.printUpdateLine('-', "[deleted]", null, remoteName, null);
                    break;
                }
                Ref oldRef = result.getAdvertisedRef(remoteName);
                if (oldRef == null) {
                    String summary = remoteName.startsWith("refs/tags/") ? "[new tag]" : "[new branch]";
                    this.printUpdateLine('*', summary, srcRef, remoteName, null);
                    break;
                }
                boolean fastForward = rru.isFastForward();
                char flag = fastForward ? (char)' ' : '+';
                String summary = Push.safeAbbreviate(reader, oldRef.getObjectId()) + (fastForward ? ".." : "...") + Push.safeAbbreviate(reader, rru.getNewObjectId());
                String message = fastForward ? null : CLIText.get().forcedUpdate;
                this.printUpdateLine(flag, summary, srcRef, remoteName, message);
                break;
            }
            case NON_EXISTING: {
                this.printUpdateLine('X', "[no match]", null, remoteName, null);
                break;
            }
            case REJECTED_NODELETE: {
                this.printUpdateLine('!', "[rejected]", null, remoteName, CLIText.get().remoteSideDoesNotSupportDeletingRefs);
                break;
            }
            case REJECTED_NONFASTFORWARD: {
                this.printUpdateLine('!', "[rejected]", srcRef, remoteName, CLIText.get().nonFastForward);
                break;
            }
            case REJECTED_REMOTE_CHANGED: {
                String message = MessageFormat.format(CLIText.get().remoteRefObjectChangedIsNotExpectedOne, Push.safeAbbreviate(reader, rru.getExpectedOldObjectId()));
                this.printUpdateLine('!', "[rejected]", srcRef, remoteName, message);
                break;
            }
            case REJECTED_OTHER_REASON: {
                this.printUpdateLine('!', "[remote rejected]", srcRef, remoteName, rru.getMessage());
                break;
            }
            case UP_TO_DATE: {
                if (!this.verbose) break;
                this.printUpdateLine('=', "[up to date]", srcRef, remoteName, null);
                break;
            }
            case NOT_ATTEMPTED: 
            case AWAITING_REPORT: {
                this.printUpdateLine('?', "[unexpected push-process behavior]", srcRef, remoteName, rru.getMessage());
            }
        }
    }

    private static String safeAbbreviate(ObjectReader reader, ObjectId id) {
        try {
            return reader.abbreviate((AnyObjectId)id).name();
        }
        catch (IOException cannotAbbreviate) {
            return id.name();
        }
    }

    private void printUpdateLine(char flag, String summary, String srcRef, String destRef, String message) throws IOException {
        this.outw.format(" %c %-17s", new Object[]{Character.valueOf(flag), summary});
        if (srcRef != null) {
            this.outw.format(" %s ->", new Object[]{this.abbreviateRef(srcRef, true)});
        }
        this.outw.format(" %s", new Object[]{this.abbreviateRef(destRef, true)});
        if (message != null) {
            this.outw.format(" (%s)", new Object[]{message});
        }
        this.outw.println();
    }
}

