/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.util.AllowAllHostnameVerifier;
import com.ning.http.util.MiscUtil;
import javax.net.ssl.HostnameVerifier;

public final class AsyncHttpClientConfigDefaults {
    public static final String ASYNC_CLIENT = AsyncHttpClientConfig.class.getName() + ".";

    private AsyncHttpClientConfigDefaults() {
    }

    public static int defaultMaxTotalConnections() {
        return Integer.getInteger(ASYNC_CLIENT + "maxTotalConnections", -1);
    }

    public static int defaultMaxConnectionPerHost() {
        return Integer.getInteger(ASYNC_CLIENT + "maxConnectionsPerHost", -1);
    }

    public static int defaultConnectionTimeOutInMs() {
        return Integer.getInteger(ASYNC_CLIENT + "connectionTimeoutInMs", 60000);
    }

    public static int defaultIdleConnectionInPoolTimeoutInMs() {
        return Integer.getInteger(ASYNC_CLIENT + "idleConnectionInPoolTimeoutInMs", 60000);
    }

    public static int defaultIdleConnectionTimeoutInMs() {
        return Integer.getInteger(ASYNC_CLIENT + "idleConnectionTimeoutInMs", 60000);
    }

    public static int defaultRequestTimeoutInMs() {
        return Integer.getInteger(ASYNC_CLIENT + "requestTimeoutInMs", 60000);
    }

    public static int defaultWebSocketIdleTimeoutInMs() {
        return Integer.getInteger(ASYNC_CLIENT + "webSocketTimoutInMS", 900000);
    }

    public static int defaultMaxConnectionLifeTimeInMs() {
        return Integer.getInteger(ASYNC_CLIENT + "maxConnectionLifeTimeInMs", -1);
    }

    public static boolean defaultRedirectEnabled() {
        return Boolean.getBoolean(ASYNC_CLIENT + "redirectsEnabled");
    }

    public static int defaultMaxRedirects() {
        return Integer.getInteger(ASYNC_CLIENT + "maxRedirects", 5);
    }

    public static boolean defaultCompressionEnabled() {
        return Boolean.getBoolean(ASYNC_CLIENT + "compressionEnabled");
    }

    public static String defaultUserAgent() {
        return System.getProperty(ASYNC_CLIENT + "userAgent", "NING/1.0");
    }

    public static int defaultIoThreadMultiplier() {
        return Integer.getInteger(ASYNC_CLIENT + "ioThreadMultiplier", 2);
    }

    public static boolean defaultUseProxySelector() {
        return Boolean.getBoolean(ASYNC_CLIENT + "useProxySelector");
    }

    public static boolean defaultUseProxyProperties() {
        return Boolean.getBoolean(ASYNC_CLIENT + "useProxyProperties");
    }

    public static boolean defaultStrict302Handling() {
        return Boolean.getBoolean(ASYNC_CLIENT + "strict302Handling");
    }

    public static boolean defaultAllowPoolingConnection() {
        return MiscUtil.getBoolean(ASYNC_CLIENT + "allowPoolingConnection", true);
    }

    public static boolean defaultUseRelativeURIsWithSSLProxies() {
        return MiscUtil.getBoolean(ASYNC_CLIENT + "useRelativeURIsWithSSLProxies", true);
    }

    public static int defaultRequestCompressionLevel() {
        return Integer.getInteger(ASYNC_CLIENT + "requestCompressionLevel", -1);
    }

    public static int defaultMaxRequestRetry() {
        return Integer.getInteger(ASYNC_CLIENT + "maxRequestRetry", 5);
    }

    public static boolean defaultAllowSslConnectionPool() {
        return MiscUtil.getBoolean(ASYNC_CLIENT + "allowSslConnectionPool", true);
    }

    public static boolean defaultUseRawUrl() {
        return Boolean.getBoolean(ASYNC_CLIENT + "useRawUrl");
    }

    public static boolean defaultRemoveQueryParamOnRedirect() {
        return MiscUtil.getBoolean(ASYNC_CLIENT + "removeQueryParamOnRedirect", true);
    }

    public static HostnameVerifier defaultHostnameVerifier() {
        return new AllowAllHostnameVerifier();
    }
}

