/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.ClassAttributes;
import classycle.PackageVertex;
import classycle.graph.AtomicVertex;
import classycle.graph.GraphProcessor;
import classycle.graph.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PackageProcessor
extends GraphProcessor {
    private final HashMap _packageVertices = new HashMap();
    private final List _arcs = new ArrayList();
    private AtomicVertex[] _packageGraph;

    public AtomicVertex[] getGraph() {
        return this._packageGraph;
    }

    protected void initializeProcessing(Vertex[] graph) {
        this._packageVertices.clear();
    }

    protected void processBefore(Vertex vertex) {
    }

    protected void processArc(Vertex tail, Vertex head) {
        PackageVertex tailPackage = this.getPackageVertex(tail);
        PackageVertex headPackage = this.getPackageVertex(head);
        boolean internalHeadClass = ((AtomicVertex)head).isGraphVertex();
        this._arcs.add(new Arc(tailPackage, headPackage, internalHeadClass));
    }

    private PackageVertex getPackageVertex(Vertex vertex) {
        ClassAttributes classAttributes = (ClassAttributes)vertex.getAttributes();
        String className = classAttributes.getName();
        int index = className.lastIndexOf(46);
        String packageName = index < 0 ? "(default package)" : className.substring(0, index);
        PackageVertex result = (PackageVertex)this._packageVertices.get(packageName);
        if (result == null) {
            result = new PackageVertex(packageName);
            this._packageVertices.put(packageName, result);
        }
        if (this.isVertexFromGraph(vertex)) {
            result.reset();
        }
        result.addClass(classAttributes);
        return result;
    }

    private boolean isVertexFromGraph(Vertex vertex) {
        return vertex instanceof AtomicVertex && ((AtomicVertex)vertex).isGraphVertex();
    }

    protected void processAfter(Vertex vertex) {
    }

    protected void finishProcessing(Vertex[] graph) {
        for (int i = 0; i < this._arcs.size(); ++i) {
            ((Arc)this._arcs.get(i)).create();
        }
        Iterator vertices = this._packageVertices.values().iterator();
        ArrayList<AtomicVertex> list = new ArrayList<AtomicVertex>();
        while (vertices.hasNext()) {
            AtomicVertex vertex = (AtomicVertex)vertices.next();
            if (!vertex.isGraphVertex()) continue;
            list.add(vertex);
        }
        this._packageGraph = list.toArray(new AtomicVertex[list.size()]);
    }

    private static final class Arc {
        final AtomicVertex tail;
        final AtomicVertex head;
        final boolean internalHeadClass;

        Arc(AtomicVertex tail, AtomicVertex head, boolean internalHeadClass) {
            this.tail = tail;
            this.head = head;
            this.internalHeadClass = internalHeadClass;
        }

        void create() {
            if (this.internalHeadClass || !this.head.isGraphVertex()) {
                this.tail.addOutgoingArcTo(this.head);
            }
        }
    }
}

