# $Id: bindings.tcl,v 2.3 2002/05/30 17:13:10 jfontain Exp $

# provide a reliable non-intrusive binding mechanism: a new tag is created, inserted in the existing tags at a specified position
# and when deleted, all existing bndings for this tag are safely and completely removed

class bindings {
    proc bindings {this widget index} {
        ::set ($this,widget) $widget
        bindtags $widget [linsert [bindtags $widget] $index bindings($this)]
    }
    proc ~bindings {this} {
        if {![winfo exists $($this,widget)]} return
        ::set tags [bindtags $($this,widget)]
        ::set index [lsearch -exact $tags bindings($this)]
        bindtags $($this,widget) [lreplace $tags $index $index]
        foreach tag [bind bindings($this)] {
            bind bindings($this) $tag {}
        }
    }
    proc set {this tag sequence} {                                                         ;# for exact behavior, see Tk bind manual
        bind bindings($this) $tag $sequence
    }
}
