/*
 * Decompiled with CFR 0.152.
 */
package net.davidashen.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import net.davidashen.util.Applicator;

public class List
implements Cloneable {
    private Link head;
    private Link tail;
    private int length;

    public List() {
        this.clear();
    }

    public final List clear() {
        this.head = new Link();
        this.head.next = null;
        this.tail = new Link();
        this.tail.next = this.head;
        this.length = 0;
        return this;
    }

    protected List newList() {
        try {
            return ((List)super.clone()).clear();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object clone() {
        List l = this.newList();
        if (this.isPair()) {
            Link link = this.head.next;
            while (true) {
                l.snoc(link.data);
                if (link == this.tail.next) break;
                link = link.next;
            }
        }
        return l;
    }

    public final List enolc() {
        List l = this.newList();
        if (this.isPair()) {
            Link link = this.head.next;
            while (true) {
                l.cons(link.data);
                if (link == this.tail.next) break;
                link = link.next;
            }
        }
        return l;
    }

    public final List reverse() {
        return this.length > 1 ? this.enolc() : this;
    }

    public final List unshift(Object o) {
        return this.cons(o);
    }

    public final List cons(Object o) {
        Link link = new Link();
        this.head.data = o;
        link.next = this.head;
        this.head = link;
        ++this.length;
        return this;
    }

    public final List prepend(List l) {
        if (l.isPair()) {
            l.tail.next.next = this.head.next;
            this.head.next = l.head.next;
            this.length += l.length;
        }
        return this;
    }

    public final List append(Object o) {
        return this.snoc(o);
    }

    public final List snoc(Object o) {
        Link link = new Link();
        link.data = o;
        link.next = this.tail.next.next;
        this.tail.next.next = link;
        this.tail.next = link;
        ++this.length;
        return this;
    }

    public final List append(List l) {
        if (l.isPair()) {
            this.tail.next.next = l.head.next;
            this.tail.next = l.tail.next;
            this.length += l.length;
        }
        return this;
    }

    public final Object shift() {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.head = this.head.next;
        --this.length;
        return this.head.data;
    }

    public final boolean isEmpty() {
        return !this.isPair();
    }

    public final boolean isPair() {
        return this.head.next != this.tail.next.next;
    }

    public final int length() {
        return this.length;
    }

    public final Object car() {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        return this.head.next.data;
    }

    public final Object last() {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        return this.tail.next.data;
    }

    public final List cdr() {
        List l = this.newList();
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        l.head.next = this.head.next.next;
        l.tail = this.tail;
        l.length = this.length - 1;
        return l;
    }

    public final List cDr() {
        List l = this.newList();
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        l.head.next = this.tail.next;
        l.tail = this.tail;
        l.length = this.length - 1;
        return l;
    }

    public final List setCar(Object o) {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.head.next.data = o;
        return this;
    }

    public final List setLast(Object o) {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.tail.next.data = o;
        return this;
    }

    public final List setCdr(List l) {
        if (!this.isPair()) {
            throw new NoSuchElementException("list is not a pair");
        }
        this.head.next.next = l.head.next;
        this.length = l.length + 1;
        return this;
    }

    public final void foreach(Applicator a) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            a.f(e.nextElement());
        }
    }

    public final List map(List t, Applicator a) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            t.append(a.f(e.nextElement()));
        }
        return t;
    }

    public final Mark mark() {
        return new Mark();
    }

    public final List insert(Mark mark, Object o) {
        Link link = new Link();
        link.next = mark.link.next;
        link.data = o;
        mark.link.next = link;
        if (this.tail.next == mark.link) {
            this.tail.next = link;
        }
        ++this.length;
        return this;
    }

    public final List cut(Mark mark) {
        this.tail.next = mark.link;
        this.length = mark.length;
        return this;
    }

    public final List hcut(Mark mark) {
        this.tail.next = mark.link;
        this.length = 0;
        Link cur = this.head.next;
        while (cur != this.tail.next.next) {
            ++this.length;
            cur = cur.next;
        }
        return this;
    }

    public final List insert(Link mark, List l) {
        Link next;
        l.tail.next.next = next = mark.next;
        mark.next = l.head.next;
        if (this.tail.next == mark) {
            this.tail.next = l.tail.next;
        }
        this.length += l.length;
        return this;
    }

    public String toString() {
        return this.isPair() ? this.cdr().addToString(this.car().toString()) : "()";
    }

    private String addToString(String s) {
        if (this.isPair()) {
            return this.cdr().addToString(s + " " + this.car());
        }
        return "(" + s + ")";
    }

    public final Enumeration elements() {
        return new Enumerator();
    }

    private class Enumerator
    implements Enumeration {
        private Link cur;

        Enumerator() {
            this.cur = ((List)List.this).head.next;
        }

        public final Object nextElement() {
            if (this.cur == ((List)List.this).tail.next.next) {
                throw new NoSuchElementException("attempt to access element past the end of a list");
            }
            Object o = this.cur.data;
            this.cur = this.cur.next;
            return o;
        }

        public final boolean hasMoreElements() {
            return this.cur != ((List)List.this).tail.next.next;
        }
    }

    public final class Mark {
        Link link;
        int length;

        Mark() {
            this.link = ((List)List.this).tail.next;
            this.length = List.this.length;
        }
    }

    static final class Link {
        Object data;
        Link next;

        Link() {
        }
    }
}

