/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgramInfoHelper;
import util.i18n.Localizer;

public class InfoBitFilter
implements ProgramFilter {
    public static final String SUBTITLE_FILTER_KEY = "[SUBTITLE_FILTER]";
    public static final String AUDIO_DESCRIPTION_FILTER_KEY = "[AUDIO_DESCRIPTION_FILTER]";
    public static final String HD_FILTER_KEY = "[HD_FILTER]";
    public static final String NEW_FILTER_KEY = "[NEW_FILTER]";
    public static final String LIVE_FILTER_KEY = "[LIVE_FILTER]";
    public static final String ORIGINAL_AUDIO_FILTER_KEY = "[ORIGINAL_AUDIO_FILTER]";
    public static final String ARTS_FILTER_KEY = "[ARTS_FILTER]";
    public static final String CHILDRENS_FILTER_KEY = "[CHILDRENS_FILTER]";
    public static final String DOCUMENTARY_FILTER_KEY = "[DOCUMENTARY_FILTER]";
    public static final String MAGAZINE_FILTER_KEY = "[MAGAZINE_FILTER]";
    public static final String MOVIE_FILTER_KEY = "[MOVIE_FILTER]";
    public static final String NEWS_FILTER_KEY = "[NEWS_FILTER]";
    public static final String OTHERS_FILTER_KEY = "[OTHERS_FILTER]";
    public static final String SERIES_FILTER_KEY = "[SERIES_FILTER]";
    public static final String SHOW_FILTER_KEY = "[SHOW_FILTER]";
    public static final String SPORTS_FILTER_KEY = "[SPORTS_FILTER]";
    public static final String UNCATEGORIZED_FILTER_KEY = "[UNCATEGORIZED_FILTER]";
    private int[] mInfoBits;
    private String mName;
    private String mKey;
    private String mLocalized;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(InfoBitFilter.class);

    public InfoBitFilter(String name) {
        Localizer catLocalizer = Localizer.getLocalizerFor(ProgramInfoHelper.class);
        if (name.equals(SUBTITLE_FILTER_KEY)) {
            this.mName = "Subtitled";
            this.mKey = name;
            this.mInfoBits = new int[]{512, 2048, 0x2000000};
        } else if (name.equals(AUDIO_DESCRIPTION_FILTER_KEY)) {
            this.mName = "Audiodescription";
            this.mKey = name;
            this.mInfoBits = new int[]{32768};
        } else if (name.equals(HD_FILTER_KEY)) {
            this.mName = "HD";
            this.mKey = name;
            this.mInfoBits = new int[]{524288};
        } else if (name.equals(NEW_FILTER_KEY)) {
            this.mName = "New";
            this.mKey = name;
            this.mInfoBits = new int[]{16384};
        } else if (name.equals(LIVE_FILTER_KEY)) {
            this.mName = "Live";
            this.mKey = name;
            this.mInfoBits = new int[]{1024};
        } else if (name.equals(ORIGINAL_AUDIO_FILTER_KEY)) {
            this.mName = "OriginalAudio";
            this.mKey = name;
            this.mInfoBits = new int[]{2048, 256};
        } else if (name.equals(ARTS_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_arts", "Theater/Concert");
            this.mKey = name;
            this.mInfoBits = new int[]{0x200000};
        } else if (name.equals(CHILDRENS_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_childrens", "Children's Programming");
            this.mKey = name;
            this.mInfoBits = new int[]{0x800000};
        } else if (name.equals(DOCUMENTARY_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_documentary", "Documentary/Reportage");
            this.mKey = name;
            this.mInfoBits = new int[]{0x100000};
        } else if (name.equals(MAGAZINE_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_magazine_infotainment", "Magazine/Infotainment");
            this.mKey = name;
            this.mInfoBits = new int[]{262144};
        } else if (name.equals(MOVIE_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_movie", "Movie");
            this.mKey = name;
            this.mInfoBits = new int[]{4096};
        } else if (name.equals(NEWS_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_news", "News");
            this.mKey = name;
            this.mInfoBits = new int[]{65536};
        } else if (name.equals(OTHERS_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_others", "Other Program");
            this.mKey = name;
            this.mInfoBits = new int[]{0x1000000};
        } else if (name.equals(SERIES_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_series", "Series");
            this.mKey = name;
            this.mInfoBits = new int[]{8192};
        } else if (name.equals(SHOW_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_show", "Show/Entertainment");
            this.mKey = name;
            this.mInfoBits = new int[]{131072};
        } else if (name.equals(SPORTS_FILTER_KEY)) {
            this.mLocalized = catLocalizer.msg("categorie_sports", "Sports");
            this.mKey = name;
            this.mInfoBits = new int[]{0x400000};
        } else if (name.equals(UNCATEGORIZED_FILTER_KEY)) {
            this.mName = "Uncategorized";
            this.mKey = name;
            this.mInfoBits = new int[]{0, -2097152, -8388608, -1048576, -262144, -4096, -65536, -16777216, -8192, -131072, -4194304};
        } else {
            throw new IllegalArgumentException("Unknown filter: " + name);
        }
    }

    public InfoBitFilter(String name, String key, int infoBit) {
        this(name, key, new int[]{infoBit});
    }

    public InfoBitFilter(String name, String key, int[] infoBits) {
        this.mName = name;
        this.mKey = key;
        this.mInfoBits = infoBits;
    }

    @Override
    public boolean accept(Program prog) {
        int info = prog.getInfo();
        if (info < 0) {
            info = 0;
        }
        boolean accept = false;
        for (int bit : this.mInfoBits) {
            if (bit >= 0) {
                accept = accept || this.bitSet(info, bit);
                continue;
            }
            if (!this.bitSet(info, -bit)) continue;
            return false;
        }
        return accept;
    }

    private boolean bitSet(int num, int pattern) {
        if (num == 0) {
            return num == pattern;
        }
        return (num & pattern) == pattern;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public String getKey() {
        return this.mKey;
    }

    @Override
    public String toString() {
        if (this.mLocalized != null) {
            return this.mLocalized + "*";
        }
        return mLocalizer.msg(this.mName, this.mName) + "*";
    }

    public boolean equals(Object o) {
        return o instanceof ProgramFilter && this.getClass().equals(o.getClass()) && this.getName().equals(((ProgramFilter)o).getName());
    }
}

