/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.tvdataservice;

import devplugin.AbstractTvDataService;
import devplugin.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.settings.PluginSettings;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;

public class TvDataServiceProxyManager {
    public static final String PLUGIN_DIRECTORY = "tvdataservice";
    private static TvDataServiceProxyManager mInstance;
    private ArrayList<TvDataServiceProxy> mProxyList = new ArrayList();

    private TvDataServiceProxyManager() {
        AbstractTvDataService.setPluginManager(PluginManagerImpl.getInstance());
    }

    public static TvDataServiceProxyManager getInstance() {
        if (mInstance == null) {
            mInstance = new TvDataServiceProxyManager();
        }
        return mInstance;
    }

    public void registerTvDataService(TvDataServiceProxy service) {
        this.mProxyList.add(service);
    }

    public void setTvDataDir(File dir) {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            File dataServiceDir = new File(dir, proxy.getId());
            if (!dataServiceDir.exists()) {
                dataServiceDir.mkdirs();
            }
            proxy.setWorkingDirectory(dataServiceDir);
        }
    }

    public void init() {
        try {
            String tvdataRoot = Settings.Directories.TV_DATA.getString();
            File rootDir = new File(tvdataRoot);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
            this.setTvDataDir(rootDir);
            TvDataServiceProxy[] proxies = this.getDataServices();
            String[] subscribedServices = Settings.Channels.DATA_SERVICE_IDS_USED_CURRENTLY.getStringArray();
            List<String> list = Arrays.asList(subscribedServices);
            for (TvDataServiceProxy proxy : proxies) {
                if (list.size() != 0 && !list.contains(proxy.getId())) continue;
                PluginSettings.loadSettings(proxy);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean licensesAccepted(TvDataServiceProxy[] services) {
        return true;
    }

    public void shutDown() {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            if (!proxy.hasToSaveSettings()) continue;
            PluginSettings.storeSettings(proxy);
        }
    }

    public TvDataServiceProxy findDataServiceById(String id) {
        if (this.mProxyList != null) {
            for (TvDataServiceProxy proxy : this.mProxyList) {
                if (!id.equals(proxy.getId())) continue;
                return proxy;
            }
        }
        return null;
    }

    public TvDataServiceProxy[] getTvDataServices(String[] idArr) {
        ArrayList<TvDataServiceProxy> list = new ArrayList<TvDataServiceProxy>();
        for (String id : idArr) {
            TvDataServiceProxy proxy = this.findDataServiceById(id);
            if (proxy == null) continue;
            list.add(proxy);
        }
        if (list.size() > 0) {
            return list.toArray(new TvDataServiceProxy[list.size()]);
        }
        return this.getDataServices();
    }

    public TvDataServiceProxy[] getDataServices() {
        if (this.mProxyList == null) {
            return new TvDataServiceProxy[0];
        }
        return this.mProxyList.toArray(new TvDataServiceProxy[this.mProxyList.size()]);
    }

    public void setParamFrame(JFrame frame) {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            proxy.setParent(frame);
        }
    }

    public void fireTvBrowserStartFinished() {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            proxy.handleTvBrowserStartFinished();
        }
    }

    public void fireTvBrowserVersionUpdate(Version previousVersion) {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            proxy.handleTvBrowserVersionUpdate(previousVersion);
        }
    }

    public void loadNotSubscribed() {
        try {
            String[] subscribedServices = Settings.Channels.DATA_SERVICE_IDS_USED_CURRENTLY.getStringArray();
            if (subscribedServices.length == 0) {
                return;
            }
            List<String> list = Arrays.asList(subscribedServices);
            for (TvDataServiceProxy proxy : this.getDataServices()) {
                if (list.contains(proxy.getId())) continue;
                PluginSettings.loadSettings(proxy);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

