/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.ButtonAction;
import devplugin.ChannelDayProgram;
import devplugin.Date;
import devplugin.FilterChangeListenerV2;
import devplugin.PluginCenterPanel;
import devplugin.PluginCenterPanelWrapper;
import devplugin.PluginTreeNode;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import devplugin.ProgressMonitor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.TvDataBaseListener;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.favoritesplugin.ContextMenuProvider;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.favoritesplugin.core.ActorsFavorite;
import tvbrowser.extras.favoritesplugin.core.AdvancedFavorite;
import tvbrowser.extras.favoritesplugin.core.Exclusion;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.extras.favoritesplugin.core.FilterFavorite;
import tvbrowser.extras.favoritesplugin.core.PendingFilterLoader;
import tvbrowser.extras.favoritesplugin.core.TitleFavorite;
import tvbrowser.extras.favoritesplugin.core.TopicFavorite;
import tvbrowser.extras.favoritesplugin.dlgs.EditFavoriteDialog;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.favoritesplugin.dlgs.ManageFavoritesDialog;
import tvbrowser.extras.favoritesplugin.dlgs.ManageFavoritesPanel;
import tvbrowser.extras.favoritesplugin.wizards.ExcludeWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.TypeWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MutableChannelDayProgram;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.NullProgressMonitor;
import util.ui.ScrollableJPanel;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.progress.Progress;
import util.ui.progress.ProgressWindow;

public class FavoritesPlugin {
    public static final String ID_ACTION_MANAGE = "manageFavorites";
    public static final String ID_ACTION_SHOW_NEW = "showNewFavorites";
    public static final Logger LOG = Logger.getLogger(FavoritesPlugin.class.getName());
    private static final String ICON_CATEGORY = "emblems";
    private static final String ICON_NAME = "emblem-favorite";
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(FavoritesPlugin.class);
    private static FavoritesPlugin mInstance;
    private Properties mSettings = new Properties();
    private static final String DATAFILE_PREFIX = "favoritesplugin.FavoritesPlugin";
    private PluginTreeNode mRootNode;
    private boolean mHasRightToUpdate = false;
    private boolean mHasToUpdate = false;
    private static final String KEY_EXPERT_MODE = "expertMode";
    private static final String KEY_TYPE_SELECTION = "showTypeSelection";
    private static final String KEY_LAST_SELECTED_PROGRAM_FILTER = "lastSelectedProgramFilter";
    private static final String KEY_SHOW_BLACK_LIST_ENTRIES = "showBlackEntries";
    private static final String KEY_SHOW_PICTURES = "showPictures";
    private static final String KEY_SHOW_REPETITIONS = "showRepetitions";
    private static final String KEY_AUTOSELECT_REMINDER = "autoSelectReminder";
    private static final String KEY_MARK_PRIORITY = "markPriority";
    private static final String KEY_TIME_BUTTONS_SCROLL_TO_NEXT_IN_TAB = "timeButtonsScrollToNextTimeInTab";
    private static final String KEY_REACT_ON_FILTER_CHANGE = "reactOnFilterChange";
    private static final String KEY_FILTER_START_TYPE = "filterStartType";
    private static final String KEY_PROVIDE_TAB = "provideTab";
    private static final String KEY_SHOW_DATE_SEPARATORS = "showDateSeparators";
    private static final String KEY_SPLIT_PANE_POSITION = "splitpanePosition";
    private static final String KEY_SPLIT_PANE_POSITION_DIALOG = "splitpanePositionDlg";
    private static final String KEY_SPLIT_PANE_POSITION_DIALOG_NEW = "splitpanePositionDlgNew";
    private static final int VALUE_DEFAULT_SPLIT_PANE_POSITION = 200;
    private boolean mHasRightToSave = true;
    private Hashtable<String, ReceiveTargetItem> mSendPluginsTable = new Hashtable();
    private ProgramReceiveTarget[] mClientPluginTargets;
    private ArrayList<PendingFilterLoader> mPendingFavorites;
    private int mMarkPriority = -2;
    private Exclusion[] mExclusions;
    private static UpdateInfoThread mUpdateInfoThread;
    private Thread mUpdateThread;
    private AfterDataUpdateInfoPanel mInfoPanel;
    private ManageFavoritesPanel panel;
    private ExecutorService mThreadPool;
    private JPanel mCenterPanel;
    private PluginCenterPanelWrapper mWrapper;
    private ManageFavoritesPanel mMangePanel;
    private ProgramFieldType[] mDefaultProgramFieldTypeSelection;
    private AncestorListener mAncestorListener;
    private AtomicReference<Program[]> mLastFoundPrograms;
    private boolean mHasToSaveSettings;

    private FavoritesPlugin() {
        mInstance = this;
        this.mHasToSaveSettings = false;
        this.mLastFoundPrograms = new AtomicReference<Program[]>(new Program[0]);
        this.mDefaultProgramFieldTypeSelection = null;
        this.mRootNode = new PluginTreeNode(this.getName());
        this.mWrapper = new PluginCenterPanelWrapper(){
            FavoritesCenterPanel centerPanel;
            {
                this.centerPanel = new FavoritesCenterPanel();
            }

            @Override
            public PluginCenterPanel[] getCenterPanels() {
                return new PluginCenterPanel[]{this.centerPanel};
            }

            @Override
            public void scrolledToDate(Date date) {
                if (FavoritesPlugin.this.mMangePanel != null) {
                    FavoritesPlugin.this.mMangePanel.scrollToDate(date);
                }
            }

            @Override
            public void scrolledToNow() {
                if (FavoritesPlugin.this.mMangePanel != null) {
                    FavoritesPlugin.this.mMangePanel.scrollToNow();
                }
            }

            @Override
            public void scrolledToTime(int time) {
                if (FavoritesPlugin.this.mMangePanel != null) {
                    FavoritesPlugin.this.mMangePanel.scrollToTime(time, FavoritesPlugin.this.timeButtonsScrollToNextTimeInTab());
                }
            }

            @Override
            public void filterSelected(ProgramFilter filter) {
                if (FavoritesPlugin.this.mMangePanel != null && FavoritesPlugin.this.reactOnFilterChange()) {
                    FavoritesPlugin.this.mMangePanel.selectFilter(filter);
                }
            }
        };
        this.mCenterPanel = UiUtilities.createPersonaBackgroundPanel();
        this.mExclusions = new Exclusion[0];
        this.mPendingFavorites = new ArrayList(0);
        this.mClientPluginTargets = new ProgramReceiveTarget[0];
    }

    public void waitForFinishingUpdateThreads() {
        ExecutorService threadPool = this.mThreadPool;
        this.mThreadPool = null;
        if (threadPool != null) {
            LOG.info("Favorites: Wait for update threads to finish");
            threadPool.shutdown();
            try {
                boolean success = threadPool.awaitTermination(Math.max(FavoriteTreeModel.getInstance().getFavoriteArr().length, 10), TimeUnit.SECONDS);
                if (success) {
                    LOG.info("Favorites: Update threads were finished");
                } else {
                    LOG.severe("Favorites: Timeout on waiting for update threads to finish was reached");
                }
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "Waiting for favorite update finishing was interrupted", e);
            }
            threadPool = null;
        }
    }

    protected void showNewFavorites() {
        Favorite[] favoriteArr;
        ArrayList<Favorite> infoFavoriteList = new ArrayList<Favorite>(0);
        for (Favorite favorite : favoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr()) {
            if (favorite.getNewPrograms().length <= 0) continue;
            infoFavoriteList.add(favorite);
        }
        this.showManageFavoritesDialog(true, infoFavoriteList.toArray(new Favorite[infoFavoriteList.size()]), null);
    }

    protected void handleTvDataUpdateFinished() {
        this.mHasToUpdate = true;
        mUpdateInfoThread = null;
        if (this.mHasRightToUpdate) {
            this.mUpdateThread = new Thread("Favorites: handle update finished"){

                @Override
                public void run() {
                    try {
                        Favorite[] favorites;
                        Favorite[] favoriteArr;
                        FavoritesPlugin.this.mHasToUpdate = false;
                        ManageFavoritesDialog dlg = ManageFavoritesDialog.getInstance();
                        if (dlg != null) {
                            dlg.favoriteSelectionChanged();
                        }
                        FavoritesPlugin.this.mHasRightToSave = true;
                        FavoritesPlugin.this.updateRootNode(true);
                        ArrayList<Favorite> infoFavoriteList = new ArrayList<Favorite>(0);
                        for (Favorite favorite : favoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr()) {
                            Program[] programArr = favorite.clearRemovedPrograms();
                            if (programArr.length > 0) {
                                ProgramReceiveTarget[] receive;
                                for (ProgramReceiveTarget target : receive = favorite.getForwardPlugins()) {
                                    if (target == null || target.getReceifeIfForIdOfTarget() == null || target.getEventType() != 2 && target.getEventType() != 3) continue;
                                    target.receivePrograms(2, programArr);
                                }
                            }
                            if (!favorite.isRemindAfterDownload() || favorite.getNewPrograms().length <= 0) continue;
                            infoFavoriteList.add(favorite);
                        }
                        if (!infoFavoriteList.isEmpty()) {
                            Favorite[] infoFavoriteArr = infoFavoriteList.toArray(new Favorite[infoFavoriteList.size()]);
                            if (mUpdateInfoThread == null || !mUpdateInfoThread.isAlive()) {
                                mUpdateInfoThread = new UpdateInfoThread();
                                mUpdateInfoThread.setPriority(1);
                                mUpdateInfoThread.addFavorites(infoFavoriteArr);
                                mUpdateInfoThread.start();
                            } else {
                                mUpdateInfoThread.addFavorites(infoFavoriteArr);
                            }
                        }
                        for (Favorite fav : favorites = FavoriteTreeModel.getInstance().getFavoriteArr()) {
                            fav.revalidatePrograms();
                        }
                        if (FavoritesPlugin.this.mMangePanel != null) {
                            FavoritesPlugin.this.mMangePanel.handleFavoriteEvent();
                        }
                        FavoritesPlugin.this.loadLastFoundPrograms();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            this.mUpdateThread.start();
            try {
                this.mUpdateThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static synchronized FavoritesPlugin getInstance() {
        if (mInstance == null) {
            new FavoritesPlugin();
        }
        return mInstance;
    }

    public void handleTvBrowserStartFinished() {
        Favorite[] favs;
        this.updateRootNode(false);
        if (!this.mPendingFavorites.isEmpty()) {
            for (PendingFilterLoader fav : this.mPendingFavorites) {
                fav.loadPendingFilter();
            }
            this.mPendingFavorites.clear();
            this.mPendingFavorites = null;
        }
        for (Favorite fav : favs = FavoriteTreeModel.getInstance().getFavoriteArr()) {
            fav.initializeFilterExclusions();
        }
        this.mHasRightToUpdate = true;
        if (this.mHasToUpdate) {
            this.handleTvDataUpdateFinished();
        }
        FilterManagerImpl.getInstance().registerFilterChangeListener(new FilterChangeListenerV2(){

            private void handleFilterChanges(ProgramFilter[] filters, boolean delete) {
                if (filters == null || filters.length == 0) {
                    return;
                }
                ExecutorService threadPool = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 3));
                Favorite[] favorites = FavoriteTreeModel.getInstance().getFavoriteArr();
                AtomicBoolean reload = new AtomicBoolean(false);
                AtomicInteger count = new AtomicInteger(0);
                ProgressWindow progWin = new ProgressWindow(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("updatingFilter", "Updating Favorites with filter: {0}", filters[0].getName()));
                progWin.setMaximum(favorites.length);
                for (Favorite fav : favorites) {
                    if (fav instanceof FilterFavorite) {
                        threadPool.execute(() -> {
                            boolean update = false;
                            for (ProgramFilter filter : filters) {
                                update = (!delete ? ((FilterFavorite)fav).updateFilter(filter, false) : ((FilterFavorite)fav).deleteFilter(filter, false)) || update;
                            }
                            if (update) {
                                try {
                                    fav.updatePrograms();
                                }
                                catch (TvBrowserException e) {
                                    e.printStackTrace();
                                }
                            }
                            reload.compareAndSet(false, update);
                            progWin.setValue(count.incrementAndGet());
                        });
                        continue;
                    }
                    if (fav instanceof AdvancedFavorite) {
                        threadPool.execute(() -> {
                            boolean update = false;
                            for (ProgramFilter filter : filters) {
                                update = (!delete ? ((AdvancedFavorite)fav).updateFilter(filter, false) : ((AdvancedFavorite)fav).deleteFilter(filter, false)) || update;
                            }
                            if (update) {
                                try {
                                    fav.updatePrograms();
                                }
                                catch (TvBrowserException e) {
                                    e.printStackTrace();
                                }
                            }
                            reload.compareAndSet(false, update);
                            progWin.setValue(count.incrementAndGet());
                        });
                        continue;
                    }
                    threadPool.execute(() -> {
                        boolean update = false;
                        for (ProgramFilter filter : filters) {
                            update = (!delete ? fav.updateFilterExclusion(filter, false) : fav.deleteFilterExclusion(filter, false)) || update;
                        }
                        if (update) {
                            try {
                                fav.updatePrograms();
                            }
                            catch (TvBrowserException e) {
                                e.printStackTrace();
                            }
                        }
                        reload.compareAndSet(false, update);
                        progWin.setValue(count.incrementAndGet());
                    });
                }
                threadPool.shutdown();
                final AtomicBoolean done = new AtomicBoolean(false);
                progWin.run(new Progress(){

                    @Override
                    public void run() {
                        while (!done.get()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }, 2);
                try {
                    if (threadPool.awaitTermination(Math.max(favorites.length, 10), TimeUnit.SECONDS)) {
                        LOG.info("Favorites: Update threads were finished");
                    } else {
                        LOG.severe("Favorites: Timeout on waiting for update threads to finish was reached");
                    }
                }
                catch (InterruptedException e) {
                    LOG.log(Level.INFO, "Waiting for favorite update finishing was interrupted", e);
                }
                done.set(true);
                if (reload.get()) {
                    if (FavoritesPlugin.this.mMangePanel != null) {
                        FavoritesPlugin.this.mMangePanel.reload(true);
                    }
                    if (ManageFavoritesDialog.getInstance() != null) {
                        ManageFavoritesDialog.getInstance().reload(true);
                    }
                    FavoritesPlugin.this.store();
                }
            }

            @Override
            public void filterTouched(ProgramFilter[] filters) {
                this.handleFilterChanges(filters, false);
            }

            @Override
            public void filterTouched(ProgramFilter filter) {
                this.filterTouched(new ProgramFilter[]{filter});
            }

            @Override
            public void filterRemoved(ProgramFilter filter) {
                this.handleFilterChanges(new ProgramFilter[]{filter}, true);
            }

            @Override
            public void filterDefaultChanged(ProgramFilter filter) {
            }

            @Override
            public void filterAdded(ProgramFilter filter) {
            }
        });
        this.addPanel();
    }

    private void addPanel() {
        SwingUtilities.invokeLater(() -> {
            if (this.mSettings.getProperty(KEY_PROVIDE_TAB, "true").equals("true")) {
                if (this.mMangePanel == null) {
                    int splitPanePosition = this.getIntegerSetting(this.mSettings, KEY_SPLIT_PANE_POSITION, 200);
                    this.mMangePanel = new ManageFavoritesPanel(null, splitPanePosition, false, null, true, true);
                    this.mAncestorListener = new AncestorListener(){
                        private boolean mCheck = false;

                        @Override
                        public void ancestorRemoved(AncestorEvent event) {
                            Persona.getInstance().removePersonaListener(FavoritesPlugin.this.mMangePanel);
                            FavoritesPlugin.this.mMangePanel.removePersonaListener();
                            FavoritesPlugin.this.mCenterPanel.remove(FavoritesPlugin.this.mMangePanel);
                        }

                        @Override
                        public void ancestorMoved(AncestorEvent event) {
                        }

                        @Override
                        public void ancestorAdded(AncestorEvent event) {
                            Persona.getInstance().registerPersonaListener(FavoritesPlugin.this.mMangePanel);
                            FavoritesPlugin.this.mMangePanel.registerPersonaListener();
                            FavoritesPlugin.this.mCenterPanel.add((Component)FavoritesPlugin.this.mMangePanel, "Center");
                            FavoritesPlugin.this.mCenterPanel.repaint();
                            FavoritesPlugin.this.mMangePanel.updatePersona();
                            SwingUtilities.invokeLater(() -> {
                                FavoritesPlugin.this.mMangePanel.scrollToFirstNotExpiredIndex(this.mCheck);
                                this.mCheck = true;
                            });
                        }
                    };
                    this.mCenterPanel.addAncestorListener(this.mAncestorListener);
                    if (this.mCenterPanel.isVisible()) {
                        this.mAncestorListener.ancestorAdded(null);
                    }
                }
            } else {
                if (this.mMangePanel != null) {
                    Persona.getInstance().removePersonaListener(this.mMangePanel);
                    this.mMangePanel.removePersonaListener();
                }
                this.mCenterPanel.removeAncestorListener(this.mAncestorListener);
                this.mMangePanel = null;
            }
        });
    }

    public synchronized void store() {
        this.mHasToSaveSettings = true;
        InternalPluginProxyList.getInstance().storeData(FavoritesPluginProxy.getInstance(), true);
        this.mHasToSaveSettings = false;
    }

    public static ImageIcon getIconFromTheme(String category, String Icon2, int size) {
        return IconLoader.getInstance().getIconFromTheme(category, Icon2, size);
    }

    void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Favorite[] newFavoriteArr;
        int version = in.readInt();
        if (version < 6) {
            int size = in.readInt();
            newFavoriteArr = new Favorite[size];
            for (int i = 0; i < size; ++i) {
                if (version <= 2) {
                    newFavoriteArr[i] = AdvancedFavorite.loadOldFavorite(in);
                    continue;
                }
                String typeID = (String)in.readObject();
                if ("topic".equals(typeID)) {
                    newFavoriteArr[i] = new TopicFavorite(in);
                    continue;
                }
                if ("title".equals(typeID)) {
                    newFavoriteArr[i] = new TitleFavorite(in);
                    continue;
                }
                if ("actors".equals(typeID)) {
                    newFavoriteArr[i] = new ActorsFavorite(in);
                    continue;
                }
                if (!"advanced".equals(typeID)) continue;
                newFavoriteArr[i] = new AdvancedFavorite(in);
            }
            FavoriteTreeModel.initInstance(newFavoriteArr);
        } else {
            FavoriteTreeModel.initInstance(in, version);
            newFavoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr();
        }
        for (Favorite newFavorite : newFavoriteArr) {
            Program[] programArr;
            for (Program program : programArr = newFavorite.getWhiteListPrograms()) {
                program.mark(FavoritesPluginProxy.getInstance());
            }
        }
        boolean reminderFound = false;
        if (version <= 4) {
            int size = in.readInt();
            ArrayList<ProgramReceiveTarget> list = new ArrayList<ProgramReceiveTarget>(0);
            for (int i = 0; i < size; ++i) {
                Object id = null;
                if (version == 1) {
                    String className = (String)in.readObject();
                    id = "java." + className;
                } else {
                    id = (String)in.readObject();
                }
                if (version <= 2 && ((String)id).equals("java.reminderplugin.ReminderPlugin")) {
                    reminderFound = true;
                }
                if (version <= 2 && (version > 2 || ((String)id).equals("java.reminderplugin.ReminderPlugin"))) continue;
                list.add(ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId((String)id));
            }
            if (!list.isEmpty()) {
                this.mClientPluginTargets = list.toArray(new ProgramReceiveTarget[list.size()]);
            }
        } else {
            int n = in.readInt();
            this.mClientPluginTargets = new ProgramReceiveTarget[n];
            for (int i = 0; i < n; ++i) {
                this.mClientPluginTargets[i] = new ProgramReceiveTarget(in);
            }
        }
        if (version <= 2 && reminderFound) {
            for (Favorite newFavorite : newFavoriteArr) {
                newFavorite.getReminderConfiguration().setReminderServices(new String[]{"window"});
            }
            this.updateAllFavorites();
        }
        if (version >= 4 && version < 8) {
            in.readBoolean();
        }
        if (version >= 7) {
            this.mExclusions = new Exclusion[in.readInt()];
            for (int i = 0; i < this.mExclusions.length; ++i) {
                this.mExclusions[i] = new Exclusion(in);
            }
        }
        if (version >= 9) {
            int fieldTypeCount = in.readInt();
            if (fieldTypeCount > 0) {
                this.mDefaultProgramFieldTypeSelection = new ProgramFieldType[fieldTypeCount];
                for (int i = 0; i < this.mDefaultProgramFieldTypeSelection.length; ++i) {
                    int typeId = in.readInt();
                    this.mDefaultProgramFieldTypeSelection[i] = ProgramFieldType.getTypeForId(typeId);
                }
            } else {
                this.mDefaultProgramFieldTypeSelection = null;
            }
        }
        this.loadLastFoundPrograms();
    }

    private void loadLastFoundPrograms() {
        Favorite[] favoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr();
        ArrayList<Program> foundPrograms = new ArrayList<Program>();
        for (Favorite favorite : favoriteArr) {
            Program[] newPrograms;
            favorite.clearRemovedPrograms();
            for (Program test : newPrograms = favorite.getNewPrograms()) {
                if (foundPrograms.contains(test)) continue;
                foundPrograms.add(test);
            }
        }
        this.mLastFoundPrograms.set(foundPrograms.toArray(new Program[foundPrograms.size()]));
    }

    private void updateAllFavorites() {
        ProgressMonitor monitor;
        this.mSendPluginsTable.clear();
        Favorite[] favoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr();
        if (favoriteArr.length > 5) {
            try {
                monitor = MainFrame.getInstance().createProgressMonitor();
            }
            catch (Exception e) {
                e.printStackTrace();
                monitor = new NullProgressMonitor();
            }
        } else {
            monitor = new NullProgressMonitor();
        }
        monitor.setMaximum(favoriteArr.length);
        monitor.setMessage(LOCALIZER.msg("updatingFavorites", "Updating favorites"));
        for (int i = 0; i < favoriteArr.length; ++i) {
            monitor.setValue(i);
            try {
                favoriteArr[i].refreshBlackList();
                favoriteArr[i].updatePrograms(true, true);
                continue;
            }
            catch (TvBrowserException e) {
                ErrorHandler.handle(e);
            }
        }
        monitor.setMessage("");
        monitor.setValue(0);
        if (!this.mSendPluginsTable.isEmpty()) {
            this.sendToPlugins();
        }
    }

    private void sendToPlugins() {
        Collection<ReceiveTargetItem> targets = this.mSendPluginsTable.values();
        StringBuilder buffer = new StringBuilder();
        ArrayList<Favorite> errorFavorites = new ArrayList<Favorite>(0);
        for (ReceiveTargetItem receiveTargetItem : targets) {
            Favorite[] favs;
            int type = receiveTargetItem.getReceiveTarget().getEventType();
            if (type == 2 || receiveTargetItem.getReceiveTarget().receivePrograms(1, receiveTargetItem.getPrograms())) continue;
            for (Favorite fav : favs = FavoriteTreeModel.getInstance().getFavoritesContainingReceiveTarget(receiveTargetItem.getReceiveTarget())) {
                if (errorFavorites.contains(fav)) continue;
                errorFavorites.add(fav);
            }
            buffer.append(receiveTargetItem.getReceiveTarget().getReceifeIfForIdOfTarget().toString()).append(" - ").append(receiveTargetItem.toString()).append('\n');
        }
        if (buffer.length() > 0) {
            buffer.insert(0, LOCALIZER.msg("sendError", "Error by sending programs to other plugins.\n\nPlease check the favorites that should send\nprograms to the following plugins:\n"));
            buffer.append(LOCALIZER.msg("sendErrorFavorites", "\nThe following Favorites are affected by this:\n"));
            ScrollableJPanel panel = new ScrollableJPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            panel.setLayout(new BoxLayout(panel, 1));
            Iterator iterator = errorFavorites.iterator();
            while (iterator.hasNext()) {
                Favorite fav;
                Favorite finalFav = fav = (Favorite)iterator.next();
                panel.add(UiUtilities.createHtmlHelpTextArea("<a href=\"#link\">" + fav.getName() + "</a>", e -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        this.editFavorite(finalFav);
                    }
                }));
            }
            JScrollPane jScrollPane = new JScrollPane(panel);
            jScrollPane.setPreferredSize(new Dimension(0, 100));
            Object[] msg = new Object[]{buffer.toString(), jScrollPane};
            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), msg, Localizer.getLocalization("i18n_error"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgramsForSending(ProgramReceiveTarget[] targets, Program[] programs) {
        for (ProgramReceiveTarget target : targets) {
            if (target == null || target.getReceifeIfForIdOfTarget() == null) continue;
            Hashtable<String, ReceiveTargetItem> hashtable = this.mSendPluginsTable;
            synchronized (hashtable) {
                ReceiveTargetItem item = this.mSendPluginsTable.get(FavoritesPlugin.getKeyForReceiveTarget(target, true));
                if (item == null) {
                    item = new ReceiveTargetItem(target);
                    this.mSendPluginsTable.put(FavoritesPlugin.getKeyForReceiveTarget(target, true), item);
                }
                item.addPrograms(programs);
            }
        }
    }

    public boolean isShowingBlackListEntries() {
        return this.mSettings.getProperty(KEY_SHOW_BLACK_LIST_ENTRIES, "false").compareTo("true") == 0;
    }

    public void setIsShowingBlackListEntries(boolean value) {
        this.mSettings.setProperty(KEY_SHOW_BLACK_LIST_ENTRIES, String.valueOf(value));
    }

    void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(9);
        FavoriteTreeModel.getInstance().storeData(out);
        out.writeInt(this.mClientPluginTargets.length);
        for (ProgramReceiveTarget programReceiveTarget : this.mClientPluginTargets) {
            programReceiveTarget.writeData(out);
        }
        out.writeInt(this.mExclusions.length);
        for (Comparable<ProgramReceiveTarget> comparable : this.mExclusions) {
            ((Exclusion)comparable).writeData(out);
        }
        if (this.mDefaultProgramFieldTypeSelection != null) {
            out.writeInt(this.mDefaultProgramFieldTypeSelection.length);
            for (ProgramFieldType programFieldType : this.mDefaultProgramFieldTypeSelection) {
                out.writeInt(programFieldType.getTypeId());
            }
        } else {
            out.writeInt(0);
        }
    }

    private synchronized ExecutorService getExecutorService() {
        if (this.mThreadPool == null || this.mThreadPool.isShutdown()) {
            return Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 3));
        }
        return this.mThreadPool;
    }

    void loadSettings(Properties settings) {
        this.mSettings = settings;
        if (settings == null) {
            throw new IllegalArgumentException("settings is null");
        }
        TvDataBase.getInstance().addTvDataListener(new TvDataBaseListener(){

            @Override
            public void dayProgramTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
                try {
                    if (Settings.General.LOGGING_VERBOSE.getBoolean()) {
                        String logMessage = "Favorites: dayProgramTouched called with removedDayProgram '" + removedDayProgram + "' and addedDayProgram '" + addedDayProgram + "' for channel '";
                        if (removedDayProgram != null) {
                            logMessage = logMessage + removedDayProgram.getChannel().getName() + "' on " + removedDayProgram.getDate();
                        } else if (addedDayProgram != null) {
                            logMessage = logMessage + addedDayProgram.getChannel().getName() + "' on " + addedDayProgram.getDate();
                        }
                        LOG.info(logMessage);
                    }
                    if (FavoritesPlugin.this.mThreadPool == null || FavoritesPlugin.this.mThreadPool.isShutdown()) {
                        FavoritesPlugin.this.mThreadPool = FavoritesPlugin.this.getExecutorService();
                    }
                    Runnable update = () -> {
                        Favorite[] favArray;
                        Object object = favArray = removedDayProgram != null || addedDayProgram != null ? FavoriteTreeModel.getInstance().getFavoriteArr() : null;
                        if (removedDayProgram != null && favArray != null) {
                            Iterator<Program> it1 = removedDayProgram.getPrograms();
                            it1.forEachRemaining(p1 -> {
                                for (Favorite fav1 : favArray) {
                                    try {
                                        fav1.removeProgram((Program)p1);
                                    }
                                    catch (Throwable t) {
                                        ErrorHandler.handle("Error in removing program from Favorites", t);
                                    }
                                }
                            });
                        }
                        if (addedDayProgram != null && favArray != null) {
                            Iterator<Program> it2 = addedDayProgram.getPrograms();
                            it2.forEachRemaining(p2 -> {
                                for (Favorite fav2 : favArray) {
                                    try {
                                        fav2.tryToMatch((Program)p2);
                                    }
                                    catch (Throwable t) {
                                        ErrorHandler.handle("Error in searching programs for Favorites", t);
                                    }
                                }
                            });
                        }
                    };
                    FavoritesPlugin.this.mThreadPool.execute(update);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Favorite update caused error", t);
                }
            }

            @Override
            public void dayProgramAdded(ChannelDayProgram prog) {
            }

            @Override
            public void dayProgramDeleted(ChannelDayProgram prog) {
            }

            @Override
            public void dayProgramAdded(MutableChannelDayProgram prog) {
            }
        });
        TvDataUpdater.getInstance().addTvDataUpdateListener(new TvDataUpdateListener(){

            @Override
            public void tvDataUpdateStarted(Date until) {
                Favorite[] favArray;
                if (FavoritesPlugin.this.mThreadPool == null || FavoritesPlugin.this.mThreadPool.isShutdown()) {
                    FavoritesPlugin.this.mThreadPool = FavoritesPlugin.this.getExecutorService();
                }
                FavoritesPlugin.this.mHasRightToSave = false;
                FavoritesPlugin.this.mSendPluginsTable.clear();
                for (Favorite favorite : favArray = FavoriteTreeModel.getInstance().getFavoriteArr()) {
                    if (FavoritesPlugin.this.mInfoPanel == null) {
                        favorite.clearNewPrograms();
                    }
                    favorite.clearRemovedPrograms();
                }
            }

            @Override
            public void tvDataUpdateFinished() {
                if (TvDataUpdater.getInstance().tvDataWasChanged()) {
                    if (FavoritesPlugin.this.mMangePanel != null) {
                        FavoritesPlugin.this.mMangePanel.invalidate();
                        FavoritesPlugin.this.mMangePanel.repaint();
                    }
                    if (!FavoritesPlugin.this.mSendPluginsTable.isEmpty()) {
                        FavoritesPlugin.this.sendToPlugins();
                    }
                }
            }
        });
    }

    Properties storeSettings() {
        if (this.mMangePanel != null) {
            this.mSettings.setProperty(KEY_LAST_SELECTED_PROGRAM_FILTER, this.mMangePanel.getSelectedProgramFilterName());
            this.mSettings.setProperty(KEY_SPLIT_PANE_POSITION, Integer.toString(this.mMangePanel.getSplitpanePosition()));
        }
        return this.mSettings;
    }

    private int getIntegerSetting(Properties prop, String key, int defaultValue) {
        int res = defaultValue;
        try {
            res = Integer.parseInt(prop.getProperty(key, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }

    protected ActionMenu getButtonAction() {
        ButtonAction action = new ButtonAction();
        action.setActionListener(e -> FavoritesPlugin.getInstance().showManageFavoritesDialog());
        action.setBigIcon(FavoritesPlugin.getIconFromTheme(ICON_CATEGORY, ICON_NAME, 22));
        action.setSmallIcon(FavoritesPlugin.getIconFromTheme(ICON_CATEGORY, ICON_NAME, 16));
        action.setShortDescription(LOCALIZER.msg("favoritesManager", "Manage favorite programs"));
        action.setText(this.getName());
        action.putValue("ActionId", ID_ACTION_MANAGE);
        ButtonAction showNew = new ButtonAction();
        showNew.setActionListener(e -> FavoritesPlugin.getInstance().showNewFavorites());
        showNew.setBigIcon(FavoritesPlugin.getIconFromTheme(ICON_CATEGORY, ICON_NAME, 22));
        showNew.setSmallIcon(FavoritesPlugin.getIconFromTheme(ICON_CATEGORY, ICON_NAME, 16));
        showNew.setShortDescription(LOCALIZER.msg("showNewDesc", "Show new programs found at last data update again"));
        showNew.setText(LOCALIZER.msg("showNewTitle", "Show new programs"));
        showNew.putValue("####KEYBOARD_ACCELERATOR####", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        showNew.putValue("ActionId", ID_ACTION_SHOW_NEW);
        ActionMenu m = new ActionMenu(this.getName(), (Icon)FavoritesPlugin.getIconFromTheme(ICON_CATEGORY, ICON_NAME, 16), new Action[]{action, showNew});
        m.getAction().putValue("BigIcon", FavoritesPlugin.getIconFromTheme(ICON_CATEGORY, ICON_NAME, 22));
        return m;
    }

    protected void showManageFavoritesDialog() {
        this.showManageFavoritesDialog(null);
    }

    protected void showManageFavoritesDialog(Favorite initialSelection) {
        this.showManageFavoritesDialog(false, null, initialSelection);
    }

    protected ActionMenu getContextMenuActions(Program program) {
        return new ContextMenuProvider(FavoriteTreeModel.getInstance().getFavoriteArr()).getContextMenuActions(program);
    }

    public void editFavorite(Favorite favorite) {
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        EditFavoriteDialog dlg = new EditFavoriteDialog(parent, favorite);
        UiUtilities.centerAndShow(dlg);
        if (dlg.getOkWasPressed()) {
            this.updateRootNode(true);
        }
    }

    private void showManageFavoritesDialog(boolean showNew, Favorite[] favoriteArr, Favorite initialSelection) {
        String keySplitPane = showNew ? KEY_SPLIT_PANE_POSITION_DIALOG_NEW : KEY_SPLIT_PANE_POSITION_DIALOG;
        int splitPanePosition = this.getIntegerSetting(this.mSettings, keySplitPane, 200);
        ManageFavoritesDialog dlg = new ManageFavoritesDialog(MainFrame.getInstance(), favoriteArr, splitPanePosition, showNew, initialSelection);
        Settings.layoutWindow("extras.manageFavoritesDlg", dlg, new Dimension(650, 450));
        dlg.setVisible(true);
        splitPanePosition = dlg.getSplitpanePosition();
        this.mSettings.setProperty(keySplitPane, Integer.toString(splitPanePosition));
        if (!showNew) {
            this.updateRootNode(true);
        }
    }

    public boolean isUsingExpertMode() {
        return this.mSettings.getProperty(KEY_EXPERT_MODE, "false").compareTo("true") == 0;
    }

    public void setIsUsingExpertMode(boolean value) {
        this.mSettings.setProperty(KEY_EXPERT_MODE, String.valueOf(value));
    }

    public boolean showTypeSelection() {
        return this.mSettings.getProperty(KEY_TYPE_SELECTION, "true").compareTo("true") == 0;
    }

    public void setShowTypeSelection(boolean value) {
        this.mSettings.setProperty(KEY_TYPE_SELECTION, String.valueOf(value));
    }

    public boolean isShowingPictures() {
        return this.mSettings.getProperty(KEY_SHOW_PICTURES, "false").compareTo("true") == 0;
    }

    public void setIsShowingPictures(boolean value) {
        this.mSettings.setProperty(KEY_SHOW_PICTURES, String.valueOf(value));
    }

    public void showCreateFavoriteWizard(Program program) {
        this.showCreateFavoriteWizard(program, null);
    }

    public void showCreateFavoriteWizard(Program program, String path) {
        this.showCreateFavoriteWizardInternal(program, null, null);
    }

    public void showCreateActorFavoriteWizard(Program program, String actor) {
        this.showCreateFavoriteWizardInternal(program, actor, null);
    }

    public void showCreateTopicFavoriteWizard(Program program, String topic) {
        this.showCreateFavoriteWizardInternal(program, null, topic);
    }

    private void showCreateFavoriteWizardInternal(Program program, String actor, String topic) {
        Favorite favorite;
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        if (this.isUsingExpertMode()) {
            favorite = this.showTypeSelection() && JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("askType.message", "Create a filter favorite?"), LOCALIZER.msg("askType.title", "Type selection"), 0, 3) == 0 ? new FilterFavorite() : new AdvancedFavorite(program != null ? program.getTitle() : "");
            EditFavoriteDialog dlg = new EditFavoriteDialog(parent, favorite);
            UiUtilities.centerAndShow(dlg);
            if (!dlg.getOkWasPressed()) {
                favorite = null;
            }
        } else {
            TypeWizardStep initialStep = new TypeWizardStep(program);
            if (topic != null) {
                initialStep.setTopic(topic);
            } else if (actor != null) {
                initialStep.setActor(actor);
            }
            WizardHandler handler = new WizardHandler(parent, initialStep);
            favorite = (Favorite)handler.show();
        }
        if (favorite != null) {
            try {
                favorite.updatePrograms();
                FavoriteTreeModel.getInstance().addFavorite(favorite);
                if (ManageFavoritesDialog.getInstance() != null) {
                    ManageFavoritesDialog.getInstance().addFavorite(favorite, null);
                }
                if (this.mMangePanel != null) {
                    this.mMangePanel.reload();
                }
            }
            catch (TvBrowserException exc) {
                ErrorHandler.handle(LOCALIZER.msg("couldNotUpdateFavorites", "Could not update favorites."), exc);
            }
            if (program == null && favorite.getPrograms().length == 0 && !favorite.isRemindAfterDownload()) {
                Object[] options = new Object[]{LOCALIZER.msg("btn.notifyMe", "Notify Me"), LOCALIZER.msg("btn.editFavorite", "Edit Favorite"), LOCALIZER.msg("btn.ignore", "Ignore")};
                int option = JOptionPane.showOptionDialog(parent, LOCALIZER.msg("dlg.noMatchingPrograms", "Currently no program matches the newly created favorite.\n\nDo you want TV-Browser to notify you when any program matches this favorite?"), LOCALIZER.msg("dlg.title.information", "Information"), 0, 1, null, options, options[0]);
                if (option == 0) {
                    favorite.setRemindAfterDownload(true);
                } else if (option == 1) {
                    this.editFavorite(favorite);
                }
            } else if (program != null && !favorite.contains(program) && program.getDate().compareTo(new Date()) >= 0) {
                Exclusion[] globalExclusions = FavoritesPlugin.getInstance().getGlobalExclusions();
                StringBuilder excluded = new StringBuilder();
                String message = LOCALIZER.msg("dlg.programDoesntMatch", "The currently selected program does not belong to the newly created favorite.\n\nDo you want to edit the favorite?");
                String optionEdit = LOCALIZER.msg("btn.editFavorite", "Edit Favorite");
                for (Exclusion test : globalExclusions) {
                    if (!test.isProgramExcluded(program)) continue;
                    if (excluded.length() > 0) {
                        excluded.append("\n");
                    }
                    excluded.append("    -").append(test.toString().replace("<html>", "").replace("</html>", ""));
                }
                if (excluded.length() > 0) {
                    message = LOCALIZER.msg("dlg.programExcluded", "The currently selected program is at excluded from the favorites by the following global exclusions:\n{0}\n\nDo you want to edit the global exclusions?", excluded.toString());
                    optionEdit = LOCALIZER.msg("btn.editGlobalExclusion", "Edit global exclusions");
                }
                Object[] options = new Object[]{optionEdit, LOCALIZER.msg("btn.ignore", "Ignore")};
                if (JOptionPane.showOptionDialog(parent, message, LOCALIZER.msg("dlg.title.warning", "Warning"), 0, 2, null, options, options[1]) == 0) {
                    if (excluded.length() == 0) {
                        this.editFavorite(favorite);
                    } else {
                        MainFrame.getInstance().showSettingsDialog("#favorite");
                    }
                }
            }
        }
        this.saveFavorites();
    }

    public synchronized void saveFavorites() {
        this.store();
        Thread thread = new Thread("Save favorites"){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> {
                    if (FavoritesPlugin.this.mMangePanel != null) {
                        FavoritesPlugin.this.mMangePanel.handleFavoriteEvent();
                    }
                });
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void showExcludeProgramsDialog(Favorite fav, Program program) {
        WizardHandler handler = new WizardHandler(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), new ExcludeWizardStep(fav, program));
        Object exclusion = handler.show();
        if (exclusion != null) {
            if (fav == null) {
                Exclusion[] exclusionArr = new Exclusion[this.mExclusions.length + 1];
                System.arraycopy(this.mExclusions, 0, exclusionArr, 0, this.mExclusions.length);
                exclusionArr[this.mExclusions.length] = (Exclusion)exclusion;
                this.setGlobalExclusions(exclusionArr, true);
            } else if (exclusion instanceof Exclusion) {
                fav.addExclusion((Exclusion)exclusion);
            } else if (exclusion instanceof String && exclusion.equals("blacklist")) {
                fav.addToBlackList(program);
            }
        }
    }

    public void askAndDeleteFavorite(Favorite fav) {
        if (JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("reallyDelete", "Really delete favorite '{0}'?", fav.getName()), Localizer.getLocalization("i18n_delete"), 0) == 0) {
            FavoriteTreeModel.getInstance().deleteFavorite(fav);
            this.saveFavorites();
        }
    }

    public PluginTreeNode getRootNode() {
        return this.mRootNode;
    }

    public void updateRootNode(boolean save) {
        FavoriteTreeModel.getInstance().resetMultiplesCounter();
        this.mRootNode.removeAllActions();
        this.mRootNode.getMutableTreeNode().setIcon(FavoritesPlugin.getFavoritesIcon(16));
        AbstractAction manageFavorite = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesPlugin.this.showManageFavoritesDialog();
            }
        };
        manageFavorite.putValue("SmallIcon", FavoritesPlugin.getFavoritesIcon(16));
        manageFavorite.putValue("Name", LOCALIZER.ellipsisMsg("favoritesManager", "Manage Favorites"));
        AbstractAction addFavorite = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesPlugin.this.showCreateFavoriteWizard(null);
            }
        };
        addFavorite.putValue("SmallIcon", TVBrowserIcons.newIcon(16));
        addFavorite.putValue("Name", LOCALIZER.ellipsisMsg("new", "Create new favorite"));
        AbstractAction openSettings = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showSettingsDialog("#favorite");
            }
        };
        openSettings.putValue("SmallIcon", TVBrowserIcons.preferences(16));
        openSettings.putValue("Name", Localizer.getEllipsisLocalization("i18n_settings"));
        this.mRootNode.addAction(manageFavorite);
        this.mRootNode.addAction(addFavorite);
        this.mRootNode.addAction(null);
        this.mRootNode.addAction(openSettings);
        this.mRootNode.removeAllChildren();
        this.mRootNode.getMutableTreeNode().setShowLeafCountEnabled(false);
        PluginTreeNode topicNode = this.mRootNode.addNode(Localizer.getLocalization("i18n_programs"));
        topicNode.setGroupingByDateEnabled(false);
        PluginTreeNode dateNode = this.mRootNode.addNode(LOCALIZER.msg("days", "Days"));
        dateNode.setGroupingByDateEnabled(true);
        ArrayList<Program> allPrograms = new ArrayList<Program>(1000);
        FavoriteTreeModel.getInstance().updatePluginTree(topicNode, allPrograms);
        HashSet<Program> allProgramsSet = new HashSet<Program>(allPrograms);
        for (Program program : allProgramsSet) {
            dateNode.addProgramWithoutCheck(program);
        }
        this.mRootNode.update();
        ReminderPlugin.getInstance().updateRootNode(this.mHasRightToSave);
        if (save && this.mHasRightToSave) {
            this.saveFavorites();
        }
        if (this.mMangePanel != null) {
            this.mMangePanel.handleFavoriteEvent();
        }
    }

    public static ImageIcon getFavoritesIcon(int size) {
        return FavoritesPlugin.getIconFromTheme(ICON_CATEGORY, ICON_NAME, size);
    }

    public ProgramReceiveTarget[] getClientPluginTargetIds() {
        ArrayList<ProgramReceiveTarget> list = new ArrayList<ProgramReceiveTarget>(0);
        for (ProgramReceiveTarget target : this.mClientPluginTargets) {
            ProgramReceiveIf plugin = target.getReceifeIfForIdOfTarget();
            if (plugin == null || !plugin.canReceiveProgramsWithTarget()) continue;
            list.add(target);
        }
        ProgramReceiveTarget[] targets = list.toArray(new ProgramReceiveTarget[list.size()]);
        if (!MainFrame.isStarting()) {
            this.mClientPluginTargets = targets;
        }
        return targets;
    }

    public void setClientPluginTargets(ProgramReceiveTarget[] clientPluginTargetArr) {
        this.mClientPluginTargets = clientPluginTargetArr;
        this.getClientPluginTargetIds();
    }

    public ProgramReceiveTarget[] getDefaultClientPluginsTargets() {
        return this.getClientPluginTargetIds();
    }

    public static String getFavoritesPluginId() {
        return DATAFILE_PREFIX;
    }

    public Properties getSettings() {
        return this.mSettings;
    }

    public void addPendingFavorite(PendingFilterLoader fav) {
        this.mPendingFavorites.add(fav);
    }

    protected boolean isShowingRepetitions() {
        return this.mSettings.getProperty(KEY_SHOW_REPETITIONS, "true").compareTo("true") == 0;
    }

    protected void setShowRepetitions(boolean value) {
        this.mSettings.setProperty(KEY_SHOW_REPETITIONS, String.valueOf(value));
    }

    public boolean isAutoSelectingReminder() {
        return this.mSettings.getProperty(KEY_AUTOSELECT_REMINDER, "true").compareTo("true") == 0;
    }

    protected void setAutoSelectingReminder(boolean value) {
        this.mSettings.setProperty(KEY_AUTOSELECT_REMINDER, String.valueOf(value));
    }

    protected int getMarkPriority() {
        if (this.mMarkPriority == -2 && this.mSettings != null && !this.mSettings.isEmpty()) {
            this.mMarkPriority = Integer.parseInt(this.mSettings.getProperty(KEY_MARK_PRIORITY, String.valueOf(0)));
            return this.mMarkPriority;
        }
        return this.mMarkPriority;
    }

    protected void setMarkPriority(int priority) {
        Favorite[] favoriteArr;
        this.mMarkPriority = priority;
        for (Favorite favorite : favoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr()) {
            Program[] programs;
            for (Program program : programs = favorite.getWhiteListPrograms()) {
                program.validateMarking();
            }
        }
        this.mSettings.setProperty(KEY_MARK_PRIORITY, String.valueOf(priority));
        this.saveFavorites();
    }

    public String toString() {
        return this.getName();
    }

    String getName() {
        return LOCALIZER.msg(ID_ACTION_MANAGE, "Favorites");
    }

    public static String getKeyForReceiveTarget(ProgramReceiveTarget target, boolean withSendingType) {
        if (target != null) {
            return target.getReceiveIfId() + "###" + target.getTargetId() + (String)(withSendingType ? "###" + target.getEventType() : "");
        }
        return null;
    }

    protected void setGlobalExclusions(Exclusion[] exclusions, final boolean onlyAdded) {
        this.mExclusions = exclusions;
        new Thread("globalFavoriteExclusionRefreshThread"){

            @Override
            public void run() {
                this.setPriority(1);
                for (Favorite fav : FavoriteTreeModel.getInstance().getFavoriteArr()) {
                    try {
                        if (!onlyAdded) {
                            fav.updatePrograms(false);
                            continue;
                        }
                        fav.refreshPrograms(true);
                    }
                    catch (TvBrowserException tvBrowserException) {
                        // empty catch block
                    }
                }
                FavoritesPlugin.this.saveFavorites();
            }
        }.start();
    }

    public Exclusion[] getGlobalExclusions() {
        return this.mExclusions;
    }

    public void addTitleFavorites(Program[] programArr) {
        ArrayList<String> allTitles = new ArrayList<String>(programArr.length);
        for (Program program : programArr) {
            allTitles.add(program.getTitle());
        }
        HashSet uniqueTitles = new HashSet(allTitles);
        Favorite[] allFavorites = FavoriteTreeModel.getInstance().getFavoriteArr();
        for (String newTitle : uniqueTitles) {
            TitleFavorite favorite;
            boolean found = false;
            for (Favorite oldFavorite : allFavorites) {
                if (!oldFavorite.getName().equalsIgnoreCase(newTitle)) continue;
                found = true;
                break;
            }
            if (found || (favorite = new TitleFavorite(newTitle)) == null) continue;
            try {
                favorite.updatePrograms();
                FavoriteTreeModel.getInstance().addFavorite(favorite);
                if (ManageFavoritesDialog.getInstance() == null) continue;
                ManageFavoritesDialog.getInstance().addFavorite(favorite, null);
            }
            catch (TvBrowserException e) {
                e.printStackTrace();
            }
        }
        this.saveFavorites();
    }

    public void editSelectedFavorite() {
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            ManageFavoritesDialog.getInstance().editSelectedFavorite();
            if (this.mMangePanel != null) {
                this.mMangePanel.handleFavoriteEvent();
            }
        } else if (this.mMangePanel != null) {
            this.mMangePanel.editSelectedFavorite();
        }
    }

    public void newFavorite(FavoriteNode parent) {
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            ManageFavoritesDialog.getInstance().newFavorite(parent);
            if (this.mMangePanel != null) {
                this.mMangePanel.handleFavoriteEvent();
            }
        } else if (this.mMangePanel != null) {
            this.mMangePanel.newFavorite(parent);
        }
    }

    public void showSendDialog() {
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            ManageFavoritesDialog.getInstance().showSendDialog();
            this.mMangePanel.handleFavoriteEvent();
        } else if (this.mMangePanel != null) {
            this.mMangePanel.showSendDialog();
        }
    }

    public void deleteSelectedFavorite() {
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            ManageFavoritesDialog.getInstance().deleteSelectedFavorite();
            if (this.mMangePanel != null) {
                this.mMangePanel.handleFavoriteEvent();
            }
        } else if (this.mMangePanel != null) {
            this.mMangePanel.deleteSelectedFavorite();
        }
    }

    public boolean programListIsEmpty() {
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            return ManageFavoritesDialog.getInstance().programListIsEmpty();
        }
        return this.mMangePanel != null ? this.mMangePanel.programListIsEmpty() : false;
    }

    public boolean isShowingNewFoundPrograms() {
        return this.panel != null;
    }

    public void newFolder(FavoriteNode parent) {
        this.newFolder(parent, null);
    }

    public void newFolder(FavoriteNode parent, String name) {
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            ManageFavoritesDialog.getInstance().newFolder(parent, ManageFavoritesDialog.getInstance(), name);
        } else if (this.mMangePanel != null) {
            this.mMangePanel.newFolder(parent, MainFrame.getInstance(), name);
        }
        this.updateRootNode(true);
    }

    public void favoriteSelectionChanged() {
        if (this.panel != null) {
            this.panel.favoriteSelectionChanged();
        }
        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
            ManageFavoritesDialog.getInstance().favoriteSelectionChanged();
        } else if (this.mMangePanel != null) {
            this.mMangePanel.favoriteSelectionChanged();
        }
    }

    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return this.provideTab() ? this.mWrapper : null;
    }

    AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        if (this.mUpdateThread != null && this.mUpdateThread.isAlive()) {
            try {
                this.mUpdateThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (mUpdateInfoThread != null) {
            if (mUpdateInfoThread.isAlive()) {
                try {
                    mUpdateInfoThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.mInfoPanel != null) {
                return this.mInfoPanel;
            }
        }
        return null;
    }

    public boolean provideTab() {
        return this.mSettings.getProperty(KEY_PROVIDE_TAB, "true").equals("true");
    }

    public void setProvideTab(boolean value) {
        this.mSettings.setProperty(KEY_PROVIDE_TAB, String.valueOf(value));
        this.addPanel();
    }

    public ProgramFieldType[] getDefaultProgramFieldTypeSelection() {
        return this.mDefaultProgramFieldTypeSelection;
    }

    public void setDefaultProgramFieldTypeSelection(ProgramFieldType[] defaultSelection) {
        this.mDefaultProgramFieldTypeSelection = defaultSelection;
    }

    public boolean showDateSeparators() {
        return this.mSettings.getProperty(KEY_SHOW_DATE_SEPARATORS, "true").equals("true");
    }

    public void setShowDateSeparators(boolean show) {
        this.mSettings.setProperty(KEY_SHOW_DATE_SEPARATORS, String.valueOf(show));
        if (this.mMangePanel != null) {
            this.mMangePanel.setShowDateSeparators(show);
        }
    }

    public void reValidateChannelLimitation() {
        ((FavoriteNode)FavoriteTreeModel.getInstance().getRoot()).reValidateChannelLimitations();
    }

    public FavoriteFilter getFilterForKeyValue(String keyValue) {
        try {
            Favorite[] favorites;
            long key = Long.parseLong(keyValue);
            for (Favorite fav : favorites = FavoriteTreeModel.getInstance().getFavoriteArr()) {
                if (!fav.hasFilterForKey(key)) continue;
                return new FavoriteFilter(fav);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public boolean timeButtonsScrollToNextTimeInTab() {
        return this.mSettings.getProperty(KEY_TIME_BUTTONS_SCROLL_TO_NEXT_IN_TAB, "true").equals("true");
    }

    public void setTimeButtonsScrollToNextTimeInTab(boolean value) {
        this.mSettings.setProperty(KEY_TIME_BUTTONS_SCROLL_TO_NEXT_IN_TAB, String.valueOf(value));
    }

    public boolean reactOnFilterChange() {
        return this.mSettings.getProperty(KEY_REACT_ON_FILTER_CHANGE, "true").equals("true");
    }

    public void setReactOnFilterChange(boolean value) {
        this.mSettings.setProperty(KEY_REACT_ON_FILTER_CHANGE, String.valueOf(value));
    }

    public int getFilterStartType() {
        return Integer.parseInt(this.mSettings.getProperty(KEY_FILTER_START_TYPE, "0"));
    }

    public void setFilterStartType(int type) {
        this.mSettings.setProperty(KEY_FILTER_START_TYPE, String.valueOf(type));
    }

    public ProgramFilter getLastSelectedProgramFilter() {
        ProgramFilter[] availableFilter;
        ProgramFilter test = FilterManagerImpl.getInstance().getAllFilter();
        String name = this.mSettings.getProperty(KEY_LAST_SELECTED_PROGRAM_FILTER, test.getName());
        for (ProgramFilter filter : availableFilter = FilterManagerImpl.getInstance().getAvailableFilters()) {
            if (filter == null || !filter.getName().equals(name)) continue;
            test = filter;
            break;
        }
        return test;
    }

    public boolean isNewProgram(Program prog) {
        Program[] progs;
        boolean result = false;
        for (Program p : progs = this.mLastFoundPrograms.get()) {
            if (!p.equals(prog)) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean hasToSaveSettings() {
        return this.mHasToSaveSettings;
    }

    private class FavoritesCenterPanel
    extends PluginCenterPanel {
        private FavoritesCenterPanel() {
        }

        @Override
        public String getName() {
            return FavoritesPlugin.getInstance().getName();
        }

        @Override
        public JPanel getPanel() {
            return FavoritesPlugin.this.mCenterPanel;
        }
    }

    private class UpdateInfoThread
    extends Thread {
        private Favorite[] mFavorites;

        protected UpdateInfoThread() {
            super("Manage favorites");
            this.mFavorites = new Favorite[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addFavorites(Favorite[] favArr) {
            ArrayList<Favorite> newFavoriteList = new ArrayList<Favorite>(this.mFavorites.length + favArr.length);
            Favorite[] favoriteArray = this.mFavorites;
            synchronized (this.mFavorites) {
                for (Favorite fav : favArr) {
                    boolean found = false;
                    for (Favorite knownFavorite : this.mFavorites) {
                        if (!fav.equals(knownFavorite)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    newFavoriteList.add(fav);
                }
                Favorite[] newFavorites = new Favorite[this.mFavorites.length + newFavoriteList.size()];
                System.arraycopy(this.mFavorites, 0, newFavorites, 0, this.mFavorites.length);
                System.arraycopy(newFavoriteList.toArray(), 0, newFavorites, this.mFavorites.length, newFavoriteList.size());
                // ** MonitorExit[var4_3] (shouldn't be in output)
                this.mFavorites = newFavorites;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (!this.newFavoritesFound()) return;
            Favorite[] favoriteArray = this.mFavorites;
            synchronized (this.mFavorites) {
                FavoritesPlugin.this.panel = new ManageFavoritesPanel(this.mFavorites, FavoritesPlugin.this.getIntegerSetting(FavoritesPlugin.this.mSettings, FavoritesPlugin.KEY_SPLIT_PANE_POSITION, 200), true, null, true, false);
                FavoritesPlugin.this.mInfoPanel = new AfterDataUpdateInfoPanel(){

                    @Override
                    public void closed() {
                        FavoritesPlugin.this.panel.close();
                        FavoritesPlugin.this.mInfoPanel = null;
                        FavoritesPlugin.this.panel = null;
                    }
                };
                FavoritesPlugin.this.mInfoPanel.setLayout((LayoutManager)new FormLayout("default:grow", "fill:320dlu:grow"));
                FavoritesPlugin.this.mInfoPanel.add((Component)FavoritesPlugin.this.panel, CC.xy((int)1, (int)1));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private boolean newFavoritesFound() {
            for (int i = 0; i < this.mFavorites.length; ++i) {
                if (this.mFavorites[i] == null || this.mFavorites[i].getNewPrograms().length <= 0) continue;
                return true;
            }
            return false;
        }
    }

    private static class ReceiveTargetItem {
        private ProgramReceiveTarget mTarget;
        private ArrayList<Program> mProgramsList;

        protected ReceiveTargetItem(ProgramReceiveTarget target) {
            this.mTarget = target;
            this.mProgramsList = new ArrayList(0);
        }

        protected void addPrograms(Program[] programs) {
            for (Program p : programs) {
                if (this.mProgramsList.contains(p)) continue;
                this.mProgramsList.add(p);
            }
        }

        protected ProgramReceiveTarget getReceiveTarget() {
            return this.mTarget;
        }

        protected Program[] getPrograms() {
            return this.mProgramsList.toArray(new Program[this.mProgramsList.size()]);
        }

        public String toString() {
            return this.mTarget.toString();
        }
    }
}

