/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import devplugin.Channel;
import devplugin.Date;
import devplugin.NodeFormatter;
import devplugin.PluginTreeNode;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramItem;
import devplugin.ProgramReceiveTarget;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTree;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class FavoriteTreeModel
extends DefaultTreeModel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FavoriteTreeModel.class);
    private static FavoriteTreeModel mInstance;
    private ArrayList<Program> mMultiples = null;

    private FavoriteTreeModel(TreeNode root) {
        super(root, true);
    }

    public static FavoriteTreeModel initInstance(Favorite[] favoriteArr) {
        FavoriteNode rootNode = new FavoriteNode("");
        FavoriteTreeModel.fixRootNode(rootNode);
        for (Favorite fav : favoriteArr) {
            rootNode.add(fav);
        }
        mInstance = new FavoriteTreeModel(rootNode);
        return mInstance;
    }

    public static FavoriteTreeModel initInstance(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        FavoriteNode rootNode = new FavoriteNode(in, version);
        FavoriteTreeModel.fixRootNode(rootNode);
        mInstance = new FavoriteTreeModel(rootNode);
        return mInstance;
    }

    private static void fixRootNode(FavoriteNode rootNode) {
        String rootLabel = mLocalizer.msg("rootLabel", "All favorites");
        if (StringUtils.isEmpty((CharSequence)rootLabel)) {
            rootLabel = "FAVORITES_ROOT";
        }
        rootNode.setUserObject(rootLabel);
    }

    public static FavoriteTreeModel getInstance() {
        if (mInstance == null) {
            mInstance = FavoriteTreeModel.initInstance(new Favorite[0]);
        }
        return mInstance;
    }

    @Override
    public void reload(TreeNode node) {
        super.reload(node);
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            if (!(child instanceof FavoriteNode) || !((FavoriteNode)child).isDirectoryNode()) continue;
            this.reload(child);
        }
    }

    public void reload(FavoriteTree tree, TreeNode node) {
        super.reload(node);
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            if (!(child instanceof FavoriteNode) || !((FavoriteNode)child).isDirectoryNode()) continue;
            this.reload(tree, child);
        }
        FavoriteNode parent = (FavoriteNode)node;
        if (parent.wasExpanded()) {
            tree.expandPath(new TreePath(tree.getModel().getPathToRoot(node)));
        } else {
            tree.collapsePath(new TreePath(tree.getModel().getPathToRoot(node)));
        }
    }

    @Override
    public void reload() {
        this.reload(this.root);
    }

    @Override
    public boolean isLeaf(Object nodeObject) {
        if (nodeObject instanceof FavoriteNode) {
            FavoriteNode node = (FavoriteNode)nodeObject;
            return node.getChildCount() == 0;
        }
        return super.isLeaf(nodeObject);
    }

    public Favorite[] getFavoriteArr() {
        return this.getFavoriteArr((FavoriteNode)this.getRoot(), true);
    }

    public Favorite[] getFavoriteArr(FavoriteNode node, boolean withChilds) {
        ArrayList<Favorite> favoriteList = new ArrayList<Favorite>();
        this.fillFavoriteList(node, favoriteList, withChilds);
        return favoriteList.toArray(new Favorite[favoriteList.size()]);
    }

    private void fillFavoriteList(FavoriteNode node, ArrayList<Favorite> favoriteList, boolean withChilds) {
        if (node.isDirectoryNode()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                if (!(child instanceof FavoriteNode)) continue;
                if (withChilds && ((FavoriteNode)child).isDirectoryNode()) {
                    this.fillFavoriteList((FavoriteNode)child, favoriteList, withChilds);
                    continue;
                }
                if (!((FavoriteNode)child).containsFavorite()) continue;
                favoriteList.add(((FavoriteNode)child).getFavorite());
            }
        }
    }

    public void deleteFavorite(Favorite favorite) {
        this.deleteFavorite(favorite, true);
    }

    public HashMap<String, ArrayList<Program>> findProgramsToSendForRemove(Program[] deleted, ProgramReceiveTarget[] targets, Favorite caller) {
        HashMap<String, ArrayList<Program>> toSend = new HashMap<String, ArrayList<Program>>();
        HashMap favoriteMap = new HashMap();
        for (ProgramReceiveTarget target : targets) {
            Favorite[] favs;
            if (target.getEventType() != 2 && target.getEventType() != 3 || (favs = this.getFavoritesContainingReceiveTarget(target)) == null) continue;
            ArrayList<Favorite> list = new ArrayList<Favorite>();
            for (Favorite f : favs) {
                if (caller != null && f.equals(caller)) continue;
                list.add(f);
            }
            if (list.isEmpty()) continue;
            favoriteMap.put(FavoritesPlugin.getKeyForReceiveTarget(target, false), list);
        }
        for (Program program : deleted) {
            if (caller == null || !this.isContainedByOtherFavorites(caller, program)) {
                program.unmark(FavoritesPluginProxy.getInstance());
            }
            for (ProgramReceiveTarget target : targets) {
                String key = FavoritesPlugin.getKeyForReceiveTarget(target, false);
                if (!favoriteMap.isEmpty()) {
                    ArrayList favs = (ArrayList)favoriteMap.get(key);
                    if (favs != null) {
                        boolean found = false;
                        for (Favorite f : favs) {
                            if (!f.contains(program)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        FavoriteTreeModel.addProgramToMap(toSend, key, program);
                        continue;
                    }
                    FavoriteTreeModel.addProgramToMap(toSend, key, program);
                    continue;
                }
                FavoriteTreeModel.addProgramToMap(toSend, key, program);
            }
        }
        return toSend;
    }

    private static void addProgramToMap(HashMap<String, ArrayList<Program>> toSend, String key, Program program) {
        ArrayList<Program> programsList = toSend.get(key);
        if (programsList == null) {
            programsList = new ArrayList();
            toSend.put(key, programsList);
        }
        programsList.add(program);
    }

    public void deleteFavorite(Favorite favorite, boolean updateRootNode) {
        this.deleteFavorite((FavoriteNode)this.getRoot(), favorite);
        Program[] delFavPrograms = favorite.getPrograms();
        ProgramReceiveTarget[] targets = favorite.getForwardPlugins();
        ArrayList<ProgramReceiveTarget> supported = new ArrayList<ProgramReceiveTarget>();
        for (ProgramReceiveTarget target : targets) {
            if (target.getEventType() != 2 && target.getEventType() != 3) continue;
            supported.add(target);
        }
        HashMap<String, ArrayList<Program>> toSend = this.findProgramsToSendForRemove(delFavPrograms, supported.toArray(new ProgramReceiveTarget[0]), favorite);
        String[] reminderServices = favorite.getReminderConfiguration().getReminderServices();
        for (String reminderService : reminderServices) {
            if (!"window".equals(reminderService)) continue;
            ReminderPlugin.getInstance().removePrograms(delFavPrograms);
        }
        for (ProgramReceiveTarget target : supported) {
            ArrayList<Program> programs = toSend.get(FavoritesPlugin.getKeyForReceiveTarget(target, false));
            if (programs == null || programs.isEmpty()) continue;
            target.receivePrograms(2, programs.toArray(new Program[0]));
        }
        if (updateRootNode) {
            FavoritesPlugin.getInstance().updateRootNode(true);
        }
    }

    public boolean isContainedByOtherFavorites(Favorite favorite, Program p) {
        return this.isContainedByOtherFavorites((FavoriteNode)this.getRoot(), favorite, p);
    }

    private boolean isContainedByOtherFavorites(FavoriteNode node, Favorite favorite, Program p) {
        boolean value = false;
        if (node.isDirectoryNode()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                if (!(child instanceof FavoriteNode)) continue;
                if (((FavoriteNode)child).isDirectoryNode()) {
                    value = value || this.isContainedByOtherFavorites((FavoriteNode)child, favorite, p);
                    continue;
                }
                if (!((FavoriteNode)child).containsFavorite() || child.equals(favorite)) continue;
                value = value || ((FavoriteNode)child).getFavorite().contains(p);
            }
        }
        return value;
    }

    private void deleteFavorite(FavoriteNode node, Favorite fav) {
        if (node.isDirectoryNode()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                if (!(child instanceof FavoriteNode)) continue;
                if (((FavoriteNode)child).isDirectoryNode()) {
                    this.deleteFavorite((FavoriteNode)child, fav);
                    continue;
                }
                if (!((FavoriteNode)child).containsFavorite()) continue;
                if (child.equals(fav)) {
                    Program[] progs;
                    node.remove((FavoriteNode)child);
                    for (Program prog : progs = fav.getPrograms()) {
                        prog.validateMarking();
                    }
                    continue;
                }
                ((FavoriteNode)child).getFavorite().handleContainingPrograms(fav.getPrograms());
            }
        }
    }

    public void addFavorite(Favorite fav) {
        this.addFavorite(fav, (FavoriteNode)this.getRoot());
    }

    public FavoriteNode addFavorite(Favorite fav, FavoriteNode parent) {
        Program[] progs;
        if (parent == null) {
            parent = (FavoriteNode)this.getRoot();
        }
        FavoriteNode newNode = parent.add(fav);
        this.reload(parent);
        FavoritesPlugin.getInstance().updateRootNode(true);
        for (Program prog : progs = newNode.getAllPrograms(false)) {
            prog.validateMarking();
        }
        return newNode;
    }

    public static String getFavoriteLabel(Favorite favorite, Program program) {
        return FavoriteTreeModel.getFavoriteLabel(favorite, program, null);
    }

    public static String getFavoriteLabel(Favorite favorite, Program p, Channel currentChannel) {
        Object episode;
        Date currentDate;
        Date d = p.getDate();
        String progdate = d.equals((currentDate = Date.getCurrentDate()).addDays(-1)) ? Localizer.getLocalization("i18n_yesterday") : (d.equals(currentDate) ? Localizer.getLocalization("i18n_today") : (d.equals(currentDate.addDays(1)) ? Localizer.getLocalization("i18n_tomorrow") : p.getDateString()));
        String description = progdate + "  " + p.getTimeString();
        if (favorite.getName().compareTo(p.getTitle()) != 0) {
            description = description + "  " + p.getTitle();
        }
        if (p.getProgramState() == 0 && StringUtils.isNotBlank((CharSequence)(episode = p.getTextField(ProgramFieldType.EPISODE_TYPE)))) {
            if (((String)episode).length() <= 3) {
                episode = ProgramFieldType.EPISODE_TYPE.getLocalizedName() + " " + (String)episode;
            }
            description = description + ": " + (String)episode;
        }
        if (null == currentChannel || currentChannel != p.getChannel()) {
            description = description + "  (" + p.getChannel() + ")";
        }
        return description;
    }

    public void storeData(ObjectOutputStream out) throws IOException {
        ((FavoriteNode)this.getRoot()).store(out);
    }

    public void updatePluginTree(PluginTreeNode node, ArrayList<Program> allPrograms, FavoriteNode parentFavorite) {
        if (parentFavorite == null) {
            parentFavorite = (FavoriteNode)this.getRoot();
        }
        if (parentFavorite.isDirectoryNode()) {
            Enumeration<TreeNode> e = parentFavorite.children();
            while (e.hasMoreElements()) {
                final TreeNode child = e.nextElement();
                if (!(child instanceof FavoriteNode)) continue;
                if (((FavoriteNode)child).isDirectoryNode()) {
                    PluginTreeNode newNode = new PluginTreeNode(child.toString());
                    newNode.setGroupingByWeekEnabled(true);
                    this.updatePluginTree(newNode, allPrograms, (FavoriteNode)child);
                    if (newNode.isEmpty()) continue;
                    node.add(newNode);
                    continue;
                }
                Program[] progArr = ((FavoriteNode)child).getFavorite().getWhiteListPrograms();
                if (progArr.length <= 0) continue;
                PluginTreeNode newNode = new PluginTreeNode(child.toString());
                newNode.setGroupingByWeekEnabled(true);
                newNode.getMutableTreeNode().setIcon(FavoritesPlugin.getFavoritesIcon(16));
                node.add(newNode);
                AbstractAction editFavorite = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoritesPlugin.getInstance().editFavorite(((FavoriteNode)child).getFavorite());
                    }
                };
                editFavorite.putValue("Name", mLocalizer.ellipsisMsg("editTree", "Edit"));
                editFavorite.putValue("SmallIcon", TVBrowserIcons.edit(16));
                AbstractAction deleteFavorite = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoritesPlugin.getInstance().askAndDeleteFavorite(((FavoriteNode)child).getFavorite());
                    }
                };
                deleteFavorite.putValue("Name", mLocalizer.ellipsisMsg("deleteTree", "Delete"));
                deleteFavorite.putValue("SmallIcon", TVBrowserIcons.delete(16));
                deleteFavorite.putValue("ACTIONKEY_KEY_EVENT", 127);
                newNode.addAction(editFavorite);
                newNode.addAction(deleteFavorite);
                if (progArr.length <= 10) {
                    newNode.setGroupingByDateEnabled(false);
                }
                boolean episodeOnly = progArr.length > 1;
                for (Program program : progArr) {
                    if (program.getProgramState() == 0) {
                        String episode = program.getTextField(ProgramFieldType.EPISODE_TYPE);
                        if (!StringUtils.isBlank((CharSequence)episode)) continue;
                        episodeOnly = false;
                        break;
                    }
                    episodeOnly = false;
                }
                for (Program program : progArr) {
                    PluginTreeNode pNode = newNode.addProgramWithoutCheck(program);
                    allPrograms.add(program);
                    if (!episodeOnly && progArr.length > 10) continue;
                    pNode.setNodeFormatter(new NodeFormatter(){

                        @Override
                        public String format(ProgramItem pitem) {
                            Program p = pitem.getProgram();
                            return FavoriteTreeModel.getFavoriteLabel(((FavoriteNode)child).getFavorite(), p);
                        }
                    });
                }
            }
        }
    }

    public static ProgramCount getProgramsCount(FavoriteNode node, ProgramCount count) {
        if (count == null) {
            count = new ProgramCount();
        }
        if (node.containsFavorite()) {
            count.addPrograms(node.getFavorite().getWhiteListPrograms());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            FavoriteNode child = (FavoriteNode)node.getChildAt(i);
            if (child.containsFavorite()) {
                count.addPrograms(child.getFavorite().getWhiteListPrograms());
                continue;
            }
            count = FavoriteTreeModel.getProgramsCount(child, count);
        }
        return count;
    }

    public void sort(FavoriteNode node, Comparator<TreeNode> comp, String title) {
        String msg = mLocalizer.msg("reallySort", "Do you really want to sort '{0}'?\n\nThe current order will get lost.", node.toString());
        int result = JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), msg, title, 0);
        if (result == 0) {
            this.sortNodeInternal(node, comp);
        }
        FavoritesPlugin.getInstance().favoriteSelectionChanged();
    }

    private void sortNodeInternal(FavoriteNode node, Comparator<TreeNode> comp) {
        ArrayList<TreeNode> childNodes = Collections.list(node.children());
        Collections.sort(childNodes, comp);
        node.removeAllChildren();
        for (TreeNode child : childNodes) {
            if (!(child instanceof FavoriteNode)) continue;
            node.add((FavoriteNode)child);
            if (!((FavoriteNode)child).isDirectoryNode()) continue;
            this.sortNodeInternal((FavoriteNode)child, comp);
        }
    }

    public Favorite[] getFavoritesContainingReceiveTarget(ProgramReceiveTarget target) {
        ProgramReceiveTarget[] defaultTargets;
        Favorite[] favorites = this.getFavoriteArr();
        for (ProgramReceiveTarget defaultTarget : defaultTargets = FavoritesPlugin.getInstance().getDefaultClientPluginsTargets()) {
            if (!defaultTarget.equals(target)) continue;
            return favorites;
        }
        ArrayList<Favorite> receiveFavorites = new ArrayList<Favorite>();
        for (Favorite fav : favorites) {
            if (!fav.containsReceiveTarget(target)) continue;
            receiveFavorites.add(fav);
        }
        return receiveFavorites.toArray(new Favorite[receiveFavorites.size()]);
    }

    public void updatePluginTree(PluginTreeNode topicNode, ArrayList<Program> allPrograms) {
        this.updatePluginTree(topicNode, allPrograms, null);
    }

    public Favorite[] getFavoritesContainingProgram(Program program) {
        ArrayList<Favorite> containing = new ArrayList<Favorite>();
        block0: for (Favorite favorite : this.getFavoriteArr()) {
            for (Program favProgram : favorite.getWhiteListPrograms()) {
                if (!favProgram.equals(program)) continue;
                containing.add(favorite);
                continue block0;
            }
        }
        return containing.toArray(new Favorite[containing.size()]);
    }

    public boolean isInMultipleFavorites(Program program) {
        if (this.mMultiples == null) {
            HashMap<Program, Integer> map = new HashMap<Program, Integer>(2000);
            for (Favorite favorite : this.getFavoriteArr()) {
                for (Program favProgram : favorite.getPrograms()) {
                    Integer count = (Integer)map.get(favProgram);
                    if (count == null) {
                        count = 0;
                    }
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    map.put(favProgram, count);
                }
            }
            this.mMultiples = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                this.mMultiples.add((Program)entry.getKey());
            }
        }
        for (Program dupProgram : this.mMultiples) {
            if (!dupProgram.equals(program)) continue;
            return true;
        }
        return false;
    }

    public void resetMultiplesCounter() {
        this.mMultiples = null;
    }

    public void reValidateChannelLimitations() {
    }

    static final class ProgramCount {
        private HashSet<String> mAll = new HashSet();
        private HashSet<String> mToday = new HashSet();
        private Date mCurrent = Date.getCurrentDate();

        private void addProgram(Program p) {
            this.mAll.add(p.getUniqueID());
            if (p.getDate().equals(this.mCurrent) && !p.isExpired()) {
                this.mToday.add(p.getUniqueID());
            }
        }

        private void addPrograms(Program[] programs) {
            for (Program p : programs) {
                this.addProgram(p);
            }
        }

        int getCountToday() {
            return this.mToday.size();
        }

        int getCountAll() {
            return this.mAll.size();
        }

        boolean hasPrograms() {
            return !this.mAll.isEmpty();
        }

        boolean hasTodayPrograms() {
            return !this.mToday.isEmpty();
        }
    }
}

