/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.Program;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import tvbrowser.extras.common.LimitationConfiguration;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.RenameWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import util.i18n.Localizer;
import util.ui.ChannelChooserDlg;
import util.ui.EnhancedPanelBuilder;
import util.ui.TimePeriodChooser;
import util.ui.UiUtilities;

public class LimitationsWizardStep
extends AbstractWizardStep {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(LimitationsWizardStep.class);
    private JCheckBox mChannelCb;
    private JCheckBox mDayOfWeekCb;
    private JCheckBox mTimeCb;
    private JButton mChooseChannelsBtn;
    private JComboBox<Object> mDayOfWeekCombo;
    private TimePeriodChooser mTimePeriodChooser;
    private Program mProgram;
    private Channel[] mChannelArr;
    private WizardStep mCaller;
    private JPanel mContent;

    public LimitationsWizardStep(WizardStep caller, Program program) {
        this.mProgram = program;
        this.mCaller = caller;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Limitations");
    }

    @Override
    public JPanel createContent(WizardHandler handler) {
        int upBnd;
        int lowBnd;
        this.mChannelArr = this.mProgram != null ? new Channel[]{this.mProgram.getChannel()} : new Channel[0];
        this.mDayOfWeekCombo = new JComboBox<LimitationConfiguration.DayLimitValue>(LimitationConfiguration.DAYLIMIT_VALUE_ARRAY);
        if (this.mProgram != null) {
            lowBnd = (this.mProgram.getHours() - 1) * 60;
            if (lowBnd < 0) {
                lowBnd = 0;
            }
            if ((upBnd = lowBnd + 120) >= 1440) {
                upBnd = 1439;
            }
        } else {
            lowBnd = 0;
            upBnd = 1439;
        }
        this.mTimePeriodChooser = new TimePeriodChooser(lowBnd, upBnd, 1);
        EnhancedPanelBuilder panelBuilder = new EnhancedPanelBuilder(new FormLayout("pref, default:grow, pref"));
        panelBuilder.border(Borders.DLU4);
        panelBuilder.addLabelRow(false, LOCALIZER.msg("mainQuestion", "Are there any limitations?"), 1);
        this.mChannelCb = new JCheckBox(LOCALIZER.msg("limitByChannel", "Certain channels only:"));
        panelBuilder.addRow(this.mChannelCb, 1);
        this.mChooseChannelsBtn = new JButton(LOCALIZER.msg("selectChannels", "Select channels"));
        panelBuilder.add(this.mChooseChannelsBtn, 3);
        this.mDayOfWeekCb = new JCheckBox(LOCALIZER.msg("limitByDayOfWeek", "Certain day of week only:"));
        panelBuilder.addRow(this.mDayOfWeekCb, 1);
        panelBuilder.add(this.mDayOfWeekCombo, 3);
        this.mTimeCb = new JCheckBox(LOCALIZER.msg("limitByTime", "Certain start times only:"));
        panelBuilder.addRow(this.mTimeCb, 1);
        panelBuilder.add(this.mTimePeriodChooser, 3);
        this.updateControls();
        this.mChannelCb.addActionListener(e -> this.updateControls());
        this.mDayOfWeekCb.addActionListener(e -> this.updateControls());
        this.mTimeCb.addActionListener(e -> this.updateControls());
        this.mChooseChannelsBtn.addActionListener(e -> {
            Window parent = UiUtilities.getBestDialogParent(this.mContent);
            ChannelChooserDlg dlg = new ChannelChooserDlg(parent, this.mChannelArr, null, 1);
            UiUtilities.centerAndShow(dlg);
            Channel[] chArr = dlg.getChannels();
            if (chArr != null) {
                this.mChannelArr = dlg.getChannels();
                if (this.mChannelArr.length == 0) {
                    this.mChannelCb.setSelected(false);
                    this.updateControls();
                }
            }
        });
        this.mContent = panelBuilder.getPanel();
        this.mContent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LimitationsWizardStep.this.mChannelCb.requestFocusInWindow();
            }
        });
        return this.mContent;
    }

    private void updateControls() {
        this.mChooseChannelsBtn.setEnabled(this.mChannelCb.isSelected());
        this.mDayOfWeekCombo.setEnabled(this.mDayOfWeekCb.isSelected());
        this.mTimePeriodChooser.setEnabled(this.mTimeCb.isSelected());
    }

    @Override
    public Object createDataObject(Object obj) {
        Favorite fav = (Favorite)obj;
        if (this.mChannelCb.isSelected()) {
            fav.getLimitationConfiguration().setChannels(this.mChannelArr);
        }
        if (this.mTimeCb.isSelected()) {
            fav.getLimitationConfiguration().setTime(this.mTimePeriodChooser.getFromTime(), this.mTimePeriodChooser.getToTime());
        }
        if (this.mDayOfWeekCb.isSelected()) {
            int dayOfWeek = ((LimitationConfiguration.DayLimitValue)this.mDayOfWeekCombo.getSelectedItem()).getDay();
            fav.getLimitationConfiguration().setDayLimit(dayOfWeek);
            if (!this.mTimeCb.isSelected()) {
                fav.getLimitationConfiguration().setTime(0, 1439);
            }
        }
        return obj;
    }

    @Override
    public WizardStep next() {
        return new RenameWizardStep(this);
    }

    @Override
    public WizardStep back() {
        return this.mCaller;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4, 3, 1};
    }
}

