/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;

public class MinutesCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private JComboBox<RemindValue> mComboBox = new JComboBox<RemindValue>(new RemindValue[0]);

    public MinutesCellEditor() {
        this.mComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.mComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MinutesCellEditor.this.stopCellEditing();
            }
        });
    }

    private void setValue(ReminderListItem item) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.mComboBox.getModel();
        model.removeAllElements();
        for (RemindValue value : ReminderPlugin.calculatePossibleReminders(item.getProgram())) {
            model.addElement(value);
            if (value.getMinutes() != item.getMinutes()) continue;
            this.mComboBox.setSelectedItem(value);
        }
    }

    @Override
    public boolean stopCellEditing() {
        if (this.mComboBox.isEditable()) {
            this.mComboBox.actionPerformed(new ActionEvent(this, 0, ""));
        }
        return super.stopCellEditing();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return ((RemindValue)this.mComboBox.getSelectedItem()).getMinutes();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= 2;
        }
        return true;
    }

    JComboBox<RemindValue> getComboBox() {
        return this.mComboBox;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setValue((ReminderListItem)value);
        return this.mComboBox;
    }
}

