/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.ChannelDayProgram;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Timer;
import tvbrowser.core.ChannelList;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderTimerListener;
import util.io.IOUtilities;

public class ReminderList
implements ActionListener {
    private static final int MINUTES_PER_DAY = 1440;
    private ReminderTimerListener mListener = null;
    private Timer mTimer;
    private Timer mPauseTimer;
    private ArrayList<ReminderListItem> mList;
    private HashSet<String> mBlockedPrograms = new HashSet();
    private boolean needsSort = false;

    public ReminderList() {
        this.mList = new ArrayList();
    }

    public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 1 || version >= 3) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                in.readInt();
                int reminderMinutes = in.readInt();
                String comment = null;
                if (version >= 5) {
                    comment = in.readUTF();
                }
                Date programDate = Date.readData(in);
                String programId = (String)in.readObject();
                Program program = Plugin.getPluginManager().getProgram(programDate, programId);
                int referenceCount = 1;
                if (version >= 4) {
                    referenceCount = in.readInt();
                }
                if (program == null) continue;
                this.add(program, new ReminderContent(reminderMinutes, comment), referenceCount);
            }
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(5);
        ReminderListItem[] items = this.getReminderItems();
        out.writeInt(items.length);
        for (ReminderListItem item : items) {
            out.writeInt(3);
            out.writeInt(item.getMinutes());
            out.writeUTF(item.getComment());
            Date date = item.getProgram().getDate();
            date.writeData(out);
            out.writeObject(item.getProgram().getID());
            out.writeInt(item.getReferenceCount());
        }
    }

    public void add(Program program, ReminderContent reminderContent) {
        this.add(program, reminderContent, 1);
    }

    private void add(Program program, int minutes, int referenceCount) {
        this.add(program, new ReminderContent(minutes), referenceCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Program program, ReminderContent reminderContent, int referenceCount) {
        if (!program.isExpired() && reminderContent.getReminderMinutes() != -42) {
            ReminderListItem item = this.getReminderItem(program);
            if (item != null) {
                item.incReferenceCount();
                if (item.getMinutes() >= 0 && item.getMinutes() < reminderContent.getReminderMinutes()) {
                    item.setMinutes(reminderContent.getReminderMinutes());
                }
            } else {
                item = new ReminderListItem(program, reminderContent);
                item.setReferenceCount(referenceCount);
                ArrayList<ReminderListItem> arrayList = this.mList;
                synchronized (arrayList) {
                    this.mList.add(item);
                }
                this.needsSort = true;
                program.mark(ReminderPluginProxy.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndCheckBlocked(Program[] programs, int minutes) {
        for (Program program : programs) {
            if (!(this.contains(program) || this.mBlockedPrograms.contains(program.getUniqueID()) || program.isExpired())) {
                ReminderListItem item = new ReminderListItem(program, minutes);
                ArrayList<ReminderListItem> arrayList = this.mList;
                synchronized (arrayList) {
                    this.mList.add(item);
                }
                this.needsSort = true;
                program.mark(ReminderPluginProxy.getInstance());
                continue;
            }
            if (!this.contains(program)) continue;
            this.getReminderItem(program).incReferenceCount();
        }
    }

    public void update(Program[] programs, int minutes, int oldMinutesValue) {
        for (Program program : programs) {
            ReminderListItem item = this.getReminderItem(program);
            if (item == null || item.getMinutes() != oldMinutesValue) continue;
            item.setMinutes(minutes);
        }
    }

    public void setReminderTimerListener(ReminderTimerListener listener) {
        this.mListener = listener;
        if (ReminderPlugin.getInstance().isAllowedToStartTimer()) {
            this.startTimer();
        }
    }

    protected void startTimer() {
        if (this.mListener != null && this.mTimer == null) {
            this.mTimer = new Timer(10000, this);
            this.mTimer.start();
        } else if (!this.mTimer.isRunning()) {
            this.mTimer.start();
        }
    }

    public void updateItems() {
        ReminderListItem[] localItems;
        for (ReminderListItem item : localItems = this.mList.toArray(new ReminderListItem[this.mList.size()])) {
            Program program = item.getProgram();
            if (program == null || program.isExpired() || !ChannelList.isSubscribedChannel(program.getChannel()) || program.getProgramState() == 2) {
                this.remove(item);
                continue;
            }
            if (program == null || program.getProgramState() != 1) continue;
            item.refreshProgram();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ReminderListItem item) {
        item.decReferenceCount();
        if (item.getReferenceCount() < 1) {
            ArrayList<ReminderListItem> arrayList = this.mList;
            synchronized (arrayList) {
                this.mList.remove(item);
            }
            this.needsSort = true;
            item.getProgram().unmark(ReminderPluginProxy.getInstance());
        }
    }

    public void remove(ProgramItem item) {
        this.remove(item.getProgram());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Program program) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            for (ReminderListItem item : this.mList) {
                if (!item.getProgram().equals(program)) continue;
                return true;
            }
        }
        return false;
    }

    public void remove(Program program) {
        this.remove(new Program[]{program});
    }

    public void remove(Program[] programs) {
        ReminderListItem[] localItems = this.mList.toArray(new ReminderListItem[0]);
        block0: for (Program program : programs) {
            for (ReminderListItem item : localItems) {
                if (program == null || item == null || item.getProgram() != null && !item.getProgram().equals(program)) continue;
                this.remove(item);
                continue block0;
            }
        }
    }

    public void removeWithoutChecking(ProgramItem item) {
        this.removeWithoutChecking(item.getProgram());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderListItem removeWithoutChecking(Program program) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            for (ReminderListItem item : this.mList) {
                if (!item.getProgram().equals(program)) continue;
                this.mList.remove(item);
                this.needsSort = true;
                item.getProgram().unmark(ReminderPluginProxy.getInstance());
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWithoutChecking(ReminderListItem item) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            this.mList.add(item);
        }
        this.needsSort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderListItem getReminderItem(Program program) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            for (ReminderListItem item : this.mList) {
                if (!item.getProgram().equals(program)) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderListItem[] getReminderItems() {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            if (this.needsSort) {
                Collections.sort(this.mList);
                this.needsSort = false;
            }
            ReminderListItem[] items = this.mList.toArray(new ReminderListItem[this.mList.size()]);
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program[] updatePrograms() {
        ReminderListItem[] localItems;
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            localItems = this.mList.toArray(new ReminderListItem[0]);
            this.mList.clear();
        }
        ArrayList<Program> removedPrograms = new ArrayList<Program>();
        boolean reSearch = ReminderPlugin.getInstance().getSettings().isSet("stickyReminders");
        int time = ReminderPlugin.getInstance().getSettings().getAsInt("stickyMinutes");
        for (ReminderListItem item : localItems) {
            Program p;
            if (item.getProgram().getProgramState() == 2) {
                p = item.getProgram();
                Program result = null;
                if (reSearch) {
                    Program test;
                    int i;
                    int startTime = p.getStartTime();
                    ChannelDayProgram dayProgram = TvDataBase.getInstance().getDayProgram(p.getDate(), p.getChannel());
                    int index = -1;
                    boolean searchPrev = true;
                    boolean searchNext = true;
                    if (dayProgram != null) {
                        index = dayProgram.getIndexForTime(p.getStartTime());
                        if (index == -1) {
                            index = 0;
                        }
                        if (index > -1) {
                            for (i = index; i >= 0; --i) {
                                test = dayProgram.getProgramAt(i);
                                if (test.getStartTime() < startTime - time) {
                                    searchPrev = false;
                                    break;
                                }
                                if (test.getStartTime() < startTime - time || !p.getTitle().equals(test.getTitle())) continue;
                                result = test;
                                break;
                            }
                            if (result == null) {
                                for (i = index + 1; i < dayProgram.getProgramCount(); ++i) {
                                    test = dayProgram.getProgramAt(i);
                                    if (test.getStartTime() > startTime + time) {
                                        searchNext = false;
                                        break;
                                    }
                                    if (test.getStartTime() > startTime + time || !p.getTitle().equals(test.getTitle())) continue;
                                    result = test;
                                    break;
                                }
                            }
                        }
                    }
                    if (result == null && searchPrev) {
                        dayProgram = TvDataBase.getInstance().getDayProgram(p.getDate().addDays(-1), p.getChannel());
                        startTime += 1440;
                        if (dayProgram != null) {
                            for (i = dayProgram.getProgramCount() - 1; i >= 0 && (test = dayProgram.getProgramAt(i)).getStartTime() >= startTime - time; --i) {
                                if (test.getStartTime() < startTime - time || !p.getTitle().equals(test.getTitle())) continue;
                                result = test;
                                break;
                            }
                        }
                    }
                    if (result == null && searchNext) {
                        dayProgram = TvDataBase.getInstance().getDayProgram(p.getDate().addDays(1), p.getChannel());
                        startTime = p.getStartTime() - 1440;
                        if (dayProgram != null) {
                            for (i = 0; i < dayProgram.getProgramCount() && (test = dayProgram.getProgramAt(i)).getStartTime() <= startTime + time; ++i) {
                                if (test.getStartTime() > startTime + time || !p.getTitle().equals(test.getTitle())) continue;
                                result = test;
                                break;
                            }
                        }
                    }
                }
                if (result == null) {
                    removedPrograms.add(p);
                    continue;
                }
                this.add(result, item.getMinutes(), item.getReferenceCount());
                continue;
            }
            if (item.getProgram().getProgramState() == 1) {
                p = item.getProgram();
                this.add(Plugin.getPluginManager().getProgram(p.getDate(), p.getID()), item.getMinutes(), item.getReferenceCount());
                continue;
            }
            ArrayList<ReminderListItem> arrayList2 = this.mList;
            synchronized (arrayList2) {
                this.mList.add(item);
            }
            this.needsSort = true;
        }
        return removedPrograms.toArray(new Program[removedPrograms.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.mListener == null) {
            this.mTimer.stop();
            return;
        }
        Date today = Date.getCurrentDate();
        ArrayList<ReminderListItem> reminders = new ArrayList<ReminderListItem>();
        for (ReminderListItem item : this.getReminderItems()) {
            if (!this.isRemindEventRequired(item.getProgram(), item.getMinutes(), today)) continue;
            reminders.add(item);
        }
        if (reminders.size() > 0) {
            this.mListener.timeEvent(reminders);
        }
    }

    private boolean isRemindEventRequired(Program prog, int remindMinutes, Date today) {
        int diff;
        if (remindMinutes < -30 || this.mPauseTimer != null && this.mPauseTimer.isRunning() || ReminderPlugin.getInstance().getSettings().isSet("prefilter") && !GenericFilterMap.getInstance().getGenericInternalFilter("_reminderPrefilter").isBrokenPartially() && !GenericFilterMap.getInstance().getGenericInternalFilter("_reminderPrefilter").accept(prog)) {
            return false;
        }
        Date remindDate = prog.getDate();
        int remindTime = prog.getStartTime() - remindMinutes;
        if (remindTime < 0) {
            remindTime = -remindTime;
            int days = remindTime / 1440 + 1;
            remindTime = 1440 - remindTime % 1440;
            remindDate = remindDate.addDays(-days);
        }
        return ((diff = today.compareTo(remindDate)) > 0 || diff == 0 && IOUtilities.getMinutesAfterMidnight() >= remindTime) && !this.isBlocked(prog);
    }

    public void blockProgram(Program prg) {
        this.mBlockedPrograms.add(prg.getUniqueID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockProgram(Program prg) {
        HashSet<String> hashSet = this.mBlockedPrograms;
        synchronized (hashSet) {
            this.mBlockedPrograms.remove(prg.getUniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(Program prg) {
        HashSet<String> hashSet = this.mBlockedPrograms;
        synchronized (hashSet) {
            return this.mBlockedPrograms.contains(prg.getUniqueID());
        }
    }

    void pauseReminder(int minutes) {
        if (this.mPauseTimer != null && this.mPauseTimer.isRunning()) {
            this.mPauseTimer.stop();
        }
        this.mPauseTimer = new Timer(minutes * 60000, e -> {
            if (this.mTimer != null & !this.mTimer.isRunning()) {
                this.startTimer();
            }
            ReminderPlugin.getInstance().endPause();
            this.mPauseTimer = null;
        });
        this.mPauseTimer.setRepeats(false);
        this.mPauseTimer.start();
    }

    void toggleTimer() {
        if (this.mPauseTimer != null && this.mPauseTimer.isRunning()) {
            this.mPauseTimer.stop();
            return;
        }
        if (this.mTimer != null) {
            if (this.mTimer.isRunning()) {
                this.mTimer.stop();
            } else {
                this.startTimer();
            }
        }
    }

    boolean hasTimer() {
        return this.mTimer != null;
    }

    boolean isActive() {
        return this.mTimer != null && this.mTimer.isRunning();
    }
}

