/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Channel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.UIManager;
import tvbrowser.ui.programtable.ProgramTableChannelLabel;
import util.ui.persona.Persona;

public class ChannelPanel
extends JPanel {
    private int mColumnWidth;
    private ProgramTableChannelLabel[] mLabelArr;
    private int mColumnHeight = 15;

    public ChannelPanel(int columnWidth, Channel[] channelArr, KeyListener keyListener) {
        this.setLayout(new FlowLayout(0, 0, 0));
        Color c = Persona.getInstance().getAccentColor() == null ? UIManager.getColor("List.selectionBackground") : Persona.getInstance().getAccentColor().darker();
        this.setBackground(new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()));
        this.setShownChannels(channelArr, keyListener);
        this.setColumnWidth(columnWidth);
        this.addKeyListener(keyListener);
        this.setOpaque(Persona.getInstance().getAccentColor() == null);
    }

    public static void fontChanged() {
        ProgramTableChannelLabel.fontChanged();
    }

    public void setShownChannels(Channel[] channelArr, KeyListener keyListener) {
        this.removeAll();
        this.mLabelArr = new ProgramTableChannelLabel[channelArr.length];
        for (int i = 0; i < this.mLabelArr.length; ++i) {
            this.mLabelArr[i] = new ProgramTableChannelLabel(channelArr[i], keyListener);
            this.add(this.mLabelArr[i]);
            if (this.mLabelArr[i] == null || this.mLabelArr[i].getIcon() == null || this.mLabelArr[i].getIcon().getIconHeight() <= this.mColumnHeight) continue;
            this.mColumnHeight = this.mLabelArr[i].getIcon().getIconHeight();
        }
        this.setColumnWidth(this.mColumnWidth);
        this.repaint();
    }

    public void setColumnWidth(int columnWidth) {
        this.mColumnWidth = columnWidth;
        for (ProgramTableChannelLabel element : this.mLabelArr) {
            element.setPreferredSize(new Dimension(this.mColumnWidth, this.mColumnHeight));
        }
    }

    protected void updateChannelLabelForChannel(Channel ch) {
        if (ch == null) {
            return;
        }
        for (ProgramTableChannelLabel element : this.mLabelArr) {
            if (!element.getChannel().equals(ch)) continue;
            element.setChannel(ch);
            break;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (Persona.getInstance().getAccentColor() != null && Persona.getInstance().getHeaderImage() != null) {
            Color c = Persona.getInstance().getAccentColor().darker().darker().darker();
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 110));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            super.paintComponent(g);
        }
    }

    public void updatePersona() {
        for (ProgramTableChannelLabel label : this.mLabelArr) {
            if (label == null) continue;
            label.updatePersona();
        }
        this.setOpaque(Persona.getInstance().getAccentColor() == null);
        if (Persona.getInstance().getAccentColor() == null) {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        }
    }
}

