/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.CancelableSettingsTab;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.icontheme.IconTheme;
import tvbrowser.core.icontheme.InfoIconTheme;
import tvbrowser.core.icontheme.InfoThemeLoader;
import tvbrowser.core.icontheme.ThemeDownloadDlg;
import tvbrowser.core.icontheme.ThemeDownloadItem;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.LocaleSettingsTab;
import tvbrowser.ui.settings.looksSettings.JGoodiesLNFSettings;
import util.i18n.Localizer;
import util.ui.CustomComboBoxRenderer;
import util.ui.LinkButton;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.persona.PersonaInfo;

public final class LookAndFeelSettingsTab
implements CancelableSettingsTab {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(LookAndFeelSettingsTab.class);
    private JComboBox<LookAndFeelObj> mLfComboBox;
    private JPanel mSettingsPn;
    private JButton mConfigBtn;
    private JComboBox<Object> mIconThemes;
    private JComboBox<String> mPluginViewPosition;
    private JComboBox<String> mDateLayout;
    private JComboBox<Object> mPersonaSelection;
    private JComboBox<InfoIconTheme> mInfoIconThemes;
    private static int START_LOOK_AND_FEEL_INDEX = -1;
    private static int START_ICON_INDEX;
    private static int START_PLUGIN_VIEW_POSITION_INDEX;
    private static int START_INFO_ICON_THEME_INDEX;
    private static String JOODIES_START_THEME;
    private static boolean JGOODIES_START_SHADOW;

    private LookAndFeelObj[] getLookAndFeelObjs() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        LookAndFeelObj[] result = new LookAndFeelObj[info.length];
        for (int i = 0; i < info.length; ++i) {
            result[i] = new LookAndFeelObj(info[i]);
        }
        return result;
    }

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, pref, 3dlu, fill:default:grow, 3dlu, pref, 5dlu", "");
        this.mSettingsPn = new JPanel((LayoutManager)layout);
        this.mSettingsPn.setBorder(Borders.DIALOG);
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("lookAndFeel", "Look and Feel")), CC.xyw((int)1, (int)1, (int)7));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("channelPosition", "Channel list position") + ":"), CC.xy((int)2, (int)3));
        this.mPluginViewPosition = new JComboBox<String>(new String[]{Localizer.getLocalization("i18n_left"), Localizer.getLocalization("i18n_right")});
        if (Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean()) {
            this.mPluginViewPosition.setSelectedIndex(1);
        } else {
            this.mPluginViewPosition.setSelectedIndex(0);
        }
        this.mPluginViewPosition.addActionListener(e -> this.updateRestartMessage());
        this.mSettingsPn.add(this.mPluginViewPosition, CC.xy((int)4, (int)3));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("dateFormat", "Layout of Datelist") + ":"), CC.xy((int)2, (int)5));
        this.mDateLayout = new JComboBox<String>(new String[]{LOCALIZER.msg("dateFormat.datelist", "List"), LOCALIZER.msg("dateFormat.calendarTable", "Calendar (Table)"), LOCALIZER.msg("dateFormat.calendarButtons", "Calendar (Buttons)")});
        this.mDateLayout.setSelectedIndex(Settings.LookAndFeel.VIEW_DATE_LAYOUT.getInt());
        this.mDateLayout.addActionListener(e -> this.updateRestartMessage());
        this.mSettingsPn.add(this.mDateLayout, CC.xy((int)4, (int)5));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("theme", "Theme") + ":"), CC.xy((int)2, (int)7));
        Object[] lfObjects = this.getLookAndFeelObjs();
        Arrays.sort(lfObjects);
        this.mLfComboBox = new JComboBox<Object>(lfObjects);
        this.selectLookAndFeelFromSettings();
        this.mLfComboBox.addActionListener(e -> this.lookChanged());
        this.mSettingsPn.add(this.mLfComboBox, CC.xy((int)4, (int)7));
        this.mConfigBtn = new JButton(LOCALIZER.msg("config", "Config"));
        this.mConfigBtn.addActionListener(e -> this.configTheme());
        this.mSettingsPn.add((Component)this.mConfigBtn, CC.xy((int)6, (int)7));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("persona", "Persona") + ":"), CC.xy((int)2, (int)9));
        PersonaInfo[] installedPersonas = Persona.getInstance().getInstalledPersonas();
        this.mPersonaSelection = new JComboBox<PersonaInfo>(installedPersonas);
        LinkButton personaDetails = new LinkButton(LOCALIZER.msg("personaDetails", "Persona details"), "https://www.tvbrowser.org/");
        for (PersonaInfo info : installedPersonas) {
            if (Settings.LookAndFeel.PERSONA_RANDOM.getBoolean()) {
                if (!PersonaInfo.isRandomPersona(info)) continue;
                this.mPersonaSelection.setSelectedItem(info);
                personaDetails.setUrl(info.getDetailURL());
                break;
            }
            if (!Settings.LookAndFeel.PERSONA_SELECTED.getString().equals(info.getId())) continue;
            this.mPersonaSelection.setSelectedItem(info);
            personaDetails.setUrl(info.getDetailURL());
            break;
        }
        this.mPersonaSelection.setRenderer(new CustomComboBoxRenderer(this.mPersonaSelection.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)this.getBackendRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    label.setText(((PersonaInfo)value).getName());
                    label.setToolTipText(((PersonaInfo)value).getDescription());
                    if (((PersonaInfo)value).isSelectedPersona() && PersonaInfo.isRandomPersona((PersonaInfo)value)) {
                        label.setText(label.getText() + ": " + Persona.getInstance().getPersonaInfo(Persona.getInstance().getId()).getName());
                    }
                }
                return label;
            }
        });
        this.mPersonaSelection.addItemListener(e -> personaDetails.setUrl(((PersonaInfo)this.mPersonaSelection.getSelectedItem()).getDetailURL()));
        this.mSettingsPn.add(this.mPersonaSelection, CC.xy((int)4, (int)9));
        this.mSettingsPn.add((Component)personaDetails, CC.xy((int)6, (int)9));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("icons", "Icons") + ":"), CC.xy((int)2, (int)11));
        this.mIconThemes = new JComboBox();
        this.mIconThemes.setRenderer(new CustomComboBoxRenderer(this.mIconThemes.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)this.getBackendRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    label.setText(((IconTheme)value).getName());
                    label.setToolTipText(((IconTheme)value).getComment());
                }
                return label;
            }
        });
        this.fillThemeBox();
        JButton downloadThemes = new JButton(LOCALIZER.msg("downloadMore", "Download more"));
        downloadThemes.addActionListener(e -> this.downloadIcons(0));
        this.mSettingsPn.add(this.mIconThemes, CC.xy((int)4, (int)11));
        this.mSettingsPn.add((Component)downloadThemes, CC.xy((int)6, (int)11));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("infoIcons", "Program info icons") + ":"), CC.xy((int)2, (int)13));
        this.mInfoIconThemes = new JComboBox();
        this.fillInfoThemeBox();
        JButton downloadInfoThemes = new JButton(LOCALIZER.msg("downloadMore", "Download more"));
        downloadInfoThemes.addActionListener(e -> this.downloadIcons(1));
        this.mSettingsPn.add(this.mInfoIconThemes, CC.xy((int)4, (int)13));
        this.mSettingsPn.add((Component)downloadInfoThemes, CC.xy((int)6, (int)13));
        layout.appendRow(RowSpec.decode((String)"fill:3dlu:grow"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        if (START_LOOK_AND_FEEL_INDEX == -1) {
            START_LOOK_AND_FEEL_INDEX = this.mLfComboBox.getSelectedIndex();
            START_ICON_INDEX = this.mIconThemes.getSelectedIndex();
            START_PLUGIN_VIEW_POSITION_INDEX = this.mPluginViewPosition.getSelectedIndex();
            JOODIES_START_THEME = Settings.LookAndFeel.JGOODIES_THEME.getString();
            JGOODIES_START_SHADOW = Settings.LookAndFeel.JGOODIES_SHADOW.getBoolean();
            START_INFO_ICON_THEME_INDEX = this.mInfoIconThemes.getSelectedIndex();
        }
        this.mIconThemes.addActionListener(e -> this.updateRestartMessage());
        this.mInfoIconThemes.addActionListener(e -> this.updateRestartMessage());
        this.lookChanged();
        return this.mSettingsPn;
    }

    private void selectLookAndFeelFromSettings() {
        String lfName = Settings.LookAndFeel.SELECTED.getString();
        for (int i = 0; i < this.mLfComboBox.getItemCount(); ++i) {
            if (!this.mLfComboBox.getItemAt(i).getLFClassName().equals(lfName)) continue;
            this.mLfComboBox.setSelectedIndex(i);
            break;
        }
    }

    private void downloadIcons(int type) {
        if (JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("downloadMessage", "To download more icons an Internet connection is needed.\nDo you want to load the list with the available icons now?"), Localizer.getLocalization("i18n_info"), 0) == 0) {
            ThemeDownloadDlg themeDlg = new ThemeDownloadDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), type);
            themeDlg.setVisible(true);
            if (themeDlg.downloadSuccess()) {
                if (type == 0) {
                    this.fillThemeBox();
                } else {
                    ThemeDownloadItem[] successItems;
                    for (ThemeDownloadItem success : successItems = themeDlg.getSuccessItems()) {
                        File theme = new File(InfoThemeLoader.USER_ICON_DIR, success.toString());
                        InfoThemeLoader.getInstance().addIconTheme(theme);
                    }
                    this.fillInfoThemeBox();
                }
            }
        }
    }

    private void fillInfoThemeBox() {
        InfoIconTheme[] infoIconThemes = InfoThemeLoader.getInstance().getAvailableInfoIconThemes();
        String currentInfoIconTheme = Settings.LookAndFeel.INFO_ICON_THEME_ID.getString();
        String startIconID = null;
        if (this.mInfoIconThemes.getSelectedIndex() != -1) {
            startIconID = this.mInfoIconThemes.getItemAt(START_INFO_ICON_THEME_INDEX).getID();
            currentInfoIconTheme = ((InfoIconTheme)this.mInfoIconThemes.getSelectedItem()).getID();
        }
        this.mInfoIconThemes.removeAllItems();
        for (int i = 0; i < infoIconThemes.length; ++i) {
            this.mInfoIconThemes.addItem(infoIconThemes[i]);
            if (startIconID != null && startIconID.equals(infoIconThemes[i].getID())) {
                START_INFO_ICON_THEME_INDEX = i;
            }
            if (!infoIconThemes[i].getID().equals(currentInfoIconTheme)) continue;
            this.mInfoIconThemes.setSelectedIndex(i);
        }
    }

    private void fillThemeBox() {
        String startIconName = null;
        Object selectedName = Settings.LookAndFeel.ICON_THEME.getString();
        if (this.mIconThemes.getSelectedIndex() != -1) {
            startIconName = "icons/" + ((IconTheme)this.mIconThemes.getItemAt(START_ICON_INDEX)).getBase().getName();
            selectedName = "icons/" + ((IconTheme)this.mIconThemes.getSelectedItem()).getBase().getName();
        }
        this.mIconThemes.removeAllItems();
        Object[] available = IconLoader.getInstance().getAvailableThemes();
        Arrays.sort(available);
        for (int i = 0; i < available.length; ++i) {
            this.mIconThemes.addItem(available[i]);
            if (startIconName == null || !("icons/" + ((IconTheme)available[i]).getBase().getName()).equals(startIconName)) continue;
            START_ICON_INDEX = i;
        }
        if (selectedName != null) {
            IconTheme theme = IconLoader.getInstance().getIconTheme(IconLoader.getInstance().getIconThemeFile((String)selectedName));
            if (theme.loadTheme()) {
                this.mIconThemes.setSelectedItem(theme);
            } else {
                this.mIconThemes.setSelectedItem(IconLoader.getInstance().getDefaultTheme());
            }
        } else {
            this.mIconThemes.setSelectedItem(IconLoader.getInstance().getDefaultTheme());
        }
    }

    private void updateRestartMessage() {
        Settings.setRestartInfo(LocaleSettingsTab.class.getCanonicalName(), this.mLfComboBox.getSelectedIndex() != START_LOOK_AND_FEEL_INDEX || this.mIconThemes.getSelectedIndex() != START_ICON_INDEX || JOODIES_START_THEME.compareTo(Settings.LookAndFeel.JGOODIES_THEME.getString()) != 0 || JGOODIES_START_SHADOW != Settings.LookAndFeel.JGOODIES_SHADOW.getBoolean() || this.mPluginViewPosition.getSelectedIndex() != START_PLUGIN_VIEW_POSITION_INDEX || START_INFO_ICON_THEME_INDEX != this.mInfoIconThemes.getSelectedIndex());
    }

    void configTheme() {
        String classname = ((LookAndFeelObj)this.mLfComboBox.getSelectedItem()).getLFClassName();
        if (classname.startsWith("com.jgoodies")) {
            JGoodiesLNFSettings settings = new JGoodiesLNFSettings((JDialog)UiUtilities.getBestDialogParent(this.mSettingsPn));
            UiUtilities.centerAndShow(settings);
        }
        this.updateRestartMessage();
    }

    void lookChanged() {
        String classname = ((LookAndFeelObj)this.mLfComboBox.getSelectedItem()).getLFClassName();
        if ((classname.startsWith("com.jgoodies") || classname.startsWith("com.l2fprod")) && !classname.startsWith("com.jgoodies.looks.windows.WindowsLookAndFeel")) {
            this.mConfigBtn.setEnabled(true);
        } else {
            this.mConfigBtn.setEnabled(false);
        }
        this.updateRestartMessage();
    }

    @Override
    public void saveSettings() {
        LookAndFeelObj obj = (LookAndFeelObj)this.mLfComboBox.getSelectedItem();
        Settings.LookAndFeel.SELECTED.setString(obj.getLFClassName());
        IconTheme theme = (IconTheme)this.mIconThemes.getSelectedItem();
        Settings.LookAndFeel.ICON_THEME.setString("icons/" + theme.getBase().getName());
        Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.setBoolean(this.mPluginViewPosition.getSelectedIndex() == 1);
        Settings.LookAndFeel.VIEW_DATE_LAYOUT.setInt(this.mDateLayout.getSelectedIndex());
        if (PersonaInfo.isRandomPersona((PersonaInfo)this.mPersonaSelection.getSelectedItem())) {
            Settings.LookAndFeel.PERSONA_RANDOM.setBoolean(true);
        } else {
            Settings.LookAndFeel.PERSONA_RANDOM.setBoolean(false);
            Settings.LookAndFeel.PERSONA_SELECTED.setString(((PersonaInfo)this.mPersonaSelection.getSelectedItem()).getId());
        }
        Settings.LookAndFeel.INFO_ICON_THEME_ID.setString(((InfoIconTheme)this.mInfoIconThemes.getSelectedItem()).getID());
    }

    @Override
    public void cancel() {
        try {
            this.selectLookAndFeelFromSettings();
            String selectedName = Settings.LookAndFeel.ICON_THEME.getString();
            if (selectedName != null) {
                IconTheme theme = IconLoader.getInstance().getIconTheme(IconLoader.getInstance().getIconThemeFile(selectedName));
                if (theme.loadTheme()) {
                    this.mIconThemes.setSelectedItem(theme);
                } else {
                    this.mIconThemes.setSelectedItem(IconLoader.getInstance().getDefaultTheme());
                }
            }
            String currentInfoIconTheme = Settings.LookAndFeel.INFO_ICON_THEME_ID.getString();
            for (int i = 0; i < this.mInfoIconThemes.getItemCount(); ++i) {
                if (!this.mInfoIconThemes.getItemAt(i).getID().contentEquals(currentInfoIconTheme)) continue;
                this.mInfoIconThemes.setSelectedIndex(i);
                break;
            }
            Settings.setRestartInfo(LocaleSettingsTab.class.getCanonicalName(), this.mLfComboBox.getSelectedIndex() != START_LOOK_AND_FEEL_INDEX || this.mIconThemes.getSelectedIndex() != START_ICON_INDEX || JOODIES_START_THEME.compareTo(Settings.LookAndFeel.JGOODIES_THEME.getString()) != 0 || JGOODIES_START_SHADOW != Settings.LookAndFeel.JGOODIES_SHADOW.getBoolean() || (Settings.LookAndFeel.PLUGIN_VIEW_IS_LEFT.getBoolean() ? 1 : 0) != START_PLUGIN_VIEW_POSITION_INDEX || START_INFO_ICON_THEME_INDEX != this.mInfoIconThemes.getSelectedIndex());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-theme", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("graphical", "Graphical settings");
    }

    private static class LookAndFeelObj
    implements Comparable<LookAndFeelObj> {
        private UIManager.LookAndFeelInfo info;

        public LookAndFeelObj(UIManager.LookAndFeelInfo info) {
            this.info = info;
        }

        public String toString() {
            return this.info.getName();
        }

        public String getLFClassName() {
            return this.info.getClassName();
        }

        @Override
        public int compareTo(LookAndFeelObj other) {
            return this.toString().compareTo(other.toString());
        }
    }
}

