/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import java.util.Hashtable;

public class BooleanResult {
    private boolean[] mResultArr;
    private Hashtable<String, Integer> mResultNamesTable;
    private Hashtable<Integer, String> mNamesResultTable;

    public BooleanResult(boolean ... values) {
        this.mResultArr = values;
        this.mResultNamesTable = new Hashtable();
        this.mNamesResultTable = new Hashtable();
    }

    public void setResultNames(String ... names) {
        this.mResultNamesTable.clear();
        this.mNamesResultTable.clear();
        for (int i = 0; i < names.length; ++i) {
            this.mResultNamesTable.put(names[i], i);
            this.mNamesResultTable.put(i, names[i]);
        }
    }

    public int getResultCount() {
        return this.mResultArr.length;
    }

    public boolean[] getResults() {
        return this.mResultArr;
    }

    public boolean getResultForIndex(Integer index) {
        if (this.mResultArr != null && index != null && index < this.mResultArr.length) {
            return this.mResultArr[index];
        }
        return false;
    }

    public boolean getResultForName(String name) {
        return this.getResultForIndex(this.mResultNamesTable.get(name));
    }

    public boolean isAllTrue() {
        boolean result = true;
        for (boolean value : this.mResultArr) {
            result &= value;
        }
        return result;
    }

    public boolean isAllFalse() {
        boolean result = false;
        for (boolean value : this.mResultArr) {
            result |= value;
        }
        return !result;
    }

    public boolean isPartlyTrue() {
        boolean result = false;
        for (boolean value : this.mResultArr) {
            if (!value) continue;
            result = true;
            break;
        }
        return result;
    }

    public String toString() {
        Object result = "";
        for (int i = 0; i < this.mResultArr.length; ++i) {
            String name = this.mNamesResultTable.get(i);
            result = (String)result + i + (String)(name != null ? "[" + name + "]" : "") + ":" + this.mResultArr[i] + ",";
        }
        return result;
    }
}

